/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.s3control.model.DSSEKMSFilter;
import software.amazon.awssdk.services.s3control.model.NotSSEFilter;
import software.amazon.awssdk.services.s3control.model.SSECFilter;
import software.amazon.awssdk.services.s3control.model.SSEKMSFilter;
import software.amazon.awssdk.services.s3control.model.SSES3Filter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ObjectEncryptionFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ObjectEncryptionFilter> {
    private static final SdkField<SSES3Filter> SSES3_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SSES3").getter(ObjectEncryptionFilter.getter(ObjectEncryptionFilter::sses3)).setter(ObjectEncryptionFilter.setter(Builder::sses3)).constructor(SSES3Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SSE-S3").unmarshallLocationName("SSE-S3").build()}).build();
    private static final SdkField<SSEKMSFilter> SSEKMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SSEKMS").getter(ObjectEncryptionFilter.getter(ObjectEncryptionFilter::ssekms)).setter(ObjectEncryptionFilter.setter(Builder::ssekms)).constructor(SSEKMSFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SSE-KMS").unmarshallLocationName("SSE-KMS").build()}).build();
    private static final SdkField<DSSEKMSFilter> DSSEKMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DSSEKMS").getter(ObjectEncryptionFilter.getter(ObjectEncryptionFilter::dssekms)).setter(ObjectEncryptionFilter.setter(Builder::dssekms)).constructor(DSSEKMSFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DSSE-KMS").unmarshallLocationName("DSSE-KMS").build()}).build();
    private static final SdkField<SSECFilter> SSEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SSEC").getter(ObjectEncryptionFilter.getter(ObjectEncryptionFilter::ssec)).setter(ObjectEncryptionFilter.setter(Builder::ssec)).constructor(SSECFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SSE-C").unmarshallLocationName("SSE-C").build()}).build();
    private static final SdkField<NotSSEFilter> NOTSSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NOTSSE").getter(ObjectEncryptionFilter.getter(ObjectEncryptionFilter::notsse)).setter(ObjectEncryptionFilter.setter(Builder::notsse)).constructor(NotSSEFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NOT-SSE").unmarshallLocationName("NOT-SSE").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SSES3_FIELD, SSEKMS_FIELD, DSSEKMS_FIELD, SSEC_FIELD, NOTSSE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ObjectEncryptionFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final SSES3Filter sses3;
    private final SSEKMSFilter ssekms;
    private final DSSEKMSFilter dssekms;
    private final SSECFilter ssec;
    private final NotSSEFilter notsse;
    private final Type type;

    private ObjectEncryptionFilter(BuilderImpl builder) {
        this.sses3 = builder.sses3;
        this.ssekms = builder.ssekms;
        this.dssekms = builder.dssekms;
        this.ssec = builder.ssec;
        this.notsse = builder.notsse;
        this.type = builder.type;
    }

    public final SSES3Filter sses3() {
        return this.sses3;
    }

    public final SSEKMSFilter ssekms() {
        return this.ssekms;
    }

    public final DSSEKMSFilter dssekms() {
        return this.dssekms;
    }

    public final SSECFilter ssec() {
        return this.ssec;
    }

    public final NotSSEFilter notsse() {
        return this.notsse;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sses3());
        hashCode = 31 * hashCode + Objects.hashCode(this.ssekms());
        hashCode = 31 * hashCode + Objects.hashCode(this.dssekms());
        hashCode = 31 * hashCode + Objects.hashCode(this.ssec());
        hashCode = 31 * hashCode + Objects.hashCode(this.notsse());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObjectEncryptionFilter)) {
            return false;
        }
        ObjectEncryptionFilter other = (ObjectEncryptionFilter)obj;
        return Objects.equals(this.sses3(), other.sses3()) && Objects.equals(this.ssekms(), other.ssekms()) && Objects.equals(this.dssekms(), other.dssekms()) && Objects.equals(this.ssec(), other.ssec()) && Objects.equals(this.notsse(), other.notsse());
    }

    public final String toString() {
        return ToString.builder((String)"ObjectEncryptionFilter").add("SSES3", (Object)this.sses3()).add("SSEKMS", (Object)this.ssekms()).add("DSSEKMS", (Object)this.dssekms()).add("SSEC", (Object)this.ssec()).add("NOTSSE", (Object)this.notsse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SSES3": {
                return Optional.ofNullable(clazz.cast(this.sses3()));
            }
            case "SSEKMS": {
                return Optional.ofNullable(clazz.cast(this.ssekms()));
            }
            case "DSSEKMS": {
                return Optional.ofNullable(clazz.cast(this.dssekms()));
            }
            case "SSEC": {
                return Optional.ofNullable(clazz.cast(this.ssec()));
            }
            case "NOTSSE": {
                return Optional.ofNullable(clazz.cast(this.notsse()));
            }
        }
        return Optional.empty();
    }

    public static ObjectEncryptionFilter fromSses3(SSES3Filter sses3) {
        return (ObjectEncryptionFilter)ObjectEncryptionFilter.builder().sses3(sses3).build();
    }

    public static ObjectEncryptionFilter fromSses3(Consumer<SSES3Filter.Builder> sses3) {
        SSES3Filter.Builder builder = SSES3Filter.builder();
        sses3.accept(builder);
        return ObjectEncryptionFilter.fromSses3((SSES3Filter)builder.build());
    }

    public static ObjectEncryptionFilter fromSsekms(SSEKMSFilter ssekms) {
        return (ObjectEncryptionFilter)ObjectEncryptionFilter.builder().ssekms(ssekms).build();
    }

    public static ObjectEncryptionFilter fromSsekms(Consumer<SSEKMSFilter.Builder> ssekms) {
        SSEKMSFilter.Builder builder = SSEKMSFilter.builder();
        ssekms.accept(builder);
        return ObjectEncryptionFilter.fromSsekms((SSEKMSFilter)builder.build());
    }

    public static ObjectEncryptionFilter fromDssekms(DSSEKMSFilter dssekms) {
        return (ObjectEncryptionFilter)ObjectEncryptionFilter.builder().dssekms(dssekms).build();
    }

    public static ObjectEncryptionFilter fromDssekms(Consumer<DSSEKMSFilter.Builder> dssekms) {
        DSSEKMSFilter.Builder builder = DSSEKMSFilter.builder();
        dssekms.accept(builder);
        return ObjectEncryptionFilter.fromDssekms((DSSEKMSFilter)builder.build());
    }

    public static ObjectEncryptionFilter fromSsec(SSECFilter ssec) {
        return (ObjectEncryptionFilter)ObjectEncryptionFilter.builder().ssec(ssec).build();
    }

    public static ObjectEncryptionFilter fromSsec(Consumer<SSECFilter.Builder> ssec) {
        SSECFilter.Builder builder = SSECFilter.builder();
        ssec.accept(builder);
        return ObjectEncryptionFilter.fromSsec((SSECFilter)builder.build());
    }

    public static ObjectEncryptionFilter fromNotsse(NotSSEFilter notsse) {
        return (ObjectEncryptionFilter)ObjectEncryptionFilter.builder().notsse(notsse).build();
    }

    public static ObjectEncryptionFilter fromNotsse(Consumer<NotSSEFilter.Builder> notsse) {
        NotSSEFilter.Builder builder = NotSSEFilter.builder();
        notsse.accept(builder);
        return ObjectEncryptionFilter.fromNotsse((NotSSEFilter)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SSE-S3", SSES3_FIELD);
        map.put("SSE-KMS", SSEKMS_FIELD);
        map.put("DSSE-KMS", DSSEKMS_FIELD);
        map.put("SSE-C", SSEC_FIELD);
        map.put("NOT-SSE", NOTSSE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ObjectEncryptionFilter, T> g) {
        return obj -> g.apply((ObjectEncryptionFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        SSES3,
        SSEKMS,
        DSSEKMS,
        SSEC,
        NOTSSE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private SSES3Filter sses3;
        private SSEKMSFilter ssekms;
        private DSSEKMSFilter dssekms;
        private SSECFilter ssec;
        private NotSSEFilter notsse;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ObjectEncryptionFilter model) {
            this.sses3(model.sses3);
            this.ssekms(model.ssekms);
            this.dssekms(model.dssekms);
            this.ssec(model.ssec);
            this.notsse(model.notsse);
        }

        public final SSES3Filter.Builder getSses3() {
            return this.sses3 != null ? this.sses3.toBuilder() : null;
        }

        public final void setSses3(SSES3Filter.BuilderImpl sses3) {
            SSES3Filter oldValue = this.sses3;
            this.sses3 = sses3 != null ? sses3.build() : null;
            this.handleUnionValueChange(Type.SSES3, oldValue, this.sses3);
        }

        @Override
        public final Builder sses3(SSES3Filter sses3) {
            SSES3Filter oldValue = this.sses3;
            this.sses3 = sses3;
            this.handleUnionValueChange(Type.SSES3, oldValue, this.sses3);
            return this;
        }

        public final SSEKMSFilter.Builder getSsekms() {
            return this.ssekms != null ? this.ssekms.toBuilder() : null;
        }

        public final void setSsekms(SSEKMSFilter.BuilderImpl ssekms) {
            SSEKMSFilter oldValue = this.ssekms;
            this.ssekms = ssekms != null ? ssekms.build() : null;
            this.handleUnionValueChange(Type.SSEKMS, oldValue, this.ssekms);
        }

        @Override
        public final Builder ssekms(SSEKMSFilter ssekms) {
            SSEKMSFilter oldValue = this.ssekms;
            this.ssekms = ssekms;
            this.handleUnionValueChange(Type.SSEKMS, oldValue, this.ssekms);
            return this;
        }

        public final DSSEKMSFilter.Builder getDssekms() {
            return this.dssekms != null ? this.dssekms.toBuilder() : null;
        }

        public final void setDssekms(DSSEKMSFilter.BuilderImpl dssekms) {
            DSSEKMSFilter oldValue = this.dssekms;
            this.dssekms = dssekms != null ? dssekms.build() : null;
            this.handleUnionValueChange(Type.DSSEKMS, oldValue, this.dssekms);
        }

        @Override
        public final Builder dssekms(DSSEKMSFilter dssekms) {
            DSSEKMSFilter oldValue = this.dssekms;
            this.dssekms = dssekms;
            this.handleUnionValueChange(Type.DSSEKMS, oldValue, this.dssekms);
            return this;
        }

        public final SSECFilter.Builder getSsec() {
            return this.ssec != null ? this.ssec.toBuilder() : null;
        }

        public final void setSsec(SSECFilter.BuilderImpl ssec) {
            SSECFilter oldValue = this.ssec;
            this.ssec = ssec != null ? ssec.build() : null;
            this.handleUnionValueChange(Type.SSEC, oldValue, this.ssec);
        }

        @Override
        public final Builder ssec(SSECFilter ssec) {
            SSECFilter oldValue = this.ssec;
            this.ssec = ssec;
            this.handleUnionValueChange(Type.SSEC, oldValue, this.ssec);
            return this;
        }

        public final NotSSEFilter.Builder getNotsse() {
            return this.notsse != null ? this.notsse.toBuilder() : null;
        }

        public final void setNotsse(NotSSEFilter.BuilderImpl notsse) {
            NotSSEFilter oldValue = this.notsse;
            this.notsse = notsse != null ? notsse.build() : null;
            this.handleUnionValueChange(Type.NOTSSE, oldValue, this.notsse);
        }

        @Override
        public final Builder notsse(NotSSEFilter notsse) {
            NotSSEFilter oldValue = this.notsse;
            this.notsse = notsse;
            this.handleUnionValueChange(Type.NOTSSE, oldValue, this.notsse);
            return this;
        }

        public ObjectEncryptionFilter build() {
            return new ObjectEncryptionFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ObjectEncryptionFilter> {
        public Builder sses3(SSES3Filter var1);

        default public Builder sses3(Consumer<SSES3Filter.Builder> sses3) {
            return this.sses3((SSES3Filter)((SSES3Filter.Builder)SSES3Filter.builder().applyMutation(sses3)).build());
        }

        public Builder ssekms(SSEKMSFilter var1);

        default public Builder ssekms(Consumer<SSEKMSFilter.Builder> ssekms) {
            return this.ssekms((SSEKMSFilter)((SSEKMSFilter.Builder)SSEKMSFilter.builder().applyMutation(ssekms)).build());
        }

        public Builder dssekms(DSSEKMSFilter var1);

        default public Builder dssekms(Consumer<DSSEKMSFilter.Builder> dssekms) {
            return this.dssekms((DSSEKMSFilter)((DSSEKMSFilter.Builder)DSSEKMSFilter.builder().applyMutation(dssekms)).build());
        }

        public Builder ssec(SSECFilter var1);

        default public Builder ssec(Consumer<SSECFilter.Builder> ssec) {
            return this.ssec((SSECFilter)((SSECFilter.Builder)SSECFilter.builder().applyMutation(ssec)).build());
        }

        public Builder notsse(NotSSEFilter var1);

        default public Builder notsse(Consumer<NotSSEFilter.Builder> notsse) {
            return this.notsse((NotSSEFilter)((NotSSEFilter.Builder)NotSSEFilter.builder().applyMutation(notsse)).build());
        }
    }
}

