/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.s3control.model.AccessGrantsListCopier;
import software.amazon.awssdk.services.s3control.model.ListAccessGrantEntry;
import software.amazon.awssdk.services.s3control.model.S3ControlResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAccessGrantsResponse
extends S3ControlResponse
implements ToCopyableBuilder<Builder, ListAccessGrantsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAccessGrantsResponse.getter(ListAccessGrantsResponse::nextToken)).setter(ListAccessGrantsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("NextToken").build()}).build();
    private static final SdkField<List<ListAccessGrantEntry>> ACCESS_GRANTS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AccessGrantsList").getter(ListAccessGrantsResponse.getter(ListAccessGrantsResponse::accessGrantsList)).setter(ListAccessGrantsResponse.setter(Builder::accessGrantsList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessGrantsList").unmarshallLocationName("AccessGrantsList").build(), ListTrait.builder().memberLocationName("AccessGrant").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ListAccessGrantEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessGrant").unmarshallLocationName("AccessGrant").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, ACCESS_GRANTS_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAccessGrantsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<ListAccessGrantEntry> accessGrantsList;

    private ListAccessGrantsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.accessGrantsList = builder.accessGrantsList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasAccessGrantsList() {
        return this.accessGrantsList != null && !(this.accessGrantsList instanceof SdkAutoConstructList);
    }

    public final List<ListAccessGrantEntry> accessGrantsList() {
        return this.accessGrantsList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccessGrantsList() ? this.accessGrantsList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccessGrantsResponse)) {
            return false;
        }
        ListAccessGrantsResponse other = (ListAccessGrantsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasAccessGrantsList() == other.hasAccessGrantsList() && Objects.equals(this.accessGrantsList(), other.accessGrantsList());
    }

    public final String toString() {
        return ToString.builder((String)"ListAccessGrantsResponse").add("NextToken", (Object)this.nextToken()).add("AccessGrantsList", this.hasAccessGrantsList() ? this.accessGrantsList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "AccessGrantsList": {
                return Optional.ofNullable(clazz.cast(this.accessGrantsList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("AccessGrantsList", ACCESS_GRANTS_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAccessGrantsResponse, T> g) {
        return obj -> g.apply((ListAccessGrantsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3ControlResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ListAccessGrantEntry> accessGrantsList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccessGrantsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.accessGrantsList(model.accessGrantsList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ListAccessGrantEntry.Builder> getAccessGrantsList() {
            List<ListAccessGrantEntry.Builder> result = AccessGrantsListCopier.copyToBuilder(this.accessGrantsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccessGrantsList(Collection<ListAccessGrantEntry.BuilderImpl> accessGrantsList) {
            this.accessGrantsList = AccessGrantsListCopier.copyFromBuilder(accessGrantsList);
        }

        @Override
        public final Builder accessGrantsList(Collection<ListAccessGrantEntry> accessGrantsList) {
            this.accessGrantsList = AccessGrantsListCopier.copy(accessGrantsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessGrantsList(ListAccessGrantEntry ... accessGrantsList) {
            this.accessGrantsList(Arrays.asList(accessGrantsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessGrantsList(Consumer<ListAccessGrantEntry.Builder> ... accessGrantsList) {
            this.accessGrantsList(Stream.of(accessGrantsList).map(c -> (ListAccessGrantEntry)((ListAccessGrantEntry.Builder)ListAccessGrantEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListAccessGrantsResponse build() {
            return new ListAccessGrantsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends S3ControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAccessGrantsResponse> {
        public Builder nextToken(String var1);

        public Builder accessGrantsList(Collection<ListAccessGrantEntry> var1);

        public Builder accessGrantsList(ListAccessGrantEntry ... var1);

        public Builder accessGrantsList(Consumer<ListAccessGrantEntry.Builder> ... var1);
    }
}

