/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3control.model.GeneratedManifestEncryption;
import software.amazon.awssdk.services.s3control.model.GeneratedManifestFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3ManifestOutputLocation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3ManifestOutputLocation> {
    private static final SdkField<String> EXPECTED_MANIFEST_BUCKET_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExpectedManifestBucketOwner").getter(S3ManifestOutputLocation.getter(S3ManifestOutputLocation::expectedManifestBucketOwner)).setter(S3ManifestOutputLocation.setter(Builder::expectedManifestBucketOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpectedManifestBucketOwner").unmarshallLocationName("ExpectedManifestBucketOwner").build()}).build();
    private static final SdkField<String> BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Bucket").getter(S3ManifestOutputLocation.getter(S3ManifestOutputLocation::bucket)).setter(S3ManifestOutputLocation.setter(Builder::bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bucket").unmarshallLocationName("Bucket").build()}).build();
    private static final SdkField<String> MANIFEST_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManifestPrefix").getter(S3ManifestOutputLocation.getter(S3ManifestOutputLocation::manifestPrefix)).setter(S3ManifestOutputLocation.setter(Builder::manifestPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestPrefix").unmarshallLocationName("ManifestPrefix").build()}).build();
    private static final SdkField<GeneratedManifestEncryption> MANIFEST_ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ManifestEncryption").getter(S3ManifestOutputLocation.getter(S3ManifestOutputLocation::manifestEncryption)).setter(S3ManifestOutputLocation.setter(Builder::manifestEncryption)).constructor(GeneratedManifestEncryption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestEncryption").unmarshallLocationName("ManifestEncryption").build()}).build();
    private static final SdkField<String> MANIFEST_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManifestFormat").getter(S3ManifestOutputLocation.getter(S3ManifestOutputLocation::manifestFormatAsString)).setter(S3ManifestOutputLocation.setter(Builder::manifestFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestFormat").unmarshallLocationName("ManifestFormat").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPECTED_MANIFEST_BUCKET_OWNER_FIELD, BUCKET_FIELD, MANIFEST_PREFIX_FIELD, MANIFEST_ENCRYPTION_FIELD, MANIFEST_FORMAT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = S3ManifestOutputLocation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String expectedManifestBucketOwner;
    private final String bucket;
    private final String manifestPrefix;
    private final GeneratedManifestEncryption manifestEncryption;
    private final String manifestFormat;

    private S3ManifestOutputLocation(BuilderImpl builder) {
        this.expectedManifestBucketOwner = builder.expectedManifestBucketOwner;
        this.bucket = builder.bucket;
        this.manifestPrefix = builder.manifestPrefix;
        this.manifestEncryption = builder.manifestEncryption;
        this.manifestFormat = builder.manifestFormat;
    }

    public final String expectedManifestBucketOwner() {
        return this.expectedManifestBucketOwner;
    }

    public final String bucket() {
        return this.bucket;
    }

    public final String manifestPrefix() {
        return this.manifestPrefix;
    }

    public final GeneratedManifestEncryption manifestEncryption() {
        return this.manifestEncryption;
    }

    public final GeneratedManifestFormat manifestFormat() {
        return GeneratedManifestFormat.fromValue(this.manifestFormat);
    }

    public final String manifestFormatAsString() {
        return this.manifestFormat;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.expectedManifestBucketOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestEncryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestFormatAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ManifestOutputLocation)) {
            return false;
        }
        S3ManifestOutputLocation other = (S3ManifestOutputLocation)obj;
        return Objects.equals(this.expectedManifestBucketOwner(), other.expectedManifestBucketOwner()) && Objects.equals(this.bucket(), other.bucket()) && Objects.equals(this.manifestPrefix(), other.manifestPrefix()) && Objects.equals(this.manifestEncryption(), other.manifestEncryption()) && Objects.equals(this.manifestFormatAsString(), other.manifestFormatAsString());
    }

    public final String toString() {
        return ToString.builder((String)"S3ManifestOutputLocation").add("ExpectedManifestBucketOwner", (Object)this.expectedManifestBucketOwner()).add("Bucket", (Object)this.bucket()).add("ManifestPrefix", (Object)this.manifestPrefix()).add("ManifestEncryption", (Object)this.manifestEncryption()).add("ManifestFormat", (Object)this.manifestFormatAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExpectedManifestBucketOwner": {
                return Optional.ofNullable(clazz.cast(this.expectedManifestBucketOwner()));
            }
            case "Bucket": {
                return Optional.ofNullable(clazz.cast(this.bucket()));
            }
            case "ManifestPrefix": {
                return Optional.ofNullable(clazz.cast(this.manifestPrefix()));
            }
            case "ManifestEncryption": {
                return Optional.ofNullable(clazz.cast(this.manifestEncryption()));
            }
            case "ManifestFormat": {
                return Optional.ofNullable(clazz.cast(this.manifestFormatAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ExpectedManifestBucketOwner", EXPECTED_MANIFEST_BUCKET_OWNER_FIELD);
        map.put("Bucket", BUCKET_FIELD);
        map.put("ManifestPrefix", MANIFEST_PREFIX_FIELD);
        map.put("ManifestEncryption", MANIFEST_ENCRYPTION_FIELD);
        map.put("ManifestFormat", MANIFEST_FORMAT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3ManifestOutputLocation, T> g) {
        return obj -> g.apply((S3ManifestOutputLocation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String expectedManifestBucketOwner;
        private String bucket;
        private String manifestPrefix;
        private GeneratedManifestEncryption manifestEncryption;
        private String manifestFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(S3ManifestOutputLocation model) {
            this.expectedManifestBucketOwner(model.expectedManifestBucketOwner);
            this.bucket(model.bucket);
            this.manifestPrefix(model.manifestPrefix);
            this.manifestEncryption(model.manifestEncryption);
            this.manifestFormat(model.manifestFormat);
        }

        public final String getExpectedManifestBucketOwner() {
            return this.expectedManifestBucketOwner;
        }

        public final void setExpectedManifestBucketOwner(String expectedManifestBucketOwner) {
            this.expectedManifestBucketOwner = expectedManifestBucketOwner;
        }

        @Override
        public final Builder expectedManifestBucketOwner(String expectedManifestBucketOwner) {
            this.expectedManifestBucketOwner = expectedManifestBucketOwner;
            return this;
        }

        public final String getBucket() {
            return this.bucket;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final String getManifestPrefix() {
            return this.manifestPrefix;
        }

        public final void setManifestPrefix(String manifestPrefix) {
            this.manifestPrefix = manifestPrefix;
        }

        @Override
        public final Builder manifestPrefix(String manifestPrefix) {
            this.manifestPrefix = manifestPrefix;
            return this;
        }

        public final GeneratedManifestEncryption.Builder getManifestEncryption() {
            return this.manifestEncryption != null ? this.manifestEncryption.toBuilder() : null;
        }

        public final void setManifestEncryption(GeneratedManifestEncryption.BuilderImpl manifestEncryption) {
            this.manifestEncryption = manifestEncryption != null ? manifestEncryption.build() : null;
        }

        @Override
        public final Builder manifestEncryption(GeneratedManifestEncryption manifestEncryption) {
            this.manifestEncryption = manifestEncryption;
            return this;
        }

        public final String getManifestFormat() {
            return this.manifestFormat;
        }

        public final void setManifestFormat(String manifestFormat) {
            this.manifestFormat = manifestFormat;
        }

        @Override
        public final Builder manifestFormat(String manifestFormat) {
            this.manifestFormat = manifestFormat;
            return this;
        }

        @Override
        public final Builder manifestFormat(GeneratedManifestFormat manifestFormat) {
            this.manifestFormat(manifestFormat == null ? null : manifestFormat.toString());
            return this;
        }

        public S3ManifestOutputLocation build() {
            return new S3ManifestOutputLocation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3ManifestOutputLocation> {
        public Builder expectedManifestBucketOwner(String var1);

        public Builder bucket(String var1);

        public Builder manifestPrefix(String var1);

        public Builder manifestEncryption(GeneratedManifestEncryption var1);

        default public Builder manifestEncryption(Consumer<GeneratedManifestEncryption.Builder> manifestEncryption) {
            return this.manifestEncryption((GeneratedManifestEncryption)((GeneratedManifestEncryption.Builder)GeneratedManifestEncryption.builder().applyMutation(manifestEncryption)).build());
        }

        public Builder manifestFormat(String var1);

        public Builder manifestFormat(GeneratedManifestFormat var1);
    }
}

