/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3control.model.GranteeType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Grantee
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Grantee> {
    private static final SdkField<String> GRANTEE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GranteeType").getter(Grantee.getter(Grantee::granteeTypeAsString)).setter(Grantee.setter(Builder::granteeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GranteeType").unmarshallLocationName("GranteeType").build()}).build();
    private static final SdkField<String> GRANTEE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GranteeIdentifier").getter(Grantee.getter(Grantee::granteeIdentifier)).setter(Grantee.setter(Builder::granteeIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GranteeIdentifier").unmarshallLocationName("GranteeIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRANTEE_TYPE_FIELD, GRANTEE_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Grantee.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String granteeType;
    private final String granteeIdentifier;

    private Grantee(BuilderImpl builder) {
        this.granteeType = builder.granteeType;
        this.granteeIdentifier = builder.granteeIdentifier;
    }

    public final GranteeType granteeType() {
        return GranteeType.fromValue(this.granteeType);
    }

    public final String granteeTypeAsString() {
        return this.granteeType;
    }

    public final String granteeIdentifier() {
        return this.granteeIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.granteeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.granteeIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Grantee)) {
            return false;
        }
        Grantee other = (Grantee)obj;
        return Objects.equals(this.granteeTypeAsString(), other.granteeTypeAsString()) && Objects.equals(this.granteeIdentifier(), other.granteeIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"Grantee").add("GranteeType", (Object)this.granteeTypeAsString()).add("GranteeIdentifier", (Object)this.granteeIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GranteeType": {
                return Optional.ofNullable(clazz.cast(this.granteeTypeAsString()));
            }
            case "GranteeIdentifier": {
                return Optional.ofNullable(clazz.cast(this.granteeIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("GranteeType", GRANTEE_TYPE_FIELD);
        map.put("GranteeIdentifier", GRANTEE_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Grantee, T> g) {
        return obj -> g.apply((Grantee)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String granteeType;
        private String granteeIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(Grantee model) {
            this.granteeType(model.granteeType);
            this.granteeIdentifier(model.granteeIdentifier);
        }

        public final String getGranteeType() {
            return this.granteeType;
        }

        public final void setGranteeType(String granteeType) {
            this.granteeType = granteeType;
        }

        @Override
        public final Builder granteeType(String granteeType) {
            this.granteeType = granteeType;
            return this;
        }

        @Override
        public final Builder granteeType(GranteeType granteeType) {
            this.granteeType(granteeType == null ? null : granteeType.toString());
            return this;
        }

        public final String getGranteeIdentifier() {
            return this.granteeIdentifier;
        }

        public final void setGranteeIdentifier(String granteeIdentifier) {
            this.granteeIdentifier = granteeIdentifier;
        }

        @Override
        public final Builder granteeIdentifier(String granteeIdentifier) {
            this.granteeIdentifier = granteeIdentifier;
            return this;
        }

        public Grantee build() {
            return new Grantee(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Grantee> {
        public Builder granteeType(String var1);

        public Builder granteeType(GranteeType var1);

        public Builder granteeIdentifier(String var1);
    }
}

