/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.s3control.model.EndpointsCopier;
import software.amazon.awssdk.services.s3control.model.NetworkOrigin;
import software.amazon.awssdk.services.s3control.model.PublicAccessBlockConfiguration;
import software.amazon.awssdk.services.s3control.model.S3ControlResponse;
import software.amazon.awssdk.services.s3control.model.VpcConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAccessPointResponse
extends S3ControlResponse
implements ToCopyableBuilder<Builder, GetAccessPointResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GetAccessPointResponse.getter(GetAccessPointResponse::name)).setter(GetAccessPointResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").unmarshallLocationName("Name").build()}).build();
    private static final SdkField<String> BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Bucket").getter(GetAccessPointResponse.getter(GetAccessPointResponse::bucket)).setter(GetAccessPointResponse.setter(Builder::bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bucket").unmarshallLocationName("Bucket").build()}).build();
    private static final SdkField<String> NETWORK_ORIGIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkOrigin").getter(GetAccessPointResponse.getter(GetAccessPointResponse::networkOriginAsString)).setter(GetAccessPointResponse.setter(Builder::networkOrigin)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkOrigin").unmarshallLocationName("NetworkOrigin").build()}).build();
    private static final SdkField<VpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConfiguration").getter(GetAccessPointResponse.getter(GetAccessPointResponse::vpcConfiguration)).setter(GetAccessPointResponse.setter(Builder::vpcConfiguration)).constructor(VpcConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfiguration").unmarshallLocationName("VpcConfiguration").build()}).build();
    private static final SdkField<PublicAccessBlockConfiguration> PUBLIC_ACCESS_BLOCK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PublicAccessBlockConfiguration").getter(GetAccessPointResponse.getter(GetAccessPointResponse::publicAccessBlockConfiguration)).setter(GetAccessPointResponse.setter(Builder::publicAccessBlockConfiguration)).constructor(PublicAccessBlockConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicAccessBlockConfiguration").unmarshallLocationName("PublicAccessBlockConfiguration").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationDate").getter(GetAccessPointResponse.getter(GetAccessPointResponse::creationDate)).setter(GetAccessPointResponse.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").unmarshallLocationName("CreationDate").build()}).build();
    private static final SdkField<String> ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Alias").getter(GetAccessPointResponse.getter(GetAccessPointResponse::alias)).setter(GetAccessPointResponse.setter(Builder::alias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alias").unmarshallLocationName("Alias").build()}).build();
    private static final SdkField<String> ACCESS_POINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessPointArn").getter(GetAccessPointResponse.getter(GetAccessPointResponse::accessPointArn)).setter(GetAccessPointResponse.setter(Builder::accessPointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessPointArn").unmarshallLocationName("AccessPointArn").build()}).build();
    private static final SdkField<Map<String, String>> ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Endpoints").getter(GetAccessPointResponse.getter(GetAccessPointResponse::endpoints)).setter(GetAccessPointResponse.setter(Builder::endpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoints").unmarshallLocationName("Endpoints").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").unmarshallLocationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> BUCKET_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BucketAccountId").getter(GetAccessPointResponse.getter(GetAccessPointResponse::bucketAccountId)).setter(GetAccessPointResponse.setter(Builder::bucketAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketAccountId").unmarshallLocationName("BucketAccountId").build()}).build();
    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSourceId").getter(GetAccessPointResponse.getter(GetAccessPointResponse::dataSourceId)).setter(GetAccessPointResponse.setter(Builder::dataSourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceId").unmarshallLocationName("DataSourceId").build()}).build();
    private static final SdkField<String> DATA_SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSourceType").getter(GetAccessPointResponse.getter(GetAccessPointResponse::dataSourceType)).setter(GetAccessPointResponse.setter(Builder::dataSourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceType").unmarshallLocationName("DataSourceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, BUCKET_FIELD, NETWORK_ORIGIN_FIELD, VPC_CONFIGURATION_FIELD, PUBLIC_ACCESS_BLOCK_CONFIGURATION_FIELD, CREATION_DATE_FIELD, ALIAS_FIELD, ACCESS_POINT_ARN_FIELD, ENDPOINTS_FIELD, BUCKET_ACCOUNT_ID_FIELD, DATA_SOURCE_ID_FIELD, DATA_SOURCE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetAccessPointResponse.memberNameToFieldInitializer();
    private final String name;
    private final String bucket;
    private final String networkOrigin;
    private final VpcConfiguration vpcConfiguration;
    private final PublicAccessBlockConfiguration publicAccessBlockConfiguration;
    private final Instant creationDate;
    private final String alias;
    private final String accessPointArn;
    private final Map<String, String> endpoints;
    private final String bucketAccountId;
    private final String dataSourceId;
    private final String dataSourceType;

    private GetAccessPointResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.bucket = builder.bucket;
        this.networkOrigin = builder.networkOrigin;
        this.vpcConfiguration = builder.vpcConfiguration;
        this.publicAccessBlockConfiguration = builder.publicAccessBlockConfiguration;
        this.creationDate = builder.creationDate;
        this.alias = builder.alias;
        this.accessPointArn = builder.accessPointArn;
        this.endpoints = builder.endpoints;
        this.bucketAccountId = builder.bucketAccountId;
        this.dataSourceId = builder.dataSourceId;
        this.dataSourceType = builder.dataSourceType;
    }

    public final String name() {
        return this.name;
    }

    public final String bucket() {
        return this.bucket;
    }

    public final NetworkOrigin networkOrigin() {
        return NetworkOrigin.fromValue(this.networkOrigin);
    }

    public final String networkOriginAsString() {
        return this.networkOrigin;
    }

    public final VpcConfiguration vpcConfiguration() {
        return this.vpcConfiguration;
    }

    public final PublicAccessBlockConfiguration publicAccessBlockConfiguration() {
        return this.publicAccessBlockConfiguration;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final String alias() {
        return this.alias;
    }

    public final String accessPointArn() {
        return this.accessPointArn;
    }

    public final boolean hasEndpoints() {
        return this.endpoints != null && !(this.endpoints instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> endpoints() {
        return this.endpoints;
    }

    public final String bucketAccountId() {
        return this.bucketAccountId;
    }

    public final String dataSourceId() {
        return this.dataSourceId;
    }

    public final String dataSourceType() {
        return this.dataSourceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkOriginAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicAccessBlockConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.alias());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEndpoints() ? this.endpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccessPointResponse)) {
            return false;
        }
        GetAccessPointResponse other = (GetAccessPointResponse)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.bucket(), other.bucket()) && Objects.equals(this.networkOriginAsString(), other.networkOriginAsString()) && Objects.equals(this.vpcConfiguration(), other.vpcConfiguration()) && Objects.equals(this.publicAccessBlockConfiguration(), other.publicAccessBlockConfiguration()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.alias(), other.alias()) && Objects.equals(this.accessPointArn(), other.accessPointArn()) && this.hasEndpoints() == other.hasEndpoints() && Objects.equals(this.endpoints(), other.endpoints()) && Objects.equals(this.bucketAccountId(), other.bucketAccountId()) && Objects.equals(this.dataSourceId(), other.dataSourceId()) && Objects.equals(this.dataSourceType(), other.dataSourceType());
    }

    public final String toString() {
        return ToString.builder((String)"GetAccessPointResponse").add("Name", (Object)this.name()).add("Bucket", (Object)this.bucket()).add("NetworkOrigin", (Object)this.networkOriginAsString()).add("VpcConfiguration", (Object)this.vpcConfiguration()).add("PublicAccessBlockConfiguration", (Object)this.publicAccessBlockConfiguration()).add("CreationDate", (Object)this.creationDate()).add("Alias", (Object)this.alias()).add("AccessPointArn", (Object)this.accessPointArn()).add("Endpoints", this.hasEndpoints() ? this.endpoints() : null).add("BucketAccountId", (Object)this.bucketAccountId()).add("DataSourceId", (Object)this.dataSourceId()).add("DataSourceType", (Object)this.dataSourceType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Bucket": {
                return Optional.ofNullable(clazz.cast(this.bucket()));
            }
            case "NetworkOrigin": {
                return Optional.ofNullable(clazz.cast(this.networkOriginAsString()));
            }
            case "VpcConfiguration": {
                return Optional.ofNullable(clazz.cast(this.vpcConfiguration()));
            }
            case "PublicAccessBlockConfiguration": {
                return Optional.ofNullable(clazz.cast(this.publicAccessBlockConfiguration()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "Alias": {
                return Optional.ofNullable(clazz.cast(this.alias()));
            }
            case "AccessPointArn": {
                return Optional.ofNullable(clazz.cast(this.accessPointArn()));
            }
            case "Endpoints": {
                return Optional.ofNullable(clazz.cast(this.endpoints()));
            }
            case "BucketAccountId": {
                return Optional.ofNullable(clazz.cast(this.bucketAccountId()));
            }
            case "DataSourceId": {
                return Optional.ofNullable(clazz.cast(this.dataSourceId()));
            }
            case "DataSourceType": {
                return Optional.ofNullable(clazz.cast(this.dataSourceType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Bucket", BUCKET_FIELD);
        map.put("NetworkOrigin", NETWORK_ORIGIN_FIELD);
        map.put("VpcConfiguration", VPC_CONFIGURATION_FIELD);
        map.put("PublicAccessBlockConfiguration", PUBLIC_ACCESS_BLOCK_CONFIGURATION_FIELD);
        map.put("CreationDate", CREATION_DATE_FIELD);
        map.put("Alias", ALIAS_FIELD);
        map.put("AccessPointArn", ACCESS_POINT_ARN_FIELD);
        map.put("Endpoints", ENDPOINTS_FIELD);
        map.put("BucketAccountId", BUCKET_ACCOUNT_ID_FIELD);
        map.put("DataSourceId", DATA_SOURCE_ID_FIELD);
        map.put("DataSourceType", DATA_SOURCE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAccessPointResponse, T> g) {
        return obj -> g.apply((GetAccessPointResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3ControlResponse.BuilderImpl
    implements Builder {
        private String name;
        private String bucket;
        private String networkOrigin;
        private VpcConfiguration vpcConfiguration;
        private PublicAccessBlockConfiguration publicAccessBlockConfiguration;
        private Instant creationDate;
        private String alias;
        private String accessPointArn;
        private Map<String, String> endpoints = DefaultSdkAutoConstructMap.getInstance();
        private String bucketAccountId;
        private String dataSourceId;
        private String dataSourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccessPointResponse model) {
            super(model);
            this.name(model.name);
            this.bucket(model.bucket);
            this.networkOrigin(model.networkOrigin);
            this.vpcConfiguration(model.vpcConfiguration);
            this.publicAccessBlockConfiguration(model.publicAccessBlockConfiguration);
            this.creationDate(model.creationDate);
            this.alias(model.alias);
            this.accessPointArn(model.accessPointArn);
            this.endpoints(model.endpoints);
            this.bucketAccountId(model.bucketAccountId);
            this.dataSourceId(model.dataSourceId);
            this.dataSourceType(model.dataSourceType);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getBucket() {
            return this.bucket;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final String getNetworkOrigin() {
            return this.networkOrigin;
        }

        public final void setNetworkOrigin(String networkOrigin) {
            this.networkOrigin = networkOrigin;
        }

        @Override
        public final Builder networkOrigin(String networkOrigin) {
            this.networkOrigin = networkOrigin;
            return this;
        }

        @Override
        public final Builder networkOrigin(NetworkOrigin networkOrigin) {
            this.networkOrigin(networkOrigin == null ? null : networkOrigin.toString());
            return this;
        }

        public final VpcConfiguration.Builder getVpcConfiguration() {
            return this.vpcConfiguration != null ? this.vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(VpcConfiguration.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        @Override
        public final Builder vpcConfiguration(VpcConfiguration vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        public final PublicAccessBlockConfiguration.Builder getPublicAccessBlockConfiguration() {
            return this.publicAccessBlockConfiguration != null ? this.publicAccessBlockConfiguration.toBuilder() : null;
        }

        public final void setPublicAccessBlockConfiguration(PublicAccessBlockConfiguration.BuilderImpl publicAccessBlockConfiguration) {
            this.publicAccessBlockConfiguration = publicAccessBlockConfiguration != null ? publicAccessBlockConfiguration.build() : null;
        }

        @Override
        public final Builder publicAccessBlockConfiguration(PublicAccessBlockConfiguration publicAccessBlockConfiguration) {
            this.publicAccessBlockConfiguration = publicAccessBlockConfiguration;
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getAlias() {
            return this.alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final String getAccessPointArn() {
            return this.accessPointArn;
        }

        public final void setAccessPointArn(String accessPointArn) {
            this.accessPointArn = accessPointArn;
        }

        @Override
        public final Builder accessPointArn(String accessPointArn) {
            this.accessPointArn = accessPointArn;
            return this;
        }

        public final Map<String, String> getEndpoints() {
            if (this.endpoints instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.endpoints;
        }

        public final void setEndpoints(Map<String, String> endpoints) {
            this.endpoints = EndpointsCopier.copy(endpoints);
        }

        @Override
        public final Builder endpoints(Map<String, String> endpoints) {
            this.endpoints = EndpointsCopier.copy(endpoints);
            return this;
        }

        public final String getBucketAccountId() {
            return this.bucketAccountId;
        }

        public final void setBucketAccountId(String bucketAccountId) {
            this.bucketAccountId = bucketAccountId;
        }

        @Override
        public final Builder bucketAccountId(String bucketAccountId) {
            this.bucketAccountId = bucketAccountId;
            return this;
        }

        public final String getDataSourceId() {
            return this.dataSourceId;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final String getDataSourceType() {
            return this.dataSourceType;
        }

        public final void setDataSourceType(String dataSourceType) {
            this.dataSourceType = dataSourceType;
        }

        @Override
        public final Builder dataSourceType(String dataSourceType) {
            this.dataSourceType = dataSourceType;
            return this;
        }

        @Override
        public GetAccessPointResponse build() {
            return new GetAccessPointResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends S3ControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAccessPointResponse> {
        public Builder name(String var1);

        public Builder bucket(String var1);

        public Builder networkOrigin(String var1);

        public Builder networkOrigin(NetworkOrigin var1);

        public Builder vpcConfiguration(VpcConfiguration var1);

        default public Builder vpcConfiguration(Consumer<VpcConfiguration.Builder> vpcConfiguration) {
            return this.vpcConfiguration((VpcConfiguration)((VpcConfiguration.Builder)VpcConfiguration.builder().applyMutation(vpcConfiguration)).build());
        }

        public Builder publicAccessBlockConfiguration(PublicAccessBlockConfiguration var1);

        default public Builder publicAccessBlockConfiguration(Consumer<PublicAccessBlockConfiguration.Builder> publicAccessBlockConfiguration) {
            return this.publicAccessBlockConfiguration((PublicAccessBlockConfiguration)((PublicAccessBlockConfiguration.Builder)PublicAccessBlockConfiguration.builder().applyMutation(publicAccessBlockConfiguration)).build());
        }

        public Builder creationDate(Instant var1);

        public Builder alias(String var1);

        public Builder accessPointArn(String var1);

        public Builder endpoints(Map<String, String> var1);

        public Builder bucketAccountId(String var1);

        public Builder dataSourceId(String var1);

        public Builder dataSourceType(String var1);
    }
}

