/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ComputeObjectChecksumType {
    FULL_OBJECT("FULL_OBJECT"),
    COMPOSITE("COMPOSITE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ComputeObjectChecksumType> VALUE_MAP;
    private final String value;

    private ComputeObjectChecksumType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ComputeObjectChecksumType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ComputeObjectChecksumType> knownValues() {
        EnumSet<ComputeObjectChecksumType> knownValues = EnumSet.allOf(ComputeObjectChecksumType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ComputeObjectChecksumType.class, ComputeObjectChecksumType::toString);
    }
}

