/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3control.model.LambdaInvokeOperation;
import software.amazon.awssdk.services.s3control.model.S3CopyObjectOperation;
import software.amazon.awssdk.services.s3control.model.S3DeleteObjectTaggingOperation;
import software.amazon.awssdk.services.s3control.model.S3InitiateRestoreObjectOperation;
import software.amazon.awssdk.services.s3control.model.S3ReplicateObjectOperation;
import software.amazon.awssdk.services.s3control.model.S3SetObjectAclOperation;
import software.amazon.awssdk.services.s3control.model.S3SetObjectLegalHoldOperation;
import software.amazon.awssdk.services.s3control.model.S3SetObjectRetentionOperation;
import software.amazon.awssdk.services.s3control.model.S3SetObjectTaggingOperation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobOperation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobOperation> {
    private static final SdkField<LambdaInvokeOperation> LAMBDA_INVOKE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LambdaInvoke").getter(JobOperation.getter(JobOperation::lambdaInvoke)).setter(JobOperation.setter(Builder::lambdaInvoke)).constructor(LambdaInvokeOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaInvoke").unmarshallLocationName("LambdaInvoke").build()}).build();
    private static final SdkField<S3CopyObjectOperation> S3_PUT_OBJECT_COPY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3PutObjectCopy").getter(JobOperation.getter(JobOperation::s3PutObjectCopy)).setter(JobOperation.setter(Builder::s3PutObjectCopy)).constructor(S3CopyObjectOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3PutObjectCopy").unmarshallLocationName("S3PutObjectCopy").build()}).build();
    private static final SdkField<S3SetObjectAclOperation> S3_PUT_OBJECT_ACL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3PutObjectAcl").getter(JobOperation.getter(JobOperation::s3PutObjectAcl)).setter(JobOperation.setter(Builder::s3PutObjectAcl)).constructor(S3SetObjectAclOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3PutObjectAcl").unmarshallLocationName("S3PutObjectAcl").build()}).build();
    private static final SdkField<S3SetObjectTaggingOperation> S3_PUT_OBJECT_TAGGING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3PutObjectTagging").getter(JobOperation.getter(JobOperation::s3PutObjectTagging)).setter(JobOperation.setter(Builder::s3PutObjectTagging)).constructor(S3SetObjectTaggingOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3PutObjectTagging").unmarshallLocationName("S3PutObjectTagging").build()}).build();
    private static final SdkField<S3DeleteObjectTaggingOperation> S3_DELETE_OBJECT_TAGGING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3DeleteObjectTagging").getter(JobOperation.getter(JobOperation::s3DeleteObjectTagging)).setter(JobOperation.setter(Builder::s3DeleteObjectTagging)).constructor(S3DeleteObjectTaggingOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3DeleteObjectTagging").unmarshallLocationName("S3DeleteObjectTagging").build()}).build();
    private static final SdkField<S3InitiateRestoreObjectOperation> S3_INITIATE_RESTORE_OBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3InitiateRestoreObject").getter(JobOperation.getter(JobOperation::s3InitiateRestoreObject)).setter(JobOperation.setter(Builder::s3InitiateRestoreObject)).constructor(S3InitiateRestoreObjectOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3InitiateRestoreObject").unmarshallLocationName("S3InitiateRestoreObject").build()}).build();
    private static final SdkField<S3SetObjectLegalHoldOperation> S3_PUT_OBJECT_LEGAL_HOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3PutObjectLegalHold").getter(JobOperation.getter(JobOperation::s3PutObjectLegalHold)).setter(JobOperation.setter(Builder::s3PutObjectLegalHold)).constructor(S3SetObjectLegalHoldOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3PutObjectLegalHold").unmarshallLocationName("S3PutObjectLegalHold").build()}).build();
    private static final SdkField<S3SetObjectRetentionOperation> S3_PUT_OBJECT_RETENTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3PutObjectRetention").getter(JobOperation.getter(JobOperation::s3PutObjectRetention)).setter(JobOperation.setter(Builder::s3PutObjectRetention)).constructor(S3SetObjectRetentionOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3PutObjectRetention").unmarshallLocationName("S3PutObjectRetention").build()}).build();
    private static final SdkField<S3ReplicateObjectOperation> S3_REPLICATE_OBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3ReplicateObject").getter(JobOperation.getter(JobOperation::s3ReplicateObject)).setter(JobOperation.setter(Builder::s3ReplicateObject)).constructor(S3ReplicateObjectOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3ReplicateObject").unmarshallLocationName("S3ReplicateObject").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAMBDA_INVOKE_FIELD, S3_PUT_OBJECT_COPY_FIELD, S3_PUT_OBJECT_ACL_FIELD, S3_PUT_OBJECT_TAGGING_FIELD, S3_DELETE_OBJECT_TAGGING_FIELD, S3_INITIATE_RESTORE_OBJECT_FIELD, S3_PUT_OBJECT_LEGAL_HOLD_FIELD, S3_PUT_OBJECT_RETENTION_FIELD, S3_REPLICATE_OBJECT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = JobOperation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final LambdaInvokeOperation lambdaInvoke;
    private final S3CopyObjectOperation s3PutObjectCopy;
    private final S3SetObjectAclOperation s3PutObjectAcl;
    private final S3SetObjectTaggingOperation s3PutObjectTagging;
    private final S3DeleteObjectTaggingOperation s3DeleteObjectTagging;
    private final S3InitiateRestoreObjectOperation s3InitiateRestoreObject;
    private final S3SetObjectLegalHoldOperation s3PutObjectLegalHold;
    private final S3SetObjectRetentionOperation s3PutObjectRetention;
    private final S3ReplicateObjectOperation s3ReplicateObject;

    private JobOperation(BuilderImpl builder) {
        this.lambdaInvoke = builder.lambdaInvoke;
        this.s3PutObjectCopy = builder.s3PutObjectCopy;
        this.s3PutObjectAcl = builder.s3PutObjectAcl;
        this.s3PutObjectTagging = builder.s3PutObjectTagging;
        this.s3DeleteObjectTagging = builder.s3DeleteObjectTagging;
        this.s3InitiateRestoreObject = builder.s3InitiateRestoreObject;
        this.s3PutObjectLegalHold = builder.s3PutObjectLegalHold;
        this.s3PutObjectRetention = builder.s3PutObjectRetention;
        this.s3ReplicateObject = builder.s3ReplicateObject;
    }

    public final LambdaInvokeOperation lambdaInvoke() {
        return this.lambdaInvoke;
    }

    public final S3CopyObjectOperation s3PutObjectCopy() {
        return this.s3PutObjectCopy;
    }

    public final S3SetObjectAclOperation s3PutObjectAcl() {
        return this.s3PutObjectAcl;
    }

    public final S3SetObjectTaggingOperation s3PutObjectTagging() {
        return this.s3PutObjectTagging;
    }

    public final S3DeleteObjectTaggingOperation s3DeleteObjectTagging() {
        return this.s3DeleteObjectTagging;
    }

    public final S3InitiateRestoreObjectOperation s3InitiateRestoreObject() {
        return this.s3InitiateRestoreObject;
    }

    public final S3SetObjectLegalHoldOperation s3PutObjectLegalHold() {
        return this.s3PutObjectLegalHold;
    }

    public final S3SetObjectRetentionOperation s3PutObjectRetention() {
        return this.s3PutObjectRetention;
    }

    public final S3ReplicateObjectOperation s3ReplicateObject() {
        return this.s3ReplicateObject;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaInvoke());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3PutObjectCopy());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3PutObjectAcl());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3PutObjectTagging());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3DeleteObjectTagging());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3InitiateRestoreObject());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3PutObjectLegalHold());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3PutObjectRetention());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3ReplicateObject());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobOperation)) {
            return false;
        }
        JobOperation other = (JobOperation)obj;
        return Objects.equals(this.lambdaInvoke(), other.lambdaInvoke()) && Objects.equals(this.s3PutObjectCopy(), other.s3PutObjectCopy()) && Objects.equals(this.s3PutObjectAcl(), other.s3PutObjectAcl()) && Objects.equals(this.s3PutObjectTagging(), other.s3PutObjectTagging()) && Objects.equals(this.s3DeleteObjectTagging(), other.s3DeleteObjectTagging()) && Objects.equals(this.s3InitiateRestoreObject(), other.s3InitiateRestoreObject()) && Objects.equals(this.s3PutObjectLegalHold(), other.s3PutObjectLegalHold()) && Objects.equals(this.s3PutObjectRetention(), other.s3PutObjectRetention()) && Objects.equals(this.s3ReplicateObject(), other.s3ReplicateObject());
    }

    public final String toString() {
        return ToString.builder((String)"JobOperation").add("LambdaInvoke", (Object)this.lambdaInvoke()).add("S3PutObjectCopy", (Object)this.s3PutObjectCopy()).add("S3PutObjectAcl", (Object)this.s3PutObjectAcl()).add("S3PutObjectTagging", (Object)this.s3PutObjectTagging()).add("S3DeleteObjectTagging", (Object)this.s3DeleteObjectTagging()).add("S3InitiateRestoreObject", (Object)this.s3InitiateRestoreObject()).add("S3PutObjectLegalHold", (Object)this.s3PutObjectLegalHold()).add("S3PutObjectRetention", (Object)this.s3PutObjectRetention()).add("S3ReplicateObject", (Object)this.s3ReplicateObject()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LambdaInvoke": {
                return Optional.ofNullable(clazz.cast(this.lambdaInvoke()));
            }
            case "S3PutObjectCopy": {
                return Optional.ofNullable(clazz.cast(this.s3PutObjectCopy()));
            }
            case "S3PutObjectAcl": {
                return Optional.ofNullable(clazz.cast(this.s3PutObjectAcl()));
            }
            case "S3PutObjectTagging": {
                return Optional.ofNullable(clazz.cast(this.s3PutObjectTagging()));
            }
            case "S3DeleteObjectTagging": {
                return Optional.ofNullable(clazz.cast(this.s3DeleteObjectTagging()));
            }
            case "S3InitiateRestoreObject": {
                return Optional.ofNullable(clazz.cast(this.s3InitiateRestoreObject()));
            }
            case "S3PutObjectLegalHold": {
                return Optional.ofNullable(clazz.cast(this.s3PutObjectLegalHold()));
            }
            case "S3PutObjectRetention": {
                return Optional.ofNullable(clazz.cast(this.s3PutObjectRetention()));
            }
            case "S3ReplicateObject": {
                return Optional.ofNullable(clazz.cast(this.s3ReplicateObject()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LambdaInvoke", LAMBDA_INVOKE_FIELD);
        map.put("S3PutObjectCopy", S3_PUT_OBJECT_COPY_FIELD);
        map.put("S3PutObjectAcl", S3_PUT_OBJECT_ACL_FIELD);
        map.put("S3PutObjectTagging", S3_PUT_OBJECT_TAGGING_FIELD);
        map.put("S3DeleteObjectTagging", S3_DELETE_OBJECT_TAGGING_FIELD);
        map.put("S3InitiateRestoreObject", S3_INITIATE_RESTORE_OBJECT_FIELD);
        map.put("S3PutObjectLegalHold", S3_PUT_OBJECT_LEGAL_HOLD_FIELD);
        map.put("S3PutObjectRetention", S3_PUT_OBJECT_RETENTION_FIELD);
        map.put("S3ReplicateObject", S3_REPLICATE_OBJECT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JobOperation, T> g) {
        return obj -> g.apply((JobOperation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private LambdaInvokeOperation lambdaInvoke;
        private S3CopyObjectOperation s3PutObjectCopy;
        private S3SetObjectAclOperation s3PutObjectAcl;
        private S3SetObjectTaggingOperation s3PutObjectTagging;
        private S3DeleteObjectTaggingOperation s3DeleteObjectTagging;
        private S3InitiateRestoreObjectOperation s3InitiateRestoreObject;
        private S3SetObjectLegalHoldOperation s3PutObjectLegalHold;
        private S3SetObjectRetentionOperation s3PutObjectRetention;
        private S3ReplicateObjectOperation s3ReplicateObject;

        private BuilderImpl() {
        }

        private BuilderImpl(JobOperation model) {
            this.lambdaInvoke(model.lambdaInvoke);
            this.s3PutObjectCopy(model.s3PutObjectCopy);
            this.s3PutObjectAcl(model.s3PutObjectAcl);
            this.s3PutObjectTagging(model.s3PutObjectTagging);
            this.s3DeleteObjectTagging(model.s3DeleteObjectTagging);
            this.s3InitiateRestoreObject(model.s3InitiateRestoreObject);
            this.s3PutObjectLegalHold(model.s3PutObjectLegalHold);
            this.s3PutObjectRetention(model.s3PutObjectRetention);
            this.s3ReplicateObject(model.s3ReplicateObject);
        }

        public final LambdaInvokeOperation.Builder getLambdaInvoke() {
            return this.lambdaInvoke != null ? this.lambdaInvoke.toBuilder() : null;
        }

        public final void setLambdaInvoke(LambdaInvokeOperation.BuilderImpl lambdaInvoke) {
            this.lambdaInvoke = lambdaInvoke != null ? lambdaInvoke.build() : null;
        }

        @Override
        public final Builder lambdaInvoke(LambdaInvokeOperation lambdaInvoke) {
            this.lambdaInvoke = lambdaInvoke;
            return this;
        }

        public final S3CopyObjectOperation.Builder getS3PutObjectCopy() {
            return this.s3PutObjectCopy != null ? this.s3PutObjectCopy.toBuilder() : null;
        }

        public final void setS3PutObjectCopy(S3CopyObjectOperation.BuilderImpl s3PutObjectCopy) {
            this.s3PutObjectCopy = s3PutObjectCopy != null ? s3PutObjectCopy.build() : null;
        }

        @Override
        public final Builder s3PutObjectCopy(S3CopyObjectOperation s3PutObjectCopy) {
            this.s3PutObjectCopy = s3PutObjectCopy;
            return this;
        }

        public final S3SetObjectAclOperation.Builder getS3PutObjectAcl() {
            return this.s3PutObjectAcl != null ? this.s3PutObjectAcl.toBuilder() : null;
        }

        public final void setS3PutObjectAcl(S3SetObjectAclOperation.BuilderImpl s3PutObjectAcl) {
            this.s3PutObjectAcl = s3PutObjectAcl != null ? s3PutObjectAcl.build() : null;
        }

        @Override
        public final Builder s3PutObjectAcl(S3SetObjectAclOperation s3PutObjectAcl) {
            this.s3PutObjectAcl = s3PutObjectAcl;
            return this;
        }

        public final S3SetObjectTaggingOperation.Builder getS3PutObjectTagging() {
            return this.s3PutObjectTagging != null ? this.s3PutObjectTagging.toBuilder() : null;
        }

        public final void setS3PutObjectTagging(S3SetObjectTaggingOperation.BuilderImpl s3PutObjectTagging) {
            this.s3PutObjectTagging = s3PutObjectTagging != null ? s3PutObjectTagging.build() : null;
        }

        @Override
        public final Builder s3PutObjectTagging(S3SetObjectTaggingOperation s3PutObjectTagging) {
            this.s3PutObjectTagging = s3PutObjectTagging;
            return this;
        }

        public final S3DeleteObjectTaggingOperation.Builder getS3DeleteObjectTagging() {
            return this.s3DeleteObjectTagging != null ? this.s3DeleteObjectTagging.toBuilder() : null;
        }

        public final void setS3DeleteObjectTagging(S3DeleteObjectTaggingOperation.BuilderImpl s3DeleteObjectTagging) {
            this.s3DeleteObjectTagging = s3DeleteObjectTagging != null ? s3DeleteObjectTagging.build() : null;
        }

        @Override
        public final Builder s3DeleteObjectTagging(S3DeleteObjectTaggingOperation s3DeleteObjectTagging) {
            this.s3DeleteObjectTagging = s3DeleteObjectTagging;
            return this;
        }

        public final S3InitiateRestoreObjectOperation.Builder getS3InitiateRestoreObject() {
            return this.s3InitiateRestoreObject != null ? this.s3InitiateRestoreObject.toBuilder() : null;
        }

        public final void setS3InitiateRestoreObject(S3InitiateRestoreObjectOperation.BuilderImpl s3InitiateRestoreObject) {
            this.s3InitiateRestoreObject = s3InitiateRestoreObject != null ? s3InitiateRestoreObject.build() : null;
        }

        @Override
        public final Builder s3InitiateRestoreObject(S3InitiateRestoreObjectOperation s3InitiateRestoreObject) {
            this.s3InitiateRestoreObject = s3InitiateRestoreObject;
            return this;
        }

        public final S3SetObjectLegalHoldOperation.Builder getS3PutObjectLegalHold() {
            return this.s3PutObjectLegalHold != null ? this.s3PutObjectLegalHold.toBuilder() : null;
        }

        public final void setS3PutObjectLegalHold(S3SetObjectLegalHoldOperation.BuilderImpl s3PutObjectLegalHold) {
            this.s3PutObjectLegalHold = s3PutObjectLegalHold != null ? s3PutObjectLegalHold.build() : null;
        }

        @Override
        public final Builder s3PutObjectLegalHold(S3SetObjectLegalHoldOperation s3PutObjectLegalHold) {
            this.s3PutObjectLegalHold = s3PutObjectLegalHold;
            return this;
        }

        public final S3SetObjectRetentionOperation.Builder getS3PutObjectRetention() {
            return this.s3PutObjectRetention != null ? this.s3PutObjectRetention.toBuilder() : null;
        }

        public final void setS3PutObjectRetention(S3SetObjectRetentionOperation.BuilderImpl s3PutObjectRetention) {
            this.s3PutObjectRetention = s3PutObjectRetention != null ? s3PutObjectRetention.build() : null;
        }

        @Override
        public final Builder s3PutObjectRetention(S3SetObjectRetentionOperation s3PutObjectRetention) {
            this.s3PutObjectRetention = s3PutObjectRetention;
            return this;
        }

        public final S3ReplicateObjectOperation.Builder getS3ReplicateObject() {
            return this.s3ReplicateObject != null ? this.s3ReplicateObject.toBuilder() : null;
        }

        public final void setS3ReplicateObject(S3ReplicateObjectOperation.BuilderImpl s3ReplicateObject) {
            this.s3ReplicateObject = s3ReplicateObject != null ? s3ReplicateObject.build() : null;
        }

        @Override
        public final Builder s3ReplicateObject(S3ReplicateObjectOperation s3ReplicateObject) {
            this.s3ReplicateObject = s3ReplicateObject;
            return this;
        }

        public JobOperation build() {
            return new JobOperation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobOperation> {
        public Builder lambdaInvoke(LambdaInvokeOperation var1);

        default public Builder lambdaInvoke(Consumer<LambdaInvokeOperation.Builder> lambdaInvoke) {
            return this.lambdaInvoke((LambdaInvokeOperation)((LambdaInvokeOperation.Builder)LambdaInvokeOperation.builder().applyMutation(lambdaInvoke)).build());
        }

        public Builder s3PutObjectCopy(S3CopyObjectOperation var1);

        default public Builder s3PutObjectCopy(Consumer<S3CopyObjectOperation.Builder> s3PutObjectCopy) {
            return this.s3PutObjectCopy((S3CopyObjectOperation)((S3CopyObjectOperation.Builder)S3CopyObjectOperation.builder().applyMutation(s3PutObjectCopy)).build());
        }

        public Builder s3PutObjectAcl(S3SetObjectAclOperation var1);

        default public Builder s3PutObjectAcl(Consumer<S3SetObjectAclOperation.Builder> s3PutObjectAcl) {
            return this.s3PutObjectAcl((S3SetObjectAclOperation)((S3SetObjectAclOperation.Builder)S3SetObjectAclOperation.builder().applyMutation(s3PutObjectAcl)).build());
        }

        public Builder s3PutObjectTagging(S3SetObjectTaggingOperation var1);

        default public Builder s3PutObjectTagging(Consumer<S3SetObjectTaggingOperation.Builder> s3PutObjectTagging) {
            return this.s3PutObjectTagging((S3SetObjectTaggingOperation)((S3SetObjectTaggingOperation.Builder)S3SetObjectTaggingOperation.builder().applyMutation(s3PutObjectTagging)).build());
        }

        public Builder s3DeleteObjectTagging(S3DeleteObjectTaggingOperation var1);

        default public Builder s3DeleteObjectTagging(Consumer<S3DeleteObjectTaggingOperation.Builder> s3DeleteObjectTagging) {
            return this.s3DeleteObjectTagging((S3DeleteObjectTaggingOperation)((S3DeleteObjectTaggingOperation.Builder)S3DeleteObjectTaggingOperation.builder().applyMutation(s3DeleteObjectTagging)).build());
        }

        public Builder s3InitiateRestoreObject(S3InitiateRestoreObjectOperation var1);

        default public Builder s3InitiateRestoreObject(Consumer<S3InitiateRestoreObjectOperation.Builder> s3InitiateRestoreObject) {
            return this.s3InitiateRestoreObject((S3InitiateRestoreObjectOperation)((S3InitiateRestoreObjectOperation.Builder)S3InitiateRestoreObjectOperation.builder().applyMutation(s3InitiateRestoreObject)).build());
        }

        public Builder s3PutObjectLegalHold(S3SetObjectLegalHoldOperation var1);

        default public Builder s3PutObjectLegalHold(Consumer<S3SetObjectLegalHoldOperation.Builder> s3PutObjectLegalHold) {
            return this.s3PutObjectLegalHold((S3SetObjectLegalHoldOperation)((S3SetObjectLegalHoldOperation.Builder)S3SetObjectLegalHoldOperation.builder().applyMutation(s3PutObjectLegalHold)).build());
        }

        public Builder s3PutObjectRetention(S3SetObjectRetentionOperation var1);

        default public Builder s3PutObjectRetention(Consumer<S3SetObjectRetentionOperation.Builder> s3PutObjectRetention) {
            return this.s3PutObjectRetention((S3SetObjectRetentionOperation)((S3SetObjectRetentionOperation.Builder)S3SetObjectRetentionOperation.builder().applyMutation(s3PutObjectRetention)).build());
        }

        public Builder s3ReplicateObject(S3ReplicateObjectOperation var1);

        default public Builder s3ReplicateObject(Consumer<S3ReplicateObjectOperation.Builder> s3ReplicateObject) {
            return this.s3ReplicateObject((S3ReplicateObjectOperation)((S3ReplicateObjectOperation.Builder)S3ReplicateObjectOperation.builder().applyMutation(s3ReplicateObject)).build());
        }
    }
}

