/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.s3control.model.S3ControlRequest;
import software.amazon.awssdk.services.s3control.model.StorageLensConfiguration;
import software.amazon.awssdk.services.s3control.model.StorageLensTag;
import software.amazon.awssdk.services.s3control.model.StorageLensTagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutStorageLensConfigurationRequest
extends S3ControlRequest
implements ToCopyableBuilder<Builder, PutStorageLensConfigurationRequest> {
    private static final SdkField<String> CONFIG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigId").getter(PutStorageLensConfigurationRequest.getter(PutStorageLensConfigurationRequest::configId)).setter(PutStorageLensConfigurationRequest.setter(Builder::configId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("storagelensid").unmarshallLocationName("storagelensid").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(PutStorageLensConfigurationRequest.getter(PutStorageLensConfigurationRequest::accountId)).setter(PutStorageLensConfigurationRequest.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-account-id").unmarshallLocationName("x-amz-account-id").build()}).build();
    private static final SdkField<StorageLensConfiguration> STORAGE_LENS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StorageLensConfiguration").getter(PutStorageLensConfigurationRequest.getter(PutStorageLensConfigurationRequest::storageLensConfiguration)).setter(PutStorageLensConfigurationRequest.setter(Builder::storageLensConfiguration)).constructor(StorageLensConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageLensConfiguration").unmarshallLocationName("StorageLensConfiguration").build()}).build();
    private static final SdkField<List<StorageLensTag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(PutStorageLensConfigurationRequest.getter(PutStorageLensConfigurationRequest::tags)).setter(PutStorageLensConfigurationRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").unmarshallLocationName("Tags").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StorageLensTag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").unmarshallLocationName("Tag").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_ID_FIELD, ACCOUNT_ID_FIELD, STORAGE_LENS_CONFIGURATION_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutStorageLensConfigurationRequest.memberNameToFieldInitializer();
    private final String configId;
    private final String accountId;
    private final StorageLensConfiguration storageLensConfiguration;
    private final List<StorageLensTag> tags;

    private PutStorageLensConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.configId = builder.configId;
        this.accountId = builder.accountId;
        this.storageLensConfiguration = builder.storageLensConfiguration;
        this.tags = builder.tags;
    }

    public final String configId() {
        return this.configId;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final StorageLensConfiguration storageLensConfiguration() {
        return this.storageLensConfiguration;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<StorageLensTag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.configId());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageLensConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutStorageLensConfigurationRequest)) {
            return false;
        }
        PutStorageLensConfigurationRequest other = (PutStorageLensConfigurationRequest)((Object)obj);
        return Objects.equals(this.configId(), other.configId()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.storageLensConfiguration(), other.storageLensConfiguration()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"PutStorageLensConfigurationRequest").add("ConfigId", (Object)this.configId()).add("AccountId", (Object)this.accountId()).add("StorageLensConfiguration", (Object)this.storageLensConfiguration()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigId": {
                return Optional.ofNullable(clazz.cast(this.configId()));
            }
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "StorageLensConfiguration": {
                return Optional.ofNullable(clazz.cast(this.storageLensConfiguration()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("storagelensid", CONFIG_ID_FIELD);
        map.put("x-amz-account-id", ACCOUNT_ID_FIELD);
        map.put("StorageLensConfiguration", STORAGE_LENS_CONFIGURATION_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutStorageLensConfigurationRequest, T> g) {
        return obj -> g.apply((PutStorageLensConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3ControlRequest.BuilderImpl
    implements Builder {
        private String configId;
        private String accountId;
        private StorageLensConfiguration storageLensConfiguration;
        private List<StorageLensTag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutStorageLensConfigurationRequest model) {
            super(model);
            this.configId(model.configId);
            this.accountId(model.accountId);
            this.storageLensConfiguration(model.storageLensConfiguration);
            this.tags(model.tags);
        }

        public final String getConfigId() {
            return this.configId;
        }

        public final void setConfigId(String configId) {
            this.configId = configId;
        }

        @Override
        public final Builder configId(String configId) {
            this.configId = configId;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final StorageLensConfiguration.Builder getStorageLensConfiguration() {
            return this.storageLensConfiguration != null ? this.storageLensConfiguration.toBuilder() : null;
        }

        public final void setStorageLensConfiguration(StorageLensConfiguration.BuilderImpl storageLensConfiguration) {
            this.storageLensConfiguration = storageLensConfiguration != null ? storageLensConfiguration.build() : null;
        }

        @Override
        public final Builder storageLensConfiguration(StorageLensConfiguration storageLensConfiguration) {
            this.storageLensConfiguration = storageLensConfiguration;
            return this;
        }

        public final List<StorageLensTag.Builder> getTags() {
            List<StorageLensTag.Builder> result = StorageLensTagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<StorageLensTag.BuilderImpl> tags) {
            this.tags = StorageLensTagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<StorageLensTag> tags) {
            this.tags = StorageLensTagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(StorageLensTag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<StorageLensTag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (StorageLensTag)((StorageLensTag.Builder)StorageLensTag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutStorageLensConfigurationRequest build() {
            return new PutStorageLensConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends S3ControlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutStorageLensConfigurationRequest> {
        public Builder configId(String var1);

        public Builder accountId(String var1);

        public Builder storageLensConfiguration(StorageLensConfiguration var1);

        default public Builder storageLensConfiguration(Consumer<StorageLensConfiguration.Builder> storageLensConfiguration) {
            return this.storageLensConfiguration((StorageLensConfiguration)((StorageLensConfiguration.Builder)StorageLensConfiguration.builder().applyMutation(storageLensConfiguration)).build());
        }

        public Builder tags(Collection<StorageLensTag> var1);

        public Builder tags(StorageLensTag ... var1);

        public Builder tags(Consumer<StorageLensTag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

