/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegionalBucket
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RegionalBucket> {
    private static final SdkField<String> BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Bucket").getter(RegionalBucket.getter(RegionalBucket::bucket)).setter(RegionalBucket.setter(Builder::bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bucket").unmarshallLocationName("Bucket").build()}).build();
    private static final SdkField<String> BUCKET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BucketArn").getter(RegionalBucket.getter(RegionalBucket::bucketArn)).setter(RegionalBucket.setter(Builder::bucketArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketArn").unmarshallLocationName("BucketArn").build()}).build();
    private static final SdkField<Boolean> PUBLIC_ACCESS_BLOCK_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PublicAccessBlockEnabled").getter(RegionalBucket.getter(RegionalBucket::publicAccessBlockEnabled)).setter(RegionalBucket.setter(Builder::publicAccessBlockEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicAccessBlockEnabled").unmarshallLocationName("PublicAccessBlockEnabled").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationDate").getter(RegionalBucket.getter(RegionalBucket::creationDate)).setter(RegionalBucket.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").unmarshallLocationName("CreationDate").build()}).build();
    private static final SdkField<String> OUTPOST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutpostId").getter(RegionalBucket.getter(RegionalBucket::outpostId)).setter(RegionalBucket.setter(Builder::outpostId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostId").unmarshallLocationName("OutpostId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_FIELD, BUCKET_ARN_FIELD, PUBLIC_ACCESS_BLOCK_ENABLED_FIELD, CREATION_DATE_FIELD, OUTPOST_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RegionalBucket.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String bucket;
    private final String bucketArn;
    private final Boolean publicAccessBlockEnabled;
    private final Instant creationDate;
    private final String outpostId;

    private RegionalBucket(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.bucketArn = builder.bucketArn;
        this.publicAccessBlockEnabled = builder.publicAccessBlockEnabled;
        this.creationDate = builder.creationDate;
        this.outpostId = builder.outpostId;
    }

    public final String bucket() {
        return this.bucket;
    }

    public final String bucketArn() {
        return this.bucketArn;
    }

    public final Boolean publicAccessBlockEnabled() {
        return this.publicAccessBlockEnabled;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final String outpostId() {
        return this.outpostId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicAccessBlockEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.outpostId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegionalBucket)) {
            return false;
        }
        RegionalBucket other = (RegionalBucket)obj;
        return Objects.equals(this.bucket(), other.bucket()) && Objects.equals(this.bucketArn(), other.bucketArn()) && Objects.equals(this.publicAccessBlockEnabled(), other.publicAccessBlockEnabled()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.outpostId(), other.outpostId());
    }

    public final String toString() {
        return ToString.builder((String)"RegionalBucket").add("Bucket", (Object)this.bucket()).add("BucketArn", (Object)this.bucketArn()).add("PublicAccessBlockEnabled", (Object)this.publicAccessBlockEnabled()).add("CreationDate", (Object)this.creationDate()).add("OutpostId", (Object)this.outpostId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bucket": {
                return Optional.ofNullable(clazz.cast(this.bucket()));
            }
            case "BucketArn": {
                return Optional.ofNullable(clazz.cast(this.bucketArn()));
            }
            case "PublicAccessBlockEnabled": {
                return Optional.ofNullable(clazz.cast(this.publicAccessBlockEnabled()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "OutpostId": {
                return Optional.ofNullable(clazz.cast(this.outpostId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Bucket", BUCKET_FIELD);
        map.put("BucketArn", BUCKET_ARN_FIELD);
        map.put("PublicAccessBlockEnabled", PUBLIC_ACCESS_BLOCK_ENABLED_FIELD);
        map.put("CreationDate", CREATION_DATE_FIELD);
        map.put("OutpostId", OUTPOST_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegionalBucket, T> g) {
        return obj -> g.apply((RegionalBucket)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucket;
        private String bucketArn;
        private Boolean publicAccessBlockEnabled;
        private Instant creationDate;
        private String outpostId;

        private BuilderImpl() {
        }

        private BuilderImpl(RegionalBucket model) {
            this.bucket(model.bucket);
            this.bucketArn(model.bucketArn);
            this.publicAccessBlockEnabled(model.publicAccessBlockEnabled);
            this.creationDate(model.creationDate);
            this.outpostId(model.outpostId);
        }

        public final String getBucket() {
            return this.bucket;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final String getBucketArn() {
            return this.bucketArn;
        }

        public final void setBucketArn(String bucketArn) {
            this.bucketArn = bucketArn;
        }

        @Override
        public final Builder bucketArn(String bucketArn) {
            this.bucketArn = bucketArn;
            return this;
        }

        public final Boolean getPublicAccessBlockEnabled() {
            return this.publicAccessBlockEnabled;
        }

        public final void setPublicAccessBlockEnabled(Boolean publicAccessBlockEnabled) {
            this.publicAccessBlockEnabled = publicAccessBlockEnabled;
        }

        @Override
        public final Builder publicAccessBlockEnabled(Boolean publicAccessBlockEnabled) {
            this.publicAccessBlockEnabled = publicAccessBlockEnabled;
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getOutpostId() {
            return this.outpostId;
        }

        public final void setOutpostId(String outpostId) {
            this.outpostId = outpostId;
        }

        @Override
        public final Builder outpostId(String outpostId) {
            this.outpostId = outpostId;
            return this;
        }

        public RegionalBucket build() {
            return new RegionalBucket(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RegionalBucket> {
        public Builder bucket(String var1);

        public Builder bucketArn(String var1);

        public Builder publicAccessBlockEnabled(Boolean var1);

        public Builder creationDate(Instant var1);

        public Builder outpostId(String var1);
    }
}

