/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3control.model.JobReportFormat;
import software.amazon.awssdk.services.s3control.model.JobReportScope;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobReport
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobReport> {
    private static final SdkField<String> BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Bucket").getter(JobReport.getter(JobReport::bucket)).setter(JobReport.setter(Builder::bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bucket").unmarshallLocationName("Bucket").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Format").getter(JobReport.getter(JobReport::formatAsString)).setter(JobReport.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").unmarshallLocationName("Format").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(JobReport.getter(JobReport::enabled)).setter(JobReport.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").unmarshallLocationName("Enabled").build()}).build();
    private static final SdkField<String> PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Prefix").getter(JobReport.getter(JobReport::prefix)).setter(JobReport.setter(Builder::prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prefix").unmarshallLocationName("Prefix").build()}).build();
    private static final SdkField<String> REPORT_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReportScope").getter(JobReport.getter(JobReport::reportScopeAsString)).setter(JobReport.setter(Builder::reportScope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportScope").unmarshallLocationName("ReportScope").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_FIELD, FORMAT_FIELD, ENABLED_FIELD, PREFIX_FIELD, REPORT_SCOPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Bucket", BUCKET_FIELD);
            this.put("Format", FORMAT_FIELD);
            this.put("Enabled", ENABLED_FIELD);
            this.put("Prefix", PREFIX_FIELD);
            this.put("ReportScope", REPORT_SCOPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String bucket;
    private final String format;
    private final Boolean enabled;
    private final String prefix;
    private final String reportScope;

    private JobReport(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.format = builder.format;
        this.enabled = builder.enabled;
        this.prefix = builder.prefix;
        this.reportScope = builder.reportScope;
    }

    public final String bucket() {
        return this.bucket;
    }

    public final JobReportFormat format() {
        return JobReportFormat.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final String prefix() {
        return this.prefix;
    }

    public final JobReportScope reportScope() {
        return JobReportScope.fromValue(this.reportScope);
    }

    public final String reportScopeAsString() {
        return this.reportScope;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportScopeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobReport)) {
            return false;
        }
        JobReport other = (JobReport)obj;
        return Objects.equals(this.bucket(), other.bucket()) && Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.prefix(), other.prefix()) && Objects.equals(this.reportScopeAsString(), other.reportScopeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"JobReport").add("Bucket", (Object)this.bucket()).add("Format", (Object)this.formatAsString()).add("Enabled", (Object)this.enabled()).add("Prefix", (Object)this.prefix()).add("ReportScope", (Object)this.reportScopeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bucket": {
                return Optional.ofNullable(clazz.cast(this.bucket()));
            }
            case "Format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "Prefix": {
                return Optional.ofNullable(clazz.cast(this.prefix()));
            }
            case "ReportScope": {
                return Optional.ofNullable(clazz.cast(this.reportScopeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<JobReport, T> g) {
        return obj -> g.apply((JobReport)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucket;
        private String format;
        private Boolean enabled;
        private String prefix;
        private String reportScope;

        private BuilderImpl() {
        }

        private BuilderImpl(JobReport model) {
            this.bucket(model.bucket);
            this.format(model.format);
            this.enabled(model.enabled);
            this.prefix(model.prefix);
            this.reportScope(model.reportScope);
        }

        public final String getBucket() {
            return this.bucket;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(JobReportFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final String getReportScope() {
            return this.reportScope;
        }

        public final void setReportScope(String reportScope) {
            this.reportScope = reportScope;
        }

        @Override
        public final Builder reportScope(String reportScope) {
            this.reportScope = reportScope;
            return this;
        }

        @Override
        public final Builder reportScope(JobReportScope reportScope) {
            this.reportScope(reportScope == null ? null : reportScope.toString());
            return this;
        }

        public JobReport build() {
            return new JobReport(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobReport> {
        public Builder bucket(String var1);

        public Builder format(String var1);

        public Builder format(JobReportFormat var1);

        public Builder enabled(Boolean var1);

        public Builder prefix(String var1);

        public Builder reportScope(String var1);

        public Builder reportScope(JobReportScope var1);
    }
}

