/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Privilege {
    MINIMAL("Minimal"),
    DEFAULT("Default"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Privilege> VALUE_MAP;
    private final String value;

    private Privilege(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Privilege fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Privilege> knownValues() {
        EnumSet<Privilege> knownValues = EnumSet.allOf(Privilege.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Privilege.class, Privilege::toString);
    }
}

