/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3control.model.AccountLevel;
import software.amazon.awssdk.services.s3control.model.Exclude;
import software.amazon.awssdk.services.s3control.model.Include;
import software.amazon.awssdk.services.s3control.model.StorageLensAwsOrg;
import software.amazon.awssdk.services.s3control.model.StorageLensDataExport;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StorageLensConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StorageLensConfiguration> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(StorageLensConfiguration.getter(StorageLensConfiguration::id)).setter(StorageLensConfiguration.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id").build()}).build();
    private static final SdkField<AccountLevel> ACCOUNT_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AccountLevel").getter(StorageLensConfiguration.getter(StorageLensConfiguration::accountLevel)).setter(StorageLensConfiguration.setter(Builder::accountLevel)).constructor(AccountLevel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountLevel").unmarshallLocationName("AccountLevel").build()}).build();
    private static final SdkField<Include> INCLUDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Include").getter(StorageLensConfiguration.getter(StorageLensConfiguration::include)).setter(StorageLensConfiguration.setter(Builder::include)).constructor(Include::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Include").unmarshallLocationName("Include").build()}).build();
    private static final SdkField<Exclude> EXCLUDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Exclude").getter(StorageLensConfiguration.getter(StorageLensConfiguration::exclude)).setter(StorageLensConfiguration.setter(Builder::exclude)).constructor(Exclude::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Exclude").unmarshallLocationName("Exclude").build()}).build();
    private static final SdkField<StorageLensDataExport> DATA_EXPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataExport").getter(StorageLensConfiguration.getter(StorageLensConfiguration::dataExport)).setter(StorageLensConfiguration.setter(Builder::dataExport)).constructor(StorageLensDataExport::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataExport").unmarshallLocationName("DataExport").build()}).build();
    private static final SdkField<Boolean> IS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsEnabled").getter(StorageLensConfiguration.getter(StorageLensConfiguration::isEnabled)).setter(StorageLensConfiguration.setter(Builder::isEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsEnabled").unmarshallLocationName("IsEnabled").build()}).build();
    private static final SdkField<StorageLensAwsOrg> AWS_ORG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AwsOrg").getter(StorageLensConfiguration.getter(StorageLensConfiguration::awsOrg)).setter(StorageLensConfiguration.setter(Builder::awsOrg)).constructor(StorageLensAwsOrg::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsOrg").unmarshallLocationName("AwsOrg").build()}).build();
    private static final SdkField<String> STORAGE_LENS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageLensArn").getter(StorageLensConfiguration.getter(StorageLensConfiguration::storageLensArn)).setter(StorageLensConfiguration.setter(Builder::storageLensArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageLensArn").unmarshallLocationName("StorageLensArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ACCOUNT_LEVEL_FIELD, INCLUDE_FIELD, EXCLUDE_FIELD, DATA_EXPORT_FIELD, IS_ENABLED_FIELD, AWS_ORG_FIELD, STORAGE_LENS_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Id", ID_FIELD);
            this.put("AccountLevel", ACCOUNT_LEVEL_FIELD);
            this.put("Include", INCLUDE_FIELD);
            this.put("Exclude", EXCLUDE_FIELD);
            this.put("DataExport", DATA_EXPORT_FIELD);
            this.put("IsEnabled", IS_ENABLED_FIELD);
            this.put("AwsOrg", AWS_ORG_FIELD);
            this.put("StorageLensArn", STORAGE_LENS_ARN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String id;
    private final AccountLevel accountLevel;
    private final Include include;
    private final Exclude exclude;
    private final StorageLensDataExport dataExport;
    private final Boolean isEnabled;
    private final StorageLensAwsOrg awsOrg;
    private final String storageLensArn;

    private StorageLensConfiguration(BuilderImpl builder) {
        this.id = builder.id;
        this.accountLevel = builder.accountLevel;
        this.include = builder.include;
        this.exclude = builder.exclude;
        this.dataExport = builder.dataExport;
        this.isEnabled = builder.isEnabled;
        this.awsOrg = builder.awsOrg;
        this.storageLensArn = builder.storageLensArn;
    }

    public final String id() {
        return this.id;
    }

    public final AccountLevel accountLevel() {
        return this.accountLevel;
    }

    public final Include include() {
        return this.include;
    }

    public final Exclude exclude() {
        return this.exclude;
    }

    public final StorageLensDataExport dataExport() {
        return this.dataExport;
    }

    public final Boolean isEnabled() {
        return this.isEnabled;
    }

    public final StorageLensAwsOrg awsOrg() {
        return this.awsOrg;
    }

    public final String storageLensArn() {
        return this.storageLensArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountLevel());
        hashCode = 31 * hashCode + Objects.hashCode(this.include());
        hashCode = 31 * hashCode + Objects.hashCode(this.exclude());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataExport());
        hashCode = 31 * hashCode + Objects.hashCode(this.isEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsOrg());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageLensArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorageLensConfiguration)) {
            return false;
        }
        StorageLensConfiguration other = (StorageLensConfiguration)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.accountLevel(), other.accountLevel()) && Objects.equals(this.include(), other.include()) && Objects.equals(this.exclude(), other.exclude()) && Objects.equals(this.dataExport(), other.dataExport()) && Objects.equals(this.isEnabled(), other.isEnabled()) && Objects.equals(this.awsOrg(), other.awsOrg()) && Objects.equals(this.storageLensArn(), other.storageLensArn());
    }

    public final String toString() {
        return ToString.builder((String)"StorageLensConfiguration").add("Id", (Object)this.id()).add("AccountLevel", (Object)this.accountLevel()).add("Include", (Object)this.include()).add("Exclude", (Object)this.exclude()).add("DataExport", (Object)this.dataExport()).add("IsEnabled", (Object)this.isEnabled()).add("AwsOrg", (Object)this.awsOrg()).add("StorageLensArn", (Object)this.storageLensArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "AccountLevel": {
                return Optional.ofNullable(clazz.cast(this.accountLevel()));
            }
            case "Include": {
                return Optional.ofNullable(clazz.cast(this.include()));
            }
            case "Exclude": {
                return Optional.ofNullable(clazz.cast(this.exclude()));
            }
            case "DataExport": {
                return Optional.ofNullable(clazz.cast(this.dataExport()));
            }
            case "IsEnabled": {
                return Optional.ofNullable(clazz.cast(this.isEnabled()));
            }
            case "AwsOrg": {
                return Optional.ofNullable(clazz.cast(this.awsOrg()));
            }
            case "StorageLensArn": {
                return Optional.ofNullable(clazz.cast(this.storageLensArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StorageLensConfiguration, T> g) {
        return obj -> g.apply((StorageLensConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private AccountLevel accountLevel;
        private Include include;
        private Exclude exclude;
        private StorageLensDataExport dataExport;
        private Boolean isEnabled;
        private StorageLensAwsOrg awsOrg;
        private String storageLensArn;

        private BuilderImpl() {
        }

        private BuilderImpl(StorageLensConfiguration model) {
            this.id(model.id);
            this.accountLevel(model.accountLevel);
            this.include(model.include);
            this.exclude(model.exclude);
            this.dataExport(model.dataExport);
            this.isEnabled(model.isEnabled);
            this.awsOrg(model.awsOrg);
            this.storageLensArn(model.storageLensArn);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final AccountLevel.Builder getAccountLevel() {
            return this.accountLevel != null ? this.accountLevel.toBuilder() : null;
        }

        public final void setAccountLevel(AccountLevel.BuilderImpl accountLevel) {
            this.accountLevel = accountLevel != null ? accountLevel.build() : null;
        }

        @Override
        public final Builder accountLevel(AccountLevel accountLevel) {
            this.accountLevel = accountLevel;
            return this;
        }

        public final Include.Builder getInclude() {
            return this.include != null ? this.include.toBuilder() : null;
        }

        public final void setInclude(Include.BuilderImpl include) {
            this.include = include != null ? include.build() : null;
        }

        @Override
        public final Builder include(Include include) {
            this.include = include;
            return this;
        }

        public final Exclude.Builder getExclude() {
            return this.exclude != null ? this.exclude.toBuilder() : null;
        }

        public final void setExclude(Exclude.BuilderImpl exclude) {
            this.exclude = exclude != null ? exclude.build() : null;
        }

        @Override
        public final Builder exclude(Exclude exclude) {
            this.exclude = exclude;
            return this;
        }

        public final StorageLensDataExport.Builder getDataExport() {
            return this.dataExport != null ? this.dataExport.toBuilder() : null;
        }

        public final void setDataExport(StorageLensDataExport.BuilderImpl dataExport) {
            this.dataExport = dataExport != null ? dataExport.build() : null;
        }

        @Override
        public final Builder dataExport(StorageLensDataExport dataExport) {
            this.dataExport = dataExport;
            return this;
        }

        public final Boolean getIsEnabled() {
            return this.isEnabled;
        }

        public final void setIsEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
        }

        @Override
        public final Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            return this;
        }

        public final StorageLensAwsOrg.Builder getAwsOrg() {
            return this.awsOrg != null ? this.awsOrg.toBuilder() : null;
        }

        public final void setAwsOrg(StorageLensAwsOrg.BuilderImpl awsOrg) {
            this.awsOrg = awsOrg != null ? awsOrg.build() : null;
        }

        @Override
        public final Builder awsOrg(StorageLensAwsOrg awsOrg) {
            this.awsOrg = awsOrg;
            return this;
        }

        public final String getStorageLensArn() {
            return this.storageLensArn;
        }

        public final void setStorageLensArn(String storageLensArn) {
            this.storageLensArn = storageLensArn;
        }

        @Override
        public final Builder storageLensArn(String storageLensArn) {
            this.storageLensArn = storageLensArn;
            return this;
        }

        public StorageLensConfiguration build() {
            return new StorageLensConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StorageLensConfiguration> {
        public Builder id(String var1);

        public Builder accountLevel(AccountLevel var1);

        default public Builder accountLevel(Consumer<AccountLevel.Builder> accountLevel) {
            return this.accountLevel((AccountLevel)((AccountLevel.Builder)AccountLevel.builder().applyMutation(accountLevel)).build());
        }

        public Builder include(Include var1);

        default public Builder include(Consumer<Include.Builder> include) {
            return this.include((Include)((Include.Builder)Include.builder().applyMutation(include)).build());
        }

        public Builder exclude(Exclude var1);

        default public Builder exclude(Consumer<Exclude.Builder> exclude) {
            return this.exclude((Exclude)((Exclude.Builder)Exclude.builder().applyMutation(exclude)).build());
        }

        public Builder dataExport(StorageLensDataExport var1);

        default public Builder dataExport(Consumer<StorageLensDataExport.Builder> dataExport) {
            return this.dataExport((StorageLensDataExport)((StorageLensDataExport.Builder)StorageLensDataExport.builder().applyMutation(dataExport)).build());
        }

        public Builder isEnabled(Boolean var1);

        public Builder awsOrg(StorageLensAwsOrg var1);

        default public Builder awsOrg(Consumer<StorageLensAwsOrg.Builder> awsOrg) {
            return this.awsOrg((StorageLensAwsOrg)((StorageLensAwsOrg.Builder)StorageLensAwsOrg.builder().applyMutation(awsOrg)).build());
        }

        public Builder storageLensArn(String var1);
    }
}

