/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3control.model.S3ControlResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBucketResponse
extends S3ControlResponse
implements ToCopyableBuilder<Builder, GetBucketResponse> {
    private static final SdkField<String> BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Bucket").getter(GetBucketResponse.getter(GetBucketResponse::bucket)).setter(GetBucketResponse.setter(Builder::bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bucket").unmarshallLocationName("Bucket").build()}).build();
    private static final SdkField<Boolean> PUBLIC_ACCESS_BLOCK_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PublicAccessBlockEnabled").getter(GetBucketResponse.getter(GetBucketResponse::publicAccessBlockEnabled)).setter(GetBucketResponse.setter(Builder::publicAccessBlockEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicAccessBlockEnabled").unmarshallLocationName("PublicAccessBlockEnabled").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationDate").getter(GetBucketResponse.getter(GetBucketResponse::creationDate)).setter(GetBucketResponse.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").unmarshallLocationName("CreationDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_FIELD, PUBLIC_ACCESS_BLOCK_ENABLED_FIELD, CREATION_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Bucket", BUCKET_FIELD);
            this.put("PublicAccessBlockEnabled", PUBLIC_ACCESS_BLOCK_ENABLED_FIELD);
            this.put("CreationDate", CREATION_DATE_FIELD);
        }
    });
    private final String bucket;
    private final Boolean publicAccessBlockEnabled;
    private final Instant creationDate;

    private GetBucketResponse(BuilderImpl builder) {
        super(builder);
        this.bucket = builder.bucket;
        this.publicAccessBlockEnabled = builder.publicAccessBlockEnabled;
        this.creationDate = builder.creationDate;
    }

    public final String bucket() {
        return this.bucket;
    }

    public final Boolean publicAccessBlockEnabled() {
        return this.publicAccessBlockEnabled;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicAccessBlockEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBucketResponse)) {
            return false;
        }
        GetBucketResponse other = (GetBucketResponse)((Object)obj);
        return Objects.equals(this.bucket(), other.bucket()) && Objects.equals(this.publicAccessBlockEnabled(), other.publicAccessBlockEnabled()) && Objects.equals(this.creationDate(), other.creationDate());
    }

    public final String toString() {
        return ToString.builder((String)"GetBucketResponse").add("Bucket", (Object)this.bucket()).add("PublicAccessBlockEnabled", (Object)this.publicAccessBlockEnabled()).add("CreationDate", (Object)this.creationDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bucket": {
                return Optional.ofNullable(clazz.cast(this.bucket()));
            }
            case "PublicAccessBlockEnabled": {
                return Optional.ofNullable(clazz.cast(this.publicAccessBlockEnabled()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetBucketResponse, T> g) {
        return obj -> g.apply((GetBucketResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3ControlResponse.BuilderImpl
    implements Builder {
        private String bucket;
        private Boolean publicAccessBlockEnabled;
        private Instant creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBucketResponse model) {
            super(model);
            this.bucket(model.bucket);
            this.publicAccessBlockEnabled(model.publicAccessBlockEnabled);
            this.creationDate(model.creationDate);
        }

        public final String getBucket() {
            return this.bucket;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final Boolean getPublicAccessBlockEnabled() {
            return this.publicAccessBlockEnabled;
        }

        public final void setPublicAccessBlockEnabled(Boolean publicAccessBlockEnabled) {
            this.publicAccessBlockEnabled = publicAccessBlockEnabled;
        }

        @Override
        public final Builder publicAccessBlockEnabled(Boolean publicAccessBlockEnabled) {
            this.publicAccessBlockEnabled = publicAccessBlockEnabled;
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        @Override
        public GetBucketResponse build() {
            return new GetBucketResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends S3ControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetBucketResponse> {
        public Builder bucket(String var1);

        public Builder publicAccessBlockEnabled(Boolean var1);

        public Builder creationDate(Instant var1);
    }
}

