/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3control.model.ObjectLambdaAccessPointAlias;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ObjectLambdaAccessPoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ObjectLambdaAccessPoint> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ObjectLambdaAccessPoint.getter(ObjectLambdaAccessPoint::name)).setter(ObjectLambdaAccessPoint.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").unmarshallLocationName("Name").build()}).build();
    private static final SdkField<String> OBJECT_LAMBDA_ACCESS_POINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObjectLambdaAccessPointArn").getter(ObjectLambdaAccessPoint.getter(ObjectLambdaAccessPoint::objectLambdaAccessPointArn)).setter(ObjectLambdaAccessPoint.setter(Builder::objectLambdaAccessPointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectLambdaAccessPointArn").unmarshallLocationName("ObjectLambdaAccessPointArn").build()}).build();
    private static final SdkField<ObjectLambdaAccessPointAlias> ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Alias").getter(ObjectLambdaAccessPoint.getter(ObjectLambdaAccessPoint::alias)).setter(ObjectLambdaAccessPoint.setter(Builder::alias)).constructor(ObjectLambdaAccessPointAlias::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alias").unmarshallLocationName("Alias").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, OBJECT_LAMBDA_ACCESS_POINT_ARN_FIELD, ALIAS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("ObjectLambdaAccessPointArn", OBJECT_LAMBDA_ACCESS_POINT_ARN_FIELD);
            this.put("Alias", ALIAS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String objectLambdaAccessPointArn;
    private final ObjectLambdaAccessPointAlias alias;

    private ObjectLambdaAccessPoint(BuilderImpl builder) {
        this.name = builder.name;
        this.objectLambdaAccessPointArn = builder.objectLambdaAccessPointArn;
        this.alias = builder.alias;
    }

    public final String name() {
        return this.name;
    }

    public final String objectLambdaAccessPointArn() {
        return this.objectLambdaAccessPointArn;
    }

    public final ObjectLambdaAccessPointAlias alias() {
        return this.alias;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectLambdaAccessPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.alias());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObjectLambdaAccessPoint)) {
            return false;
        }
        ObjectLambdaAccessPoint other = (ObjectLambdaAccessPoint)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.objectLambdaAccessPointArn(), other.objectLambdaAccessPointArn()) && Objects.equals(this.alias(), other.alias());
    }

    public final String toString() {
        return ToString.builder((String)"ObjectLambdaAccessPoint").add("Name", (Object)this.name()).add("ObjectLambdaAccessPointArn", (Object)this.objectLambdaAccessPointArn()).add("Alias", (Object)this.alias()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ObjectLambdaAccessPointArn": {
                return Optional.ofNullable(clazz.cast(this.objectLambdaAccessPointArn()));
            }
            case "Alias": {
                return Optional.ofNullable(clazz.cast(this.alias()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ObjectLambdaAccessPoint, T> g) {
        return obj -> g.apply((ObjectLambdaAccessPoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String objectLambdaAccessPointArn;
        private ObjectLambdaAccessPointAlias alias;

        private BuilderImpl() {
        }

        private BuilderImpl(ObjectLambdaAccessPoint model) {
            this.name(model.name);
            this.objectLambdaAccessPointArn(model.objectLambdaAccessPointArn);
            this.alias(model.alias);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getObjectLambdaAccessPointArn() {
            return this.objectLambdaAccessPointArn;
        }

        public final void setObjectLambdaAccessPointArn(String objectLambdaAccessPointArn) {
            this.objectLambdaAccessPointArn = objectLambdaAccessPointArn;
        }

        @Override
        public final Builder objectLambdaAccessPointArn(String objectLambdaAccessPointArn) {
            this.objectLambdaAccessPointArn = objectLambdaAccessPointArn;
            return this;
        }

        public final ObjectLambdaAccessPointAlias.Builder getAlias() {
            return this.alias != null ? this.alias.toBuilder() : null;
        }

        public final void setAlias(ObjectLambdaAccessPointAlias.BuilderImpl alias) {
            this.alias = alias != null ? alias.build() : null;
        }

        @Override
        public final Builder alias(ObjectLambdaAccessPointAlias alias) {
            this.alias = alias;
            return this;
        }

        public ObjectLambdaAccessPoint build() {
            return new ObjectLambdaAccessPoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ObjectLambdaAccessPoint> {
        public Builder name(String var1);

        public Builder objectLambdaAccessPointArn(String var1);

        public Builder alias(ObjectLambdaAccessPointAlias var1);

        default public Builder alias(Consumer<ObjectLambdaAccessPointAlias.Builder> alias) {
            return this.alias((ObjectLambdaAccessPointAlias)((ObjectLambdaAccessPointAlias.Builder)ObjectLambdaAccessPointAlias.builder().applyMutation(alias)).build());
        }
    }
}

