/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3control.model.S3ControlRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCallerAccessGrantsRequest
extends S3ControlRequest
implements ToCopyableBuilder<Builder, ListCallerAccessGrantsRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(ListCallerAccessGrantsRequest.getter(ListCallerAccessGrantsRequest::accountId)).setter(ListCallerAccessGrantsRequest.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-account-id").unmarshallLocationName("x-amz-account-id").build()}).build();
    private static final SdkField<String> GRANT_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GrantScope").getter(ListCallerAccessGrantsRequest.getter(ListCallerAccessGrantsRequest::grantScope)).setter(ListCallerAccessGrantsRequest.setter(Builder::grantScope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("grantscope").unmarshallLocationName("grantscope").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListCallerAccessGrantsRequest.getter(ListCallerAccessGrantsRequest::nextToken)).setter(ListCallerAccessGrantsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListCallerAccessGrantsRequest.getter(ListCallerAccessGrantsRequest::maxResults)).setter(ListCallerAccessGrantsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").unmarshallLocationName("maxResults").build()}).build();
    private static final SdkField<Boolean> ALLOWED_BY_APPLICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllowedByApplication").getter(ListCallerAccessGrantsRequest.getter(ListCallerAccessGrantsRequest::allowedByApplication)).setter(ListCallerAccessGrantsRequest.setter(Builder::allowedByApplication)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("allowedByApplication").unmarshallLocationName("allowedByApplication").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, GRANT_SCOPE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, ALLOWED_BY_APPLICATION_FIELD));
    private final String accountId;
    private final String grantScope;
    private final String nextToken;
    private final Integer maxResults;
    private final Boolean allowedByApplication;

    private ListCallerAccessGrantsRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.grantScope = builder.grantScope;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.allowedByApplication = builder.allowedByApplication;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String grantScope() {
        return this.grantScope;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final Boolean allowedByApplication() {
        return this.allowedByApplication;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantScope());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedByApplication());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCallerAccessGrantsRequest)) {
            return false;
        }
        ListCallerAccessGrantsRequest other = (ListCallerAccessGrantsRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.grantScope(), other.grantScope()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.allowedByApplication(), other.allowedByApplication());
    }

    public final String toString() {
        return ToString.builder((String)"ListCallerAccessGrantsRequest").add("AccountId", (Object)this.accountId()).add("GrantScope", (Object)this.grantScope()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("AllowedByApplication", (Object)this.allowedByApplication()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "GrantScope": {
                return Optional.ofNullable(clazz.cast(this.grantScope()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "AllowedByApplication": {
                return Optional.ofNullable(clazz.cast(this.allowedByApplication()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCallerAccessGrantsRequest, T> g) {
        return obj -> g.apply((ListCallerAccessGrantsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3ControlRequest.BuilderImpl
    implements Builder {
        private String accountId;
        private String grantScope;
        private String nextToken;
        private Integer maxResults;
        private Boolean allowedByApplication;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCallerAccessGrantsRequest model) {
            super(model);
            this.accountId(model.accountId);
            this.grantScope(model.grantScope);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.allowedByApplication(model.allowedByApplication);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getGrantScope() {
            return this.grantScope;
        }

        public final void setGrantScope(String grantScope) {
            this.grantScope = grantScope;
        }

        @Override
        public final Builder grantScope(String grantScope) {
            this.grantScope = grantScope;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Boolean getAllowedByApplication() {
            return this.allowedByApplication;
        }

        public final void setAllowedByApplication(Boolean allowedByApplication) {
            this.allowedByApplication = allowedByApplication;
        }

        @Override
        public final Builder allowedByApplication(Boolean allowedByApplication) {
            this.allowedByApplication = allowedByApplication;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCallerAccessGrantsRequest build() {
            return new ListCallerAccessGrantsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends S3ControlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCallerAccessGrantsRequest> {
        public Builder accountId(String var1);

        public Builder grantScope(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder allowedByApplication(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

