/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3control.model.S3ControlResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAccessGrantsInstanceResourcePolicyResponse
extends S3ControlResponse
implements ToCopyableBuilder<Builder, GetAccessGrantsInstanceResourcePolicyResponse> {
    private static final SdkField<String> POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Policy").getter(GetAccessGrantsInstanceResourcePolicyResponse.getter(GetAccessGrantsInstanceResourcePolicyResponse::policy)).setter(GetAccessGrantsInstanceResourcePolicyResponse.setter(Builder::policy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policy").unmarshallLocationName("Policy").build()}).build();
    private static final SdkField<String> ORGANIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Organization").getter(GetAccessGrantsInstanceResourcePolicyResponse.getter(GetAccessGrantsInstanceResourcePolicyResponse::organization)).setter(GetAccessGrantsInstanceResourcePolicyResponse.setter(Builder::organization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Organization").unmarshallLocationName("Organization").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(GetAccessGrantsInstanceResourcePolicyResponse.getter(GetAccessGrantsInstanceResourcePolicyResponse::createdAt)).setter(GetAccessGrantsInstanceResourcePolicyResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").unmarshallLocationName("CreatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_FIELD, ORGANIZATION_FIELD, CREATED_AT_FIELD));
    private final String policy;
    private final String organization;
    private final Instant createdAt;

    private GetAccessGrantsInstanceResourcePolicyResponse(BuilderImpl builder) {
        super(builder);
        this.policy = builder.policy;
        this.organization = builder.organization;
        this.createdAt = builder.createdAt;
    }

    public final String policy() {
        return this.policy;
    }

    public final String organization() {
        return this.organization;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.policy());
        hashCode = 31 * hashCode + Objects.hashCode(this.organization());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccessGrantsInstanceResourcePolicyResponse)) {
            return false;
        }
        GetAccessGrantsInstanceResourcePolicyResponse other = (GetAccessGrantsInstanceResourcePolicyResponse)((Object)obj);
        return Objects.equals(this.policy(), other.policy()) && Objects.equals(this.organization(), other.organization()) && Objects.equals(this.createdAt(), other.createdAt());
    }

    public final String toString() {
        return ToString.builder((String)"GetAccessGrantsInstanceResourcePolicyResponse").add("Policy", (Object)this.policy()).add("Organization", (Object)this.organization()).add("CreatedAt", (Object)this.createdAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Policy": {
                return Optional.ofNullable(clazz.cast(this.policy()));
            }
            case "Organization": {
                return Optional.ofNullable(clazz.cast(this.organization()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAccessGrantsInstanceResourcePolicyResponse, T> g) {
        return obj -> g.apply((GetAccessGrantsInstanceResourcePolicyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3ControlResponse.BuilderImpl
    implements Builder {
        private String policy;
        private String organization;
        private Instant createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccessGrantsInstanceResourcePolicyResponse model) {
            super(model);
            this.policy(model.policy);
            this.organization(model.organization);
            this.createdAt(model.createdAt);
        }

        public final String getPolicy() {
            return this.policy;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final String getOrganization() {
            return this.organization;
        }

        public final void setOrganization(String organization) {
            this.organization = organization;
        }

        @Override
        public final Builder organization(String organization) {
            this.organization = organization;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public GetAccessGrantsInstanceResourcePolicyResponse build() {
            return new GetAccessGrantsInstanceResourcePolicyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends S3ControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAccessGrantsInstanceResourcePolicyResponse> {
        public Builder policy(String var1);

        public Builder organization(String var1);

        public Builder createdAt(Instant var1);
    }
}

