/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.s3control.model.CallerAccessGrantsListCopier;
import software.amazon.awssdk.services.s3control.model.ListCallerAccessGrantsEntry;
import software.amazon.awssdk.services.s3control.model.S3ControlResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCallerAccessGrantsResponse
extends S3ControlResponse
implements ToCopyableBuilder<Builder, ListCallerAccessGrantsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListCallerAccessGrantsResponse.getter(ListCallerAccessGrantsResponse::nextToken)).setter(ListCallerAccessGrantsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("NextToken").build()}).build();
    private static final SdkField<List<ListCallerAccessGrantsEntry>> CALLER_ACCESS_GRANTS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CallerAccessGrantsList").getter(ListCallerAccessGrantsResponse.getter(ListCallerAccessGrantsResponse::callerAccessGrantsList)).setter(ListCallerAccessGrantsResponse.setter(Builder::callerAccessGrantsList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallerAccessGrantsList").unmarshallLocationName("CallerAccessGrantsList").build(), ListTrait.builder().memberLocationName("AccessGrant").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ListCallerAccessGrantsEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessGrant").unmarshallLocationName("AccessGrant").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, CALLER_ACCESS_GRANTS_LIST_FIELD));
    private final String nextToken;
    private final List<ListCallerAccessGrantsEntry> callerAccessGrantsList;

    private ListCallerAccessGrantsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.callerAccessGrantsList = builder.callerAccessGrantsList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasCallerAccessGrantsList() {
        return this.callerAccessGrantsList != null && !(this.callerAccessGrantsList instanceof SdkAutoConstructList);
    }

    public final List<ListCallerAccessGrantsEntry> callerAccessGrantsList() {
        return this.callerAccessGrantsList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCallerAccessGrantsList() ? this.callerAccessGrantsList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCallerAccessGrantsResponse)) {
            return false;
        }
        ListCallerAccessGrantsResponse other = (ListCallerAccessGrantsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasCallerAccessGrantsList() == other.hasCallerAccessGrantsList() && Objects.equals(this.callerAccessGrantsList(), other.callerAccessGrantsList());
    }

    public final String toString() {
        return ToString.builder((String)"ListCallerAccessGrantsResponse").add("NextToken", (Object)this.nextToken()).add("CallerAccessGrantsList", this.hasCallerAccessGrantsList() ? this.callerAccessGrantsList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "CallerAccessGrantsList": {
                return Optional.ofNullable(clazz.cast(this.callerAccessGrantsList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCallerAccessGrantsResponse, T> g) {
        return obj -> g.apply((ListCallerAccessGrantsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3ControlResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ListCallerAccessGrantsEntry> callerAccessGrantsList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCallerAccessGrantsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.callerAccessGrantsList(model.callerAccessGrantsList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ListCallerAccessGrantsEntry.Builder> getCallerAccessGrantsList() {
            List<ListCallerAccessGrantsEntry.Builder> result = CallerAccessGrantsListCopier.copyToBuilder(this.callerAccessGrantsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCallerAccessGrantsList(Collection<ListCallerAccessGrantsEntry.BuilderImpl> callerAccessGrantsList) {
            this.callerAccessGrantsList = CallerAccessGrantsListCopier.copyFromBuilder(callerAccessGrantsList);
        }

        @Override
        public final Builder callerAccessGrantsList(Collection<ListCallerAccessGrantsEntry> callerAccessGrantsList) {
            this.callerAccessGrantsList = CallerAccessGrantsListCopier.copy(callerAccessGrantsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder callerAccessGrantsList(ListCallerAccessGrantsEntry ... callerAccessGrantsList) {
            this.callerAccessGrantsList(Arrays.asList(callerAccessGrantsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder callerAccessGrantsList(Consumer<ListCallerAccessGrantsEntry.Builder> ... callerAccessGrantsList) {
            this.callerAccessGrantsList(Stream.of(callerAccessGrantsList).map(c -> (ListCallerAccessGrantsEntry)((ListCallerAccessGrantsEntry.Builder)ListCallerAccessGrantsEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListCallerAccessGrantsResponse build() {
            return new ListCallerAccessGrantsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends S3ControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCallerAccessGrantsResponse> {
        public Builder nextToken(String var1);

        public Builder callerAccessGrantsList(Collection<ListCallerAccessGrantsEntry> var1);

        public Builder callerAccessGrantsList(ListCallerAccessGrantsEntry ... var1);

        public Builder callerAccessGrantsList(Consumer<ListCallerAccessGrantsEntry.Builder> ... var1);
    }
}

