/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.s3control.S3ControlClient;
import software.amazon.awssdk.services.s3control.internal.UserAgentUtils;
import software.amazon.awssdk.services.s3control.model.ListAccessPointsForObjectLambdaRequest;
import software.amazon.awssdk.services.s3control.model.ListAccessPointsForObjectLambdaResponse;
import software.amazon.awssdk.services.s3control.model.ObjectLambdaAccessPoint;

public class ListAccessPointsForObjectLambdaIterable
implements SdkIterable<ListAccessPointsForObjectLambdaResponse> {
    private final S3ControlClient client;
    private final ListAccessPointsForObjectLambdaRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAccessPointsForObjectLambdaIterable(S3ControlClient client, ListAccessPointsForObjectLambdaRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAccessPointsForObjectLambdaResponseFetcher();
    }

    public Iterator<ListAccessPointsForObjectLambdaResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ObjectLambdaAccessPoint> objectLambdaAccessPointList() {
        Function<ListAccessPointsForObjectLambdaResponse, Iterator> getIterator = response -> {
            if (response != null && response.objectLambdaAccessPointList() != null) {
                return response.objectLambdaAccessPointList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAccessPointsForObjectLambdaResponseFetcher
    implements SyncPageFetcher<ListAccessPointsForObjectLambdaResponse> {
        private ListAccessPointsForObjectLambdaResponseFetcher() {
        }

        public boolean hasNextPage(ListAccessPointsForObjectLambdaResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAccessPointsForObjectLambdaResponse nextPage(ListAccessPointsForObjectLambdaResponse previousPage) {
            if (previousPage == null) {
                return ListAccessPointsForObjectLambdaIterable.this.client.listAccessPointsForObjectLambda(ListAccessPointsForObjectLambdaIterable.this.firstRequest);
            }
            return ListAccessPointsForObjectLambdaIterable.this.client.listAccessPointsForObjectLambda((ListAccessPointsForObjectLambdaRequest)((Object)ListAccessPointsForObjectLambdaIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

