/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.s3control.S3ControlClient;
import software.amazon.awssdk.services.s3control.internal.UserAgentUtils;
import software.amazon.awssdk.services.s3control.model.ListJobsRequest;
import software.amazon.awssdk.services.s3control.model.ListJobsResponse;

public class ListJobsIterable
implements SdkIterable<ListJobsResponse> {
    private final S3ControlClient client;
    private final ListJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListJobsIterable(S3ControlClient client, ListJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListJobsResponseFetcher();
    }

    public Iterator<ListJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListJobsResponseFetcher
    implements SyncPageFetcher<ListJobsResponse> {
        private ListJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListJobsResponse nextPage(ListJobsResponse previousPage) {
            if (previousPage == null) {
                return ListJobsIterable.this.client.listJobs(ListJobsIterable.this.firstRequest);
            }
            return ListJobsIterable.this.client.listJobs((ListJobsRequest)((Object)ListJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

