/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.endpoints.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.services.s3control.endpoints.S3ControlEndpointParams;
import software.amazon.awssdk.services.s3control.endpoints.S3ControlEndpointProvider;
import software.amazon.awssdk.services.s3control.endpoints.internal.AwsEndpointProviderUtils;
import software.amazon.awssdk.services.s3control.endpoints.internal.Condition;
import software.amazon.awssdk.services.s3control.endpoints.internal.DefaultRuleEngine;
import software.amazon.awssdk.services.s3control.endpoints.internal.EndpointResult;
import software.amazon.awssdk.services.s3control.endpoints.internal.EndpointRuleset;
import software.amazon.awssdk.services.s3control.endpoints.internal.Expr;
import software.amazon.awssdk.services.s3control.endpoints.internal.FnNode;
import software.amazon.awssdk.services.s3control.endpoints.internal.Identifier;
import software.amazon.awssdk.services.s3control.endpoints.internal.Literal;
import software.amazon.awssdk.services.s3control.endpoints.internal.Parameter;
import software.amazon.awssdk.services.s3control.endpoints.internal.ParameterType;
import software.amazon.awssdk.services.s3control.endpoints.internal.Parameters;
import software.amazon.awssdk.services.s3control.endpoints.internal.Rule;
import software.amazon.awssdk.services.s3control.endpoints.internal.Value;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.MapUtils;

@SdkInternalApi
public final class DefaultS3ControlEndpointProvider
implements S3ControlEndpointProvider {
    private static final EndpointRuleset ENDPOINT_RULE_SET = DefaultS3ControlEndpointProvider.ruleSet();

    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(S3ControlEndpointParams endpointParams) {
        Value res = new DefaultRuleEngine().evaluate(ENDPOINT_RULE_SET, DefaultS3ControlEndpointProvider.toIdentifierValueMap(endpointParams));
        try {
            return CompletableFuture.completedFuture(AwsEndpointProviderUtils.valueAsEndpointOrThrow(res));
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static Map<Identifier, Value> toIdentifierValueMap(S3ControlEndpointParams params) {
        HashMap<Identifier, Value> paramsMap = new HashMap<Identifier, Value>();
        if (params.region() != null) {
            paramsMap.put(Identifier.of("Region"), Value.fromStr(params.region().id()));
        }
        if (params.useFips() != null) {
            paramsMap.put(Identifier.of("UseFIPS"), Value.fromBool(params.useFips()));
        }
        if (params.useDualStack() != null) {
            paramsMap.put(Identifier.of("UseDualStack"), Value.fromBool(params.useDualStack()));
        }
        if (params.endpoint() != null) {
            paramsMap.put(Identifier.of("Endpoint"), Value.fromStr(params.endpoint()));
        }
        if (params.accountId() != null) {
            paramsMap.put(Identifier.of("AccountId"), Value.fromStr(params.accountId()));
        }
        if (params.requiresAccountId() != null) {
            paramsMap.put(Identifier.of("RequiresAccountId"), Value.fromBool(params.requiresAccountId()));
        }
        if (params.outpostId() != null) {
            paramsMap.put(Identifier.of("OutpostId"), Value.fromStr(params.outpostId()));
        }
        if (params.bucket() != null) {
            paramsMap.put(Identifier.of("Bucket"), Value.fromStr(params.bucket()));
        }
        if (params.accessPointName() != null) {
            paramsMap.put(Identifier.of("AccessPointName"), Value.fromStr(params.accessPointName()));
        }
        if (params.useArnRegion() != null) {
            paramsMap.put(Identifier.of("UseArnRegion"), Value.fromBool(params.useArnRegion()));
        }
        return paramsMap;
    }

    private static Rule endpointRule_6() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("partitionResult")), Expr.of("name"))).build().validate(), Expr.of("aws-cn"))).build().validate()).build()).error("Partition does not support FIPS");
    }

    private static Rule endpointRule_8() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("RequiresAccountId")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("RequiresAccountId")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("AccountId")))).build().validate())).build().validate()).build()).error("AccountId is required but not set");
    }

    private static Rule endpointRule_10() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("AccountId")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isValidHostLabel").argv(Arrays.asList(Expr.ref(Identifier.of("AccountId")), Expr.of(false))).build().validate())).build().validate()).build()).error("AccountId must only contain a-z, A-Z, 0-9 and `-`.");
    }

    private static Rule endpointRule_12() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isValidHostLabel").argv(Arrays.asList(Expr.ref(Identifier.of("OutpostId")), Expr.of(false))).build().validate())).build().validate()).build()).error("OutpostId must only contain a-z, A-Z, 0-9 and `-`.");
    }

    private static Rule endpointRule_16() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).error("Invalid configuration: Outposts do not support dual-stack");
    }

    private static Rule endpointRule_18() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{url#authority}{url#path}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3-outposts")))))).build());
    }

    private static Rule endpointRule_19() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://s3-outposts-fips.{Region}.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3-outposts")))))).build());
    }

    private static Rule endpointRule_20() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://s3-outposts.{Region}.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3-outposts")))))).build());
    }

    private static Rule endpointRule_17() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_18(), DefaultS3ControlEndpointProvider.endpointRule_19(), DefaultS3ControlEndpointProvider.endpointRule_20()));
    }

    private static Rule endpointRule_15() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_16(), DefaultS3ControlEndpointProvider.endpointRule_17()));
    }

    private static Rule endpointRule_14() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isValidHostLabel").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_15()));
    }

    private static Rule endpointRule_21() {
        return Rule.builder().error("Invalid region: region was not a valid DNS name.");
    }

    private static Rule endpointRule_13() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_14(), DefaultS3ControlEndpointProvider.endpointRule_21()));
    }

    private static Rule endpointRule_11() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_12(), DefaultS3ControlEndpointProvider.endpointRule_13()));
    }

    private static Rule endpointRule_9() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_10(), DefaultS3ControlEndpointProvider.endpointRule_11()));
    }

    private static Rule endpointRule_7() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_8(), DefaultS3ControlEndpointProvider.endpointRule_9()));
    }

    private static Rule endpointRule_5() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_6(), DefaultS3ControlEndpointProvider.endpointRule_7()));
    }

    private static Rule endpointRule_4() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("aws.partition").argv(Arrays.asList(Expr.ref(Identifier.of("Region")))).build().validate()).result("partitionResult").build()).treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_5()));
    }

    private static Rule endpointRule_22() {
        return Rule.builder().error("A valid partition could not be determined");
    }

    private static Rule endpointRule_3() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("OutpostId")))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_4(), DefaultS3ControlEndpointProvider.endpointRule_22()));
    }

    private static Rule endpointRule_26() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).error("Invalid configuration: Outpost Access Points do not support dual-stack");
    }

    private static Rule endpointRule_32() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("UseArnRegion")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseArnRegion")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("accessPointArn")), Expr.of("region"))).build().validate(), Expr.of("{Region}"))).build().validate())).build().validate()).build()).error("Invalid configuration: region from ARN `{accessPointArn#region}` does not match client region `{Region}` and UseArnRegion is `false`");
    }

    private static Rule endpointRule_46() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("AccountId")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("AccountId")), Expr.of("{accessPointArn#accountId}"))).build().validate())).build().validate()).build()).error("Invalid ARN: the accountId specified in the ARN (`{accessPointArn#accountId}`) does not match the parameter (`{AccountId}`)");
    }

    private static Rule endpointRule_54() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://s3-outposts-fips.{accessPointArn#region}.{arnPartition#dnsSuffix}")).addHeaderValue("x-amz-account-id", Expr.of("{accessPointArn#accountId}")).addHeaderValue("x-amz-outpost-id", Expr.of("{outpostId}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{accessPointArn#region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3-outposts")))))).build());
    }

    private static Rule endpointRule_55() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{url#authority}{url#path}")).addHeaderValue("x-amz-account-id", Expr.of("{accessPointArn#accountId}")).addHeaderValue("x-amz-outpost-id", Expr.of("{outpostId}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{accessPointArn#region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3-outposts")))))).build());
    }

    private static Rule endpointRule_56() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://s3-outposts.{accessPointArn#region}.{arnPartition#dnsSuffix}")).addHeaderValue("x-amz-account-id", Expr.of("{accessPointArn#accountId}")).addHeaderValue("x-amz-outpost-id", Expr.of("{outpostId}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{accessPointArn#region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3-outposts")))))).build());
    }

    private static Rule endpointRule_53() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_54(), DefaultS3ControlEndpointProvider.endpointRule_55(), DefaultS3ControlEndpointProvider.endpointRule_56()));
    }

    private static Rule endpointRule_52() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("outpostType")), Expr.of("accesspoint"))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_53()));
    }

    private static Rule endpointRule_57() {
        return Rule.builder().error("Expected an outpost type `accesspoint`, found `{outpostType}`");
    }

    private static Rule endpointRule_51() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_52(), DefaultS3ControlEndpointProvider.endpointRule_57()));
    }

    private static Rule endpointRule_50() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("accessPointArn")), Expr.of("resourceId[3]"))).build().validate()).result("accessPointName").build()).treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_51()));
    }

    private static Rule endpointRule_58() {
        return Rule.builder().error("Invalid ARN: expected an access point name");
    }

    private static Rule endpointRule_49() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_50(), DefaultS3ControlEndpointProvider.endpointRule_58()));
    }

    private static Rule endpointRule_48() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("accessPointArn")), Expr.of("resourceId[2]"))).build().validate()).result("outpostType").build()).treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_49()));
    }

    private static Rule endpointRule_59() {
        return Rule.builder().error("Invalid ARN: Expected a 4-component resource");
    }

    private static Rule endpointRule_47() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_48(), DefaultS3ControlEndpointProvider.endpointRule_59()));
    }

    private static Rule endpointRule_45() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_46(), DefaultS3ControlEndpointProvider.endpointRule_47()));
    }

    private static Rule endpointRule_44() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isValidHostLabel").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("accessPointArn")), Expr.of("accountId"))).build().validate(), Expr.of(false))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_45()));
    }

    private static Rule endpointRule_60() {
        return Rule.builder().error("Invalid ARN: The account id may only contain a-z, A-Z, 0-9 and `-`. Found: `{accessPointArn#accountId}`");
    }

    private static Rule endpointRule_43() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_44(), DefaultS3ControlEndpointProvider.endpointRule_60()));
    }

    private static Rule endpointRule_42() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("accessPointArn")), Expr.of("accountId"))).build().validate(), Expr.of(""))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_43()));
    }

    private static Rule endpointRule_61() {
        return Rule.builder().error("Invalid ARN: missing account ID");
    }

    private static Rule endpointRule_41() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_42(), DefaultS3ControlEndpointProvider.endpointRule_61()));
    }

    private static Rule endpointRule_40() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isValidHostLabel").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("accessPointArn")), Expr.of("region"))).build().validate(), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_41()));
    }

    private static Rule endpointRule_62() {
        return Rule.builder().error("Invalid region in ARN: `{accessPointArn#region}` (invalid DNS name)");
    }

    private static Rule endpointRule_39() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_40(), DefaultS3ControlEndpointProvider.endpointRule_62()));
    }

    private static Rule endpointRule_38() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("arnPartition")), Expr.of("name"))).build().validate(), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("partitionResult")), Expr.of("name"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_39()));
    }

    private static Rule endpointRule_63() {
        return Rule.builder().error("Client was configured for partition `{partitionResult#name}` but ARN has `{arnPartition#name}`");
    }

    private static Rule endpointRule_37() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_38(), DefaultS3ControlEndpointProvider.endpointRule_63()));
    }

    private static Rule endpointRule_36() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("aws.partition").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("accessPointArn")), Expr.of("region"))).build().validate())).build().validate()).result("arnPartition").build()).treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_37()));
    }

    private static Rule endpointRule_64() {
        return Rule.builder().error("Could not load partition for ARN region `{accessPointArn#region}`");
    }

    private static Rule endpointRule_35() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_36(), DefaultS3ControlEndpointProvider.endpointRule_64()));
    }

    private static Rule endpointRule_34() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("aws.partition").argv(Arrays.asList(Expr.ref(Identifier.of("Region")))).build().validate()).result("partitionResult").build()).treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_35()));
    }

    private static Rule endpointRule_65() {
        return Rule.builder().error("A valid partition could not be determined");
    }

    private static Rule endpointRule_33() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_34(), DefaultS3ControlEndpointProvider.endpointRule_65()));
    }

    private static Rule endpointRule_31() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_32(), DefaultS3ControlEndpointProvider.endpointRule_33()));
    }

    private static Rule endpointRule_30() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isValidHostLabel").argv(Arrays.asList(Expr.ref(Identifier.of("outpostId")), Expr.of(false))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_31()));
    }

    private static Rule endpointRule_66() {
        return Rule.builder().error("Invalid ARN: The outpost Id must only contain a-z, A-Z, 0-9 and `-`., found: `{outpostId}`");
    }

    private static Rule endpointRule_29() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_30(), DefaultS3ControlEndpointProvider.endpointRule_66()));
    }

    private static Rule endpointRule_28() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("accessPointArn")), Expr.of("resourceId[1]"))).build().validate()).result("outpostId").build()).treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_29()));
    }

    private static Rule endpointRule_67() {
        return Rule.builder().error("Invalid ARN: The Outpost Id was not set");
    }

    private static Rule endpointRule_27() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_28(), DefaultS3ControlEndpointProvider.endpointRule_67()));
    }

    private static Rule endpointRule_25() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("accessPointArn")), Expr.of("service"))).build().validate(), Expr.of("s3-outposts"))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_26(), DefaultS3ControlEndpointProvider.endpointRule_27()));
    }

    private static Rule endpointRule_24() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("accessPointArn")), Expr.of("resourceId[0]"))).build().validate()).result("arnType").build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("arnType")), Expr.of(""))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_25()));
    }

    private static Rule endpointRule_68() {
        return Rule.builder().error("Invalid ARN: No ARN type specified");
    }

    private static Rule endpointRule_23() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("AccessPointName")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("aws.parseArn").argv(Arrays.asList(Expr.ref(Identifier.of("AccessPointName")))).build().validate()).result("accessPointArn").build()).treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_24(), DefaultS3ControlEndpointProvider.endpointRule_68()));
    }

    private static Rule endpointRule_72() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).error("Invalid configuration: Outpost buckets do not support dual-stack");
    }

    private static Rule endpointRule_78() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("UseArnRegion")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseArnRegion")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("bucketArn")), Expr.of("region"))).build().validate(), Expr.of("{Region}"))).build().validate())).build().validate()).build()).error("Invalid configuration: region from ARN `{bucketArn#region}` does not match client region `{Region}` and UseArnRegion is `false`");
    }

    private static Rule endpointRule_92() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("AccountId")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("AccountId")), Expr.of("{bucketArn#accountId}"))).build().validate())).build().validate()).build()).error("Invalid ARN: the accountId specified in the ARN (`{bucketArn#accountId}`) does not match the parameter (`{AccountId}`)");
    }

    private static Rule endpointRule_100() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://s3-outposts-fips.{bucketArn#region}.{arnPartition#dnsSuffix}")).addHeaderValue("x-amz-account-id", Expr.of("{bucketArn#accountId}")).addHeaderValue("x-amz-outpost-id", Expr.of("{outpostId}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{bucketArn#region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3-outposts")))))).build());
    }

    private static Rule endpointRule_101() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{url#authority}{url#path}")).addHeaderValue("x-amz-account-id", Expr.of("{bucketArn#accountId}")).addHeaderValue("x-amz-outpost-id", Expr.of("{outpostId}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{bucketArn#region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3-outposts")))))).build());
    }

    private static Rule endpointRule_102() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://s3-outposts.{bucketArn#region}.{arnPartition#dnsSuffix}")).addHeaderValue("x-amz-account-id", Expr.of("{bucketArn#accountId}")).addHeaderValue("x-amz-outpost-id", Expr.of("{outpostId}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{bucketArn#region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3-outposts")))))).build());
    }

    private static Rule endpointRule_99() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_100(), DefaultS3ControlEndpointProvider.endpointRule_101(), DefaultS3ControlEndpointProvider.endpointRule_102()));
    }

    private static Rule endpointRule_98() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("outpostType")), Expr.of("bucket"))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_99()));
    }

    private static Rule endpointRule_103() {
        return Rule.builder().error("Invalid ARN: Expected an outpost type `bucket`, found `{outpostType}`");
    }

    private static Rule endpointRule_97() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_98(), DefaultS3ControlEndpointProvider.endpointRule_103()));
    }

    private static Rule endpointRule_96() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("bucketArn")), Expr.of("resourceId[3]"))).build().validate()).result("bucketName").build()).treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_97()));
    }

    private static Rule endpointRule_104() {
        return Rule.builder().error("Invalid ARN: expected a bucket name");
    }

    private static Rule endpointRule_95() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_96(), DefaultS3ControlEndpointProvider.endpointRule_104()));
    }

    private static Rule endpointRule_94() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("bucketArn")), Expr.of("resourceId[2]"))).build().validate()).result("outpostType").build()).treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_95()));
    }

    private static Rule endpointRule_105() {
        return Rule.builder().error("Invalid ARN: Expected a 4-component resource");
    }

    private static Rule endpointRule_93() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_94(), DefaultS3ControlEndpointProvider.endpointRule_105()));
    }

    private static Rule endpointRule_91() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_92(), DefaultS3ControlEndpointProvider.endpointRule_93()));
    }

    private static Rule endpointRule_90() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isValidHostLabel").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("bucketArn")), Expr.of("accountId"))).build().validate(), Expr.of(false))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_91()));
    }

    private static Rule endpointRule_106() {
        return Rule.builder().error("Invalid ARN: The account id may only contain a-z, A-Z, 0-9 and `-`. Found: `{bucketArn#accountId}`");
    }

    private static Rule endpointRule_89() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_90(), DefaultS3ControlEndpointProvider.endpointRule_106()));
    }

    private static Rule endpointRule_88() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("bucketArn")), Expr.of("accountId"))).build().validate(), Expr.of(""))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_89()));
    }

    private static Rule endpointRule_107() {
        return Rule.builder().error("Invalid ARN: missing account ID");
    }

    private static Rule endpointRule_87() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_88(), DefaultS3ControlEndpointProvider.endpointRule_107()));
    }

    private static Rule endpointRule_86() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isValidHostLabel").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("bucketArn")), Expr.of("region"))).build().validate(), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_87()));
    }

    private static Rule endpointRule_108() {
        return Rule.builder().error("Invalid region in ARN: `{bucketArn#region}` (invalid DNS name)");
    }

    private static Rule endpointRule_85() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_86(), DefaultS3ControlEndpointProvider.endpointRule_108()));
    }

    private static Rule endpointRule_84() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("arnPartition")), Expr.of("name"))).build().validate(), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("partitionResult")), Expr.of("name"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_85()));
    }

    private static Rule endpointRule_109() {
        return Rule.builder().error("Client was configured for partition `{partitionResult#name}` but ARN has `{arnPartition#name}`");
    }

    private static Rule endpointRule_83() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_84(), DefaultS3ControlEndpointProvider.endpointRule_109()));
    }

    private static Rule endpointRule_82() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("aws.partition").argv(Arrays.asList(Expr.ref(Identifier.of("Region")))).build().validate()).result("partitionResult").build()).treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_83()));
    }

    private static Rule endpointRule_110() {
        return Rule.builder().error("A valid partition could not be determined");
    }

    private static Rule endpointRule_81() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_82(), DefaultS3ControlEndpointProvider.endpointRule_110()));
    }

    private static Rule endpointRule_80() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("aws.partition").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("bucketArn")), Expr.of("region"))).build().validate())).build().validate()).result("arnPartition").build()).treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_81()));
    }

    private static Rule endpointRule_111() {
        return Rule.builder().error("Could not load partition for ARN region `{bucketArn#region}`");
    }

    private static Rule endpointRule_79() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_80(), DefaultS3ControlEndpointProvider.endpointRule_111()));
    }

    private static Rule endpointRule_77() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_78(), DefaultS3ControlEndpointProvider.endpointRule_79()));
    }

    private static Rule endpointRule_76() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isValidHostLabel").argv(Arrays.asList(Expr.ref(Identifier.of("outpostId")), Expr.of(false))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_77()));
    }

    private static Rule endpointRule_112() {
        return Rule.builder().error("Invalid ARN: The outpost Id must only contain a-z, A-Z, 0-9 and `-`., found: `{outpostId}`");
    }

    private static Rule endpointRule_75() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_76(), DefaultS3ControlEndpointProvider.endpointRule_112()));
    }

    private static Rule endpointRule_74() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("bucketArn")), Expr.of("resourceId[1]"))).build().validate()).result("outpostId").build()).treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_75()));
    }

    private static Rule endpointRule_113() {
        return Rule.builder().error("Invalid ARN: The Outpost Id was not set");
    }

    private static Rule endpointRule_73() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_74(), DefaultS3ControlEndpointProvider.endpointRule_113()));
    }

    private static Rule endpointRule_71() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("bucketArn")), Expr.of("service"))).build().validate(), Expr.of("s3-outposts"))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_72(), DefaultS3ControlEndpointProvider.endpointRule_73()));
    }

    private static Rule endpointRule_70() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("bucketArn")), Expr.of("resourceId[0]"))).build().validate()).result("arnType").build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("arnType")), Expr.of(""))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_71()));
    }

    private static Rule endpointRule_114() {
        return Rule.builder().error("Invalid ARN: No ARN type specified");
    }

    private static Rule endpointRule_69() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Bucket")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("aws.parseArn").argv(Arrays.asList(Expr.ref(Identifier.of("Bucket")))).build().validate()).result("bucketArn").build()).treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_70(), DefaultS3ControlEndpointProvider.endpointRule_114()));
    }

    private static Rule endpointRule_120() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("partitionResult")), Expr.of("name"))).build().validate(), Expr.of("aws-cn"))).build().validate()).build()).error("Partition does not support FIPS");
    }

    private static Rule endpointRule_122() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("RequiresAccountId")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("RequiresAccountId")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("AccountId")))).build().validate())).build().validate()).build()).error("AccountId is required but not set");
    }

    private static Rule endpointRule_124() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("AccountId")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isValidHostLabel").argv(Arrays.asList(Expr.ref(Identifier.of("AccountId")), Expr.of(false))).build().validate())).build().validate()).build()).error("AccountId must only contain a-z, A-Z, 0-9 and `-`.");
    }

    private static Rule endpointRule_127() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).error("Invalid Configuration: Dualstack and custom endpoint are not supported");
    }

    private static Rule endpointRule_129() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("RequiresAccountId")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("RequiresAccountId")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("AccountId")))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{AccountId}.{url#authority}{url#path}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3")))))).build());
    }

    private static Rule endpointRule_130() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{url#authority}{url#path}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3")))))).build());
    }

    private static Rule endpointRule_128() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_129(), DefaultS3ControlEndpointProvider.endpointRule_130()));
    }

    private static Rule endpointRule_126() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_127(), DefaultS3ControlEndpointProvider.endpointRule_128()));
    }

    private static Rule endpointRule_132() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("RequiresAccountId")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("RequiresAccountId")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("AccountId")))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://{AccountId}.s3-control-fips.dualstack.{Region}.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3")))))).build());
    }

    private static Rule endpointRule_133() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://s3-control-fips.dualstack.{Region}.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3")))))).build());
    }

    private static Rule endpointRule_134() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("RequiresAccountId")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("RequiresAccountId")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("AccountId")))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://{AccountId}.s3-control-fips.{Region}.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3")))))).build());
    }

    private static Rule endpointRule_135() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://s3-control-fips.{Region}.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3")))))).build());
    }

    private static Rule endpointRule_136() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("RequiresAccountId")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("RequiresAccountId")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("AccountId")))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://{AccountId}.s3-control.dualstack.{Region}.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3")))))).build());
    }

    private static Rule endpointRule_137() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://s3-control.dualstack.{Region}.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3")))))).build());
    }

    private static Rule endpointRule_138() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("RequiresAccountId")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("RequiresAccountId")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("AccountId")))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://{AccountId}.s3-control.{Region}.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3")))))).build());
    }

    private static Rule endpointRule_139() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://s3-control.{Region}.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3")))))).build());
    }

    private static Rule endpointRule_131() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_132(), DefaultS3ControlEndpointProvider.endpointRule_133(), DefaultS3ControlEndpointProvider.endpointRule_134(), DefaultS3ControlEndpointProvider.endpointRule_135(), DefaultS3ControlEndpointProvider.endpointRule_136(), DefaultS3ControlEndpointProvider.endpointRule_137(), DefaultS3ControlEndpointProvider.endpointRule_138(), DefaultS3ControlEndpointProvider.endpointRule_139()));
    }

    private static Rule endpointRule_125() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_126(), DefaultS3ControlEndpointProvider.endpointRule_131()));
    }

    private static Rule endpointRule_123() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_124(), DefaultS3ControlEndpointProvider.endpointRule_125()));
    }

    private static Rule endpointRule_121() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_122(), DefaultS3ControlEndpointProvider.endpointRule_123()));
    }

    private static Rule endpointRule_119() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_120(), DefaultS3ControlEndpointProvider.endpointRule_121()));
    }

    private static Rule endpointRule_118() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isValidHostLabel").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_119()));
    }

    private static Rule endpointRule_140() {
        return Rule.builder().error("Invalid region: region was not a valid DNS name.");
    }

    private static Rule endpointRule_117() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_118(), DefaultS3ControlEndpointProvider.endpointRule_140()));
    }

    private static Rule endpointRule_116() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("aws.partition").argv(Arrays.asList(Expr.ref(Identifier.of("Region")))).build().validate()).result("partitionResult").build()).treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_117()));
    }

    private static Rule endpointRule_141() {
        return Rule.builder().error("A valid partition could not be determined");
    }

    private static Rule endpointRule_115() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_116(), DefaultS3ControlEndpointProvider.endpointRule_141()));
    }

    private static Rule endpointRule_2() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_3(), DefaultS3ControlEndpointProvider.endpointRule_23(), DefaultS3ControlEndpointProvider.endpointRule_69(), DefaultS3ControlEndpointProvider.endpointRule_115()));
    }

    private static Rule endpointRule_1() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Region")))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_2()));
    }

    private static Rule endpointRule_142() {
        return Rule.builder().error("Region must be set");
    }

    private static Rule endpointRule_0() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3ControlEndpointProvider.endpointRule_1(), DefaultS3ControlEndpointProvider.endpointRule_142()));
    }

    private static EndpointRuleset ruleSet() {
        return EndpointRuleset.builder().version("1.0").serviceId(null).parameters(Parameters.builder().addParameter(Parameter.builder().name("Region").type(ParameterType.fromValue("String")).required(false).builtIn("AWS::Region").documentation("The AWS region used to dispatch the request.").build()).addParameter(Parameter.builder().name("UseFIPS").type(ParameterType.fromValue("Boolean")).required(true).builtIn("AWS::UseFIPS").documentation("When true, send this request to the FIPS-compliant regional endpoint. If the configured endpoint does not have a FIPS compliant endpoint, dispatching the request will return an error.").defaultValue(Value.fromBool(false)).build()).addParameter(Parameter.builder().name("UseDualStack").type(ParameterType.fromValue("Boolean")).required(true).builtIn("AWS::UseDualStack").documentation("When true, use the dual-stack endpoint. If the configured endpoint does not support dual-stack, dispatching the request MAY return an error.").defaultValue(Value.fromBool(false)).build()).addParameter(Parameter.builder().name("Endpoint").type(ParameterType.fromValue("String")).required(false).builtIn("SDK::Endpoint").documentation("Override the endpoint used to send this request").build()).addParameter(Parameter.builder().name("AccountId").type(ParameterType.fromValue("String")).required(false).documentation("The Account ID used to send the request. This is an optional parameter that will be set automatically for operations that require it.").build()).addParameter(Parameter.builder().name("RequiresAccountId").type(ParameterType.fromValue("Boolean")).required(false).documentation("Internal parameter for operations that require account id host prefix.").build()).addParameter(Parameter.builder().name("OutpostId").type(ParameterType.fromValue("String")).required(false).documentation("The Outpost ID.  Some operations have an optional OutpostId which should be used in endpoint construction.").build()).addParameter(Parameter.builder().name("Bucket").type(ParameterType.fromValue("String")).required(false).documentation("The S3 bucket used to send the request. This is an optional parameter that will be set automatically for operations that are scoped to an S3 bucket.").build()).addParameter(Parameter.builder().name("AccessPointName").type(ParameterType.fromValue("String")).required(false).documentation("The S3 AccessPointName used to send the request. This is an optional parameter that will be set automatically for operations that are scoped to an S3 AccessPoint.").build()).addParameter(Parameter.builder().name("UseArnRegion").type(ParameterType.fromValue("Boolean")).required(false).builtIn("AWS::S3Control::UseArnRegion").documentation("When an Access Point ARN is provided and this flag is enabled, the SDK MUST use the ARN's region when constructing the endpoint instead of the client's configured region.").build()).build()).addRule(DefaultS3ControlEndpointProvider.endpointRule_0()).build();
    }
}

