/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3control.model.ActivityMetrics;
import software.amazon.awssdk.services.s3control.model.BucketLevel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccountLevel
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccountLevel> {
    private static final SdkField<ActivityMetrics> ACTIVITY_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ActivityMetrics").getter(AccountLevel.getter(AccountLevel::activityMetrics)).setter(AccountLevel.setter(Builder::activityMetrics)).constructor(ActivityMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivityMetrics").unmarshallLocationName("ActivityMetrics").build()}).build();
    private static final SdkField<BucketLevel> BUCKET_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BucketLevel").getter(AccountLevel.getter(AccountLevel::bucketLevel)).setter(AccountLevel.setter(Builder::bucketLevel)).constructor(BucketLevel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketLevel").unmarshallLocationName("BucketLevel").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVITY_METRICS_FIELD, BUCKET_LEVEL_FIELD));
    private static final long serialVersionUID = 1L;
    private final ActivityMetrics activityMetrics;
    private final BucketLevel bucketLevel;

    private AccountLevel(BuilderImpl builder) {
        this.activityMetrics = builder.activityMetrics;
        this.bucketLevel = builder.bucketLevel;
    }

    public final ActivityMetrics activityMetrics() {
        return this.activityMetrics;
    }

    public final BucketLevel bucketLevel() {
        return this.bucketLevel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.activityMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketLevel());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountLevel)) {
            return false;
        }
        AccountLevel other = (AccountLevel)obj;
        return Objects.equals(this.activityMetrics(), other.activityMetrics()) && Objects.equals(this.bucketLevel(), other.bucketLevel());
    }

    public final String toString() {
        return ToString.builder((String)"AccountLevel").add("ActivityMetrics", (Object)this.activityMetrics()).add("BucketLevel", (Object)this.bucketLevel()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActivityMetrics": {
                return Optional.ofNullable(clazz.cast(this.activityMetrics()));
            }
            case "BucketLevel": {
                return Optional.ofNullable(clazz.cast(this.bucketLevel()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccountLevel, T> g) {
        return obj -> g.apply((AccountLevel)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ActivityMetrics activityMetrics;
        private BucketLevel bucketLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountLevel model) {
            this.activityMetrics(model.activityMetrics);
            this.bucketLevel(model.bucketLevel);
        }

        public final ActivityMetrics.Builder getActivityMetrics() {
            return this.activityMetrics != null ? this.activityMetrics.toBuilder() : null;
        }

        public final void setActivityMetrics(ActivityMetrics.BuilderImpl activityMetrics) {
            this.activityMetrics = activityMetrics != null ? activityMetrics.build() : null;
        }

        @Override
        @Transient
        public final Builder activityMetrics(ActivityMetrics activityMetrics) {
            this.activityMetrics = activityMetrics;
            return this;
        }

        public final BucketLevel.Builder getBucketLevel() {
            return this.bucketLevel != null ? this.bucketLevel.toBuilder() : null;
        }

        public final void setBucketLevel(BucketLevel.BuilderImpl bucketLevel) {
            this.bucketLevel = bucketLevel != null ? bucketLevel.build() : null;
        }

        @Override
        @Transient
        public final Builder bucketLevel(BucketLevel bucketLevel) {
            this.bucketLevel = bucketLevel;
            return this;
        }

        public AccountLevel build() {
            return new AccountLevel(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccountLevel> {
        public Builder activityMetrics(ActivityMetrics var1);

        default public Builder activityMetrics(Consumer<ActivityMetrics.Builder> activityMetrics) {
            return this.activityMetrics((ActivityMetrics)((ActivityMetrics.Builder)ActivityMetrics.builder().applyMutation(activityMetrics)).build());
        }

        public Builder bucketLevel(BucketLevel var1);

        default public Builder bucketLevel(Consumer<BucketLevel.Builder> bucketLevel) {
            return this.bucketLevel((BucketLevel)((BucketLevel.Builder)BucketLevel.builder().applyMutation(bucketLevel)).build());
        }
    }
}

