/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3control.model.CreateMultiRegionAccessPointInput;
import software.amazon.awssdk.services.s3control.model.S3ControlRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMultiRegionAccessPointRequest
extends S3ControlRequest
implements ToCopyableBuilder<Builder, CreateMultiRegionAccessPointRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(CreateMultiRegionAccessPointRequest.getter(CreateMultiRegionAccessPointRequest::accountId)).setter(CreateMultiRegionAccessPointRequest.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-account-id").unmarshallLocationName("x-amz-account-id").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateMultiRegionAccessPointRequest.getter(CreateMultiRegionAccessPointRequest::clientToken)).setter(CreateMultiRegionAccessPointRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<CreateMultiRegionAccessPointInput> DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Details").getter(CreateMultiRegionAccessPointRequest.getter(CreateMultiRegionAccessPointRequest::details)).setter(CreateMultiRegionAccessPointRequest.setter(Builder::details)).constructor(CreateMultiRegionAccessPointInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Details").unmarshallLocationName("Details").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, CLIENT_TOKEN_FIELD, DETAILS_FIELD));
    private final String accountId;
    private final String clientToken;
    private final CreateMultiRegionAccessPointInput details;

    private CreateMultiRegionAccessPointRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.clientToken = builder.clientToken;
        this.details = builder.details;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final CreateMultiRegionAccessPointInput details() {
        return this.details;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.details());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMultiRegionAccessPointRequest)) {
            return false;
        }
        CreateMultiRegionAccessPointRequest other = (CreateMultiRegionAccessPointRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.details(), other.details());
    }

    public final String toString() {
        return ToString.builder((String)"CreateMultiRegionAccessPointRequest").add("AccountId", (Object)this.accountId()).add("ClientToken", (Object)this.clientToken()).add("Details", (Object)this.details()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "Details": {
                return Optional.ofNullable(clazz.cast(this.details()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMultiRegionAccessPointRequest, T> g) {
        return obj -> g.apply((CreateMultiRegionAccessPointRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3ControlRequest.BuilderImpl
    implements Builder {
        private String accountId;
        private String clientToken;
        private CreateMultiRegionAccessPointInput details;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMultiRegionAccessPointRequest model) {
            super(model);
            this.accountId(model.accountId);
            this.clientToken(model.clientToken);
            this.details(model.details);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        @Transient
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final CreateMultiRegionAccessPointInput.Builder getDetails() {
            return this.details != null ? this.details.toBuilder() : null;
        }

        public final void setDetails(CreateMultiRegionAccessPointInput.BuilderImpl details) {
            this.details = details != null ? details.build() : null;
        }

        @Override
        @Transient
        public final Builder details(CreateMultiRegionAccessPointInput details) {
            this.details = details;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMultiRegionAccessPointRequest build() {
            return new CreateMultiRegionAccessPointRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends S3ControlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateMultiRegionAccessPointRequest> {
        public Builder accountId(String var1);

        public Builder clientToken(String var1);

        public Builder details(CreateMultiRegionAccessPointInput var1);

        default public Builder details(Consumer<CreateMultiRegionAccessPointInput.Builder> details) {
            return this.details((CreateMultiRegionAccessPointInput)((CreateMultiRegionAccessPointInput.Builder)CreateMultiRegionAccessPointInput.builder().applyMutation(details)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

