/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.s3control.model.JobStatus;
import software.amazon.awssdk.services.s3control.model.JobStatusListCopier;
import software.amazon.awssdk.services.s3control.model.S3ControlRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListJobsRequest
extends S3ControlRequest
implements ToCopyableBuilder<Builder, ListJobsRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(ListJobsRequest.getter(ListJobsRequest::accountId)).setter(ListJobsRequest.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-account-id").unmarshallLocationName("x-amz-account-id").build()}).build();
    private static final SdkField<List<String>> JOB_STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("JobStatuses").getter(ListJobsRequest.getter(ListJobsRequest::jobStatusesAsStrings)).setter(ListJobsRequest.setter(Builder::jobStatusesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("jobStatuses").unmarshallLocationName("jobStatuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListJobsRequest.getter(ListJobsRequest::nextToken)).setter(ListJobsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListJobsRequest.getter(ListJobsRequest::maxResults)).setter(ListJobsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").unmarshallLocationName("maxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, JOB_STATUSES_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final String accountId;
    private final List<String> jobStatuses;
    private final String nextToken;
    private final Integer maxResults;

    private ListJobsRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.jobStatuses = builder.jobStatuses;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final List<JobStatus> jobStatuses() {
        return JobStatusListCopier.copyStringToEnum(this.jobStatuses);
    }

    public final boolean hasJobStatuses() {
        return this.jobStatuses != null && !(this.jobStatuses instanceof SdkAutoConstructList);
    }

    public final List<String> jobStatusesAsStrings() {
        return this.jobStatuses;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasJobStatuses() ? this.jobStatusesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobsRequest)) {
            return false;
        }
        ListJobsRequest other = (ListJobsRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && this.hasJobStatuses() == other.hasJobStatuses() && Objects.equals(this.jobStatusesAsStrings(), other.jobStatusesAsStrings()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"ListJobsRequest").add("AccountId", (Object)this.accountId()).add("JobStatuses", this.hasJobStatuses() ? this.jobStatusesAsStrings() : null).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "JobStatuses": {
                return Optional.ofNullable(clazz.cast(this.jobStatusesAsStrings()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListJobsRequest, T> g) {
        return obj -> g.apply((ListJobsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3ControlRequest.BuilderImpl
    implements Builder {
        private String accountId;
        private List<String> jobStatuses = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListJobsRequest model) {
            super(model);
            this.accountId(model.accountId);
            this.jobStatusesWithStrings(model.jobStatuses);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final Collection<String> getJobStatuses() {
            if (this.jobStatuses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.jobStatuses;
        }

        public final void setJobStatuses(Collection<String> jobStatuses) {
            this.jobStatuses = JobStatusListCopier.copy(jobStatuses);
        }

        @Override
        public final Builder jobStatusesWithStrings(Collection<String> jobStatuses) {
            this.jobStatuses = JobStatusListCopier.copy(jobStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobStatusesWithStrings(String ... jobStatuses) {
            this.jobStatusesWithStrings(Arrays.asList(jobStatuses));
            return this;
        }

        @Override
        public final Builder jobStatuses(Collection<JobStatus> jobStatuses) {
            this.jobStatuses = JobStatusListCopier.copyEnumToString(jobStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobStatuses(JobStatus ... jobStatuses) {
            this.jobStatuses(Arrays.asList(jobStatuses));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListJobsRequest build() {
            return new ListJobsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends S3ControlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListJobsRequest> {
        public Builder accountId(String var1);

        public Builder jobStatusesWithStrings(Collection<String> var1);

        public Builder jobStatusesWithStrings(String ... var1);

        public Builder jobStatuses(Collection<JobStatus> var1);

        public Builder jobStatuses(JobStatus ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

