/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.s3control.S3ControlAsyncClient;
import software.amazon.awssdk.services.s3control.model.ListRegionalBucketsRequest;
import software.amazon.awssdk.services.s3control.model.ListRegionalBucketsResponse;

public class ListRegionalBucketsPublisher
implements SdkPublisher<ListRegionalBucketsResponse> {
    private final S3ControlAsyncClient client;
    private final ListRegionalBucketsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRegionalBucketsPublisher(S3ControlAsyncClient client, ListRegionalBucketsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRegionalBucketsPublisher(S3ControlAsyncClient client, ListRegionalBucketsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRegionalBucketsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRegionalBucketsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListRegionalBucketsResponseFetcher
    implements AsyncPageFetcher<ListRegionalBucketsResponse> {
        private ListRegionalBucketsResponseFetcher() {
        }

        public boolean hasNextPage(ListRegionalBucketsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRegionalBucketsResponse> nextPage(ListRegionalBucketsResponse previousPage) {
            if (previousPage == null) {
                return ListRegionalBucketsPublisher.this.client.listRegionalBuckets(ListRegionalBucketsPublisher.this.firstRequest);
            }
            return ListRegionalBucketsPublisher.this.client.listRegionalBuckets((ListRegionalBucketsRequest)((Object)ListRegionalBucketsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

