/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.signer.AwsS3V4Signer;
import software.amazon.awssdk.awscore.client.builder.AwsDefaultClientBuilder;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.interceptor.ClasspathInterceptorChainFactory;
import software.amazon.awssdk.core.signer.Signer;
import software.amazon.awssdk.profiles.ProfileFile;
import software.amazon.awssdk.services.s3control.S3ControlBaseClientBuilder;
import software.amazon.awssdk.services.s3control.S3ControlConfiguration;
import software.amazon.awssdk.utils.CollectionUtils;

@SdkInternalApi
abstract class DefaultS3ControlBaseClientBuilder<B extends S3ControlBaseClientBuilder<B, C>, C>
extends AwsDefaultClientBuilder<B, C> {
    DefaultS3ControlBaseClientBuilder() {
    }

    protected final String serviceEndpointPrefix() {
        return "s3-control";
    }

    protected final String serviceName() {
        return "S3Control";
    }

    protected final SdkClientConfiguration mergeServiceDefaults(SdkClientConfiguration config) {
        return config.merge(c -> c.option((ClientOption)SdkAdvancedClientOption.SIGNER, (Object)this.defaultSigner()).option((ClientOption)SdkClientOption.CRC32_FROM_COMPRESSED_DATA_ENABLED, (Object)false).option((ClientOption)SdkClientOption.SERVICE_CONFIGURATION, S3ControlConfiguration.builder().build()));
    }

    protected final SdkClientConfiguration finalizeServiceConfiguration(SdkClientConfiguration config) {
        S3ControlConfiguration.Builder c;
        ClasspathInterceptorChainFactory interceptorFactory = new ClasspathInterceptorChainFactory();
        List interceptors = interceptorFactory.getInterceptors("software/amazon/awssdk/services/s3control/execution.interceptors");
        interceptors = CollectionUtils.mergeLists((List)interceptors, (List)((List)config.option((ClientOption)SdkClientOption.EXECUTION_INTERCEPTORS)));
        c.profileFile((c = ((S3ControlConfiguration)config.option((ClientOption)SdkClientOption.SERVICE_CONFIGURATION)).toBuilder()).profileFile() != null ? c.profileFile() : (ProfileFile)config.option((ClientOption)SdkClientOption.PROFILE_FILE)).profileName(c.profileName() != null ? c.profileName() : (String)config.option((ClientOption)SdkClientOption.PROFILE_NAME));
        return config.toBuilder().option((ClientOption)SdkClientOption.EXECUTION_INTERCEPTORS, (Object)interceptors).option((ClientOption)SdkClientOption.SERVICE_CONFIGURATION, c.build()).build();
    }

    private Signer defaultSigner() {
        return AwsS3V4Signer.create();
    }

    protected final String signingName() {
        return "s3";
    }

    public B serviceConfiguration(S3ControlConfiguration serviceConfiguration) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.SERVICE_CONFIGURATION, (Object)serviceConfiguration);
        return (B)((S3ControlBaseClientBuilder)this.thisBuilder());
    }

    public void setServiceConfiguration(S3ControlConfiguration serviceConfiguration) {
        this.serviceConfiguration(serviceConfiguration);
    }
}

