/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3control.model.PublicAccessBlockConfiguration;
import software.amazon.awssdk.services.s3control.model.S3ControlResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAccessPointForObjectLambdaResponse
extends S3ControlResponse
implements ToCopyableBuilder<Builder, GetAccessPointForObjectLambdaResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GetAccessPointForObjectLambdaResponse.getter(GetAccessPointForObjectLambdaResponse::name)).setter(GetAccessPointForObjectLambdaResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").unmarshallLocationName("Name").build()}).build();
    private static final SdkField<PublicAccessBlockConfiguration> PUBLIC_ACCESS_BLOCK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PublicAccessBlockConfiguration").getter(GetAccessPointForObjectLambdaResponse.getter(GetAccessPointForObjectLambdaResponse::publicAccessBlockConfiguration)).setter(GetAccessPointForObjectLambdaResponse.setter(Builder::publicAccessBlockConfiguration)).constructor(PublicAccessBlockConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicAccessBlockConfiguration").unmarshallLocationName("PublicAccessBlockConfiguration").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationDate").getter(GetAccessPointForObjectLambdaResponse.getter(GetAccessPointForObjectLambdaResponse::creationDate)).setter(GetAccessPointForObjectLambdaResponse.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").unmarshallLocationName("CreationDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, PUBLIC_ACCESS_BLOCK_CONFIGURATION_FIELD, CREATION_DATE_FIELD));
    private final String name;
    private final PublicAccessBlockConfiguration publicAccessBlockConfiguration;
    private final Instant creationDate;

    private GetAccessPointForObjectLambdaResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.publicAccessBlockConfiguration = builder.publicAccessBlockConfiguration;
        this.creationDate = builder.creationDate;
    }

    public final String name() {
        return this.name;
    }

    public final PublicAccessBlockConfiguration publicAccessBlockConfiguration() {
        return this.publicAccessBlockConfiguration;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicAccessBlockConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccessPointForObjectLambdaResponse)) {
            return false;
        }
        GetAccessPointForObjectLambdaResponse other = (GetAccessPointForObjectLambdaResponse)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.publicAccessBlockConfiguration(), other.publicAccessBlockConfiguration()) && Objects.equals(this.creationDate(), other.creationDate());
    }

    public final String toString() {
        return ToString.builder((String)"GetAccessPointForObjectLambdaResponse").add("Name", (Object)this.name()).add("PublicAccessBlockConfiguration", (Object)this.publicAccessBlockConfiguration()).add("CreationDate", (Object)this.creationDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "PublicAccessBlockConfiguration": {
                return Optional.ofNullable(clazz.cast(this.publicAccessBlockConfiguration()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAccessPointForObjectLambdaResponse, T> g) {
        return obj -> g.apply((GetAccessPointForObjectLambdaResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3ControlResponse.BuilderImpl
    implements Builder {
        private String name;
        private PublicAccessBlockConfiguration publicAccessBlockConfiguration;
        private Instant creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccessPointForObjectLambdaResponse model) {
            super(model);
            this.name(model.name);
            this.publicAccessBlockConfiguration(model.publicAccessBlockConfiguration);
            this.creationDate(model.creationDate);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final PublicAccessBlockConfiguration.Builder getPublicAccessBlockConfiguration() {
            return this.publicAccessBlockConfiguration != null ? this.publicAccessBlockConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder publicAccessBlockConfiguration(PublicAccessBlockConfiguration publicAccessBlockConfiguration) {
            this.publicAccessBlockConfiguration = publicAccessBlockConfiguration;
            return this;
        }

        public final void setPublicAccessBlockConfiguration(PublicAccessBlockConfiguration.BuilderImpl publicAccessBlockConfiguration) {
            this.publicAccessBlockConfiguration = publicAccessBlockConfiguration != null ? publicAccessBlockConfiguration.build() : null;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public GetAccessPointForObjectLambdaResponse build() {
            return new GetAccessPointForObjectLambdaResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends S3ControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAccessPointForObjectLambdaResponse> {
        public Builder name(String var1);

        public Builder publicAccessBlockConfiguration(PublicAccessBlockConfiguration var1);

        default public Builder publicAccessBlockConfiguration(Consumer<PublicAccessBlockConfiguration.Builder> publicAccessBlockConfiguration) {
            return this.publicAccessBlockConfiguration((PublicAccessBlockConfiguration)((PublicAccessBlockConfiguration.Builder)PublicAccessBlockConfiguration.builder().applyMutation(publicAccessBlockConfiguration)).build());
        }

        public Builder creationDate(Instant var1);
    }
}

