/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3control.model.JobManifestLocation;
import software.amazon.awssdk.services.s3control.model.JobManifestSpec;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobManifest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobManifest> {
    private static final SdkField<JobManifestSpec> SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Spec").getter(JobManifest.getter(JobManifest::spec)).setter(JobManifest.setter(Builder::spec)).constructor(JobManifestSpec::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Spec").unmarshallLocationName("Spec").build()}).build();
    private static final SdkField<JobManifestLocation> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Location").getter(JobManifest.getter(JobManifest::location)).setter(JobManifest.setter(Builder::location)).constructor(JobManifestLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").unmarshallLocationName("Location").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPEC_FIELD, LOCATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final JobManifestSpec spec;
    private final JobManifestLocation location;

    private JobManifest(BuilderImpl builder) {
        this.spec = builder.spec;
        this.location = builder.location;
    }

    public final JobManifestSpec spec() {
        return this.spec;
    }

    public final JobManifestLocation location() {
        return this.location;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.spec());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobManifest)) {
            return false;
        }
        JobManifest other = (JobManifest)obj;
        return Objects.equals(this.spec(), other.spec()) && Objects.equals(this.location(), other.location());
    }

    public final String toString() {
        return ToString.builder((String)"JobManifest").add("Spec", (Object)this.spec()).add("Location", (Object)this.location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Spec": {
                return Optional.ofNullable(clazz.cast(this.spec()));
            }
            case "Location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobManifest, T> g) {
        return obj -> g.apply((JobManifest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private JobManifestSpec spec;
        private JobManifestLocation location;

        private BuilderImpl() {
        }

        private BuilderImpl(JobManifest model) {
            this.spec(model.spec);
            this.location(model.location);
        }

        public final JobManifestSpec.Builder getSpec() {
            return this.spec != null ? this.spec.toBuilder() : null;
        }

        @Override
        public final Builder spec(JobManifestSpec spec) {
            this.spec = spec;
            return this;
        }

        public final void setSpec(JobManifestSpec.BuilderImpl spec) {
            this.spec = spec != null ? spec.build() : null;
        }

        public final JobManifestLocation.Builder getLocation() {
            return this.location != null ? this.location.toBuilder() : null;
        }

        @Override
        public final Builder location(JobManifestLocation location) {
            this.location = location;
            return this;
        }

        public final void setLocation(JobManifestLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        public JobManifest build() {
            return new JobManifest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobManifest> {
        public Builder spec(JobManifestSpec var1);

        default public Builder spec(Consumer<JobManifestSpec.Builder> spec) {
            return this.spec((JobManifestSpec)((JobManifestSpec.Builder)JobManifestSpec.builder().applyMutation(spec)).build());
        }

        public Builder location(JobManifestLocation var1);

        default public Builder location(Consumer<JobManifestLocation.Builder> location) {
            return this.location((JobManifestLocation)((JobManifestLocation.Builder)JobManifestLocation.builder().applyMutation(location)).build());
        }
    }
}

