/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobProgressSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobProgressSummary> {
    private static final SdkField<Long> TOTAL_NUMBER_OF_TASKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TotalNumberOfTasks").getter(JobProgressSummary.getter(JobProgressSummary::totalNumberOfTasks)).setter(JobProgressSummary.setter(Builder::totalNumberOfTasks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalNumberOfTasks").unmarshallLocationName("TotalNumberOfTasks").build()}).build();
    private static final SdkField<Long> NUMBER_OF_TASKS_SUCCEEDED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("NumberOfTasksSucceeded").getter(JobProgressSummary.getter(JobProgressSummary::numberOfTasksSucceeded)).setter(JobProgressSummary.setter(Builder::numberOfTasksSucceeded)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfTasksSucceeded").unmarshallLocationName("NumberOfTasksSucceeded").build()}).build();
    private static final SdkField<Long> NUMBER_OF_TASKS_FAILED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("NumberOfTasksFailed").getter(JobProgressSummary.getter(JobProgressSummary::numberOfTasksFailed)).setter(JobProgressSummary.setter(Builder::numberOfTasksFailed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfTasksFailed").unmarshallLocationName("NumberOfTasksFailed").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_NUMBER_OF_TASKS_FIELD, NUMBER_OF_TASKS_SUCCEEDED_FIELD, NUMBER_OF_TASKS_FAILED_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long totalNumberOfTasks;
    private final Long numberOfTasksSucceeded;
    private final Long numberOfTasksFailed;

    private JobProgressSummary(BuilderImpl builder) {
        this.totalNumberOfTasks = builder.totalNumberOfTasks;
        this.numberOfTasksSucceeded = builder.numberOfTasksSucceeded;
        this.numberOfTasksFailed = builder.numberOfTasksFailed;
    }

    public Long totalNumberOfTasks() {
        return this.totalNumberOfTasks;
    }

    public Long numberOfTasksSucceeded() {
        return this.numberOfTasksSucceeded;
    }

    public Long numberOfTasksFailed() {
        return this.numberOfTasksFailed;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.totalNumberOfTasks());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfTasksSucceeded());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfTasksFailed());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobProgressSummary)) {
            return false;
        }
        JobProgressSummary other = (JobProgressSummary)obj;
        return Objects.equals(this.totalNumberOfTasks(), other.totalNumberOfTasks()) && Objects.equals(this.numberOfTasksSucceeded(), other.numberOfTasksSucceeded()) && Objects.equals(this.numberOfTasksFailed(), other.numberOfTasksFailed());
    }

    public String toString() {
        return ToString.builder((String)"JobProgressSummary").add("TotalNumberOfTasks", (Object)this.totalNumberOfTasks()).add("NumberOfTasksSucceeded", (Object)this.numberOfTasksSucceeded()).add("NumberOfTasksFailed", (Object)this.numberOfTasksFailed()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TotalNumberOfTasks": {
                return Optional.ofNullable(clazz.cast(this.totalNumberOfTasks()));
            }
            case "NumberOfTasksSucceeded": {
                return Optional.ofNullable(clazz.cast(this.numberOfTasksSucceeded()));
            }
            case "NumberOfTasksFailed": {
                return Optional.ofNullable(clazz.cast(this.numberOfTasksFailed()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobProgressSummary, T> g) {
        return obj -> g.apply((JobProgressSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long totalNumberOfTasks;
        private Long numberOfTasksSucceeded;
        private Long numberOfTasksFailed;

        private BuilderImpl() {
        }

        private BuilderImpl(JobProgressSummary model) {
            this.totalNumberOfTasks(model.totalNumberOfTasks);
            this.numberOfTasksSucceeded(model.numberOfTasksSucceeded);
            this.numberOfTasksFailed(model.numberOfTasksFailed);
        }

        public final Long getTotalNumberOfTasks() {
            return this.totalNumberOfTasks;
        }

        @Override
        public final Builder totalNumberOfTasks(Long totalNumberOfTasks) {
            this.totalNumberOfTasks = totalNumberOfTasks;
            return this;
        }

        public final void setTotalNumberOfTasks(Long totalNumberOfTasks) {
            this.totalNumberOfTasks = totalNumberOfTasks;
        }

        public final Long getNumberOfTasksSucceeded() {
            return this.numberOfTasksSucceeded;
        }

        @Override
        public final Builder numberOfTasksSucceeded(Long numberOfTasksSucceeded) {
            this.numberOfTasksSucceeded = numberOfTasksSucceeded;
            return this;
        }

        public final void setNumberOfTasksSucceeded(Long numberOfTasksSucceeded) {
            this.numberOfTasksSucceeded = numberOfTasksSucceeded;
        }

        public final Long getNumberOfTasksFailed() {
            return this.numberOfTasksFailed;
        }

        @Override
        public final Builder numberOfTasksFailed(Long numberOfTasksFailed) {
            this.numberOfTasksFailed = numberOfTasksFailed;
            return this;
        }

        public final void setNumberOfTasksFailed(Long numberOfTasksFailed) {
            this.numberOfTasksFailed = numberOfTasksFailed;
        }

        public JobProgressSummary build() {
            return new JobProgressSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobProgressSummary> {
        public Builder totalNumberOfTasks(Long var1);

        public Builder numberOfTasksSucceeded(Long var1);

        public Builder numberOfTasksFailed(Long var1);
    }
}

