/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.s3control.model.AccessPoint;
import software.amazon.awssdk.services.s3control.model.AccessPointListCopier;
import software.amazon.awssdk.services.s3control.model.S3ControlResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAccessPointsResponse
extends S3ControlResponse
implements ToCopyableBuilder<Builder, ListAccessPointsResponse> {
    private static final SdkField<List<AccessPoint>> ACCESS_POINT_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AccessPointList").getter(ListAccessPointsResponse.getter(ListAccessPointsResponse::accessPointList)).setter(ListAccessPointsResponse.setter(Builder::accessPointList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessPointList").unmarshallLocationName("AccessPointList").build(), ListTrait.builder().memberLocationName("AccessPoint").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccessPoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessPoint").unmarshallLocationName("AccessPoint").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAccessPointsResponse.getter(ListAccessPointsResponse::nextToken)).setter(ListAccessPointsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_POINT_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<AccessPoint> accessPointList;
    private final String nextToken;

    private ListAccessPointsResponse(BuilderImpl builder) {
        super(builder);
        this.accessPointList = builder.accessPointList;
        this.nextToken = builder.nextToken;
    }

    public boolean hasAccessPointList() {
        return this.accessPointList != null && !(this.accessPointList instanceof SdkAutoConstructList);
    }

    public List<AccessPoint> accessPointList() {
        return this.accessPointList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accessPointList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccessPointsResponse)) {
            return false;
        }
        ListAccessPointsResponse other = (ListAccessPointsResponse)((Object)obj);
        return Objects.equals(this.accessPointList(), other.accessPointList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListAccessPointsResponse").add("AccessPointList", this.accessPointList()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessPointList": {
                return Optional.ofNullable(clazz.cast(this.accessPointList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAccessPointsResponse, T> g) {
        return obj -> g.apply((ListAccessPointsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3ControlResponse.BuilderImpl
    implements Builder {
        private List<AccessPoint> accessPointList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccessPointsResponse model) {
            super(model);
            this.accessPointList(model.accessPointList);
            this.nextToken(model.nextToken);
        }

        public final Collection<AccessPoint.Builder> getAccessPointList() {
            return this.accessPointList != null ? (Collection)this.accessPointList.stream().map(AccessPoint::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder accessPointList(Collection<AccessPoint> accessPointList) {
            this.accessPointList = AccessPointListCopier.copy(accessPointList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessPointList(AccessPoint ... accessPointList) {
            this.accessPointList(Arrays.asList(accessPointList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessPointList(Consumer<AccessPoint.Builder> ... accessPointList) {
            this.accessPointList(Stream.of(accessPointList).map(c -> (AccessPoint)((AccessPoint.Builder)AccessPoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAccessPointList(Collection<AccessPoint.BuilderImpl> accessPointList) {
            this.accessPointList = AccessPointListCopier.copyFromBuilder(accessPointList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAccessPointsResponse build() {
            return new ListAccessPointsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends S3ControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAccessPointsResponse> {
        public Builder accessPointList(Collection<AccessPoint> var1);

        public Builder accessPointList(AccessPoint ... var1);

        public Builder accessPointList(Consumer<AccessPoint.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

