/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.xml.AwsXmlProtocolFactory;
import software.amazon.awssdk.protocols.xml.XmlOperationMetadata;
import software.amazon.awssdk.services.s3control.S3ControlClient;
import software.amazon.awssdk.services.s3control.model.BadRequestException;
import software.amazon.awssdk.services.s3control.model.CreateAccessPointRequest;
import software.amazon.awssdk.services.s3control.model.CreateAccessPointResponse;
import software.amazon.awssdk.services.s3control.model.CreateJobRequest;
import software.amazon.awssdk.services.s3control.model.CreateJobResponse;
import software.amazon.awssdk.services.s3control.model.DeleteAccessPointPolicyRequest;
import software.amazon.awssdk.services.s3control.model.DeleteAccessPointPolicyResponse;
import software.amazon.awssdk.services.s3control.model.DeleteAccessPointRequest;
import software.amazon.awssdk.services.s3control.model.DeleteAccessPointResponse;
import software.amazon.awssdk.services.s3control.model.DeleteJobTaggingRequest;
import software.amazon.awssdk.services.s3control.model.DeleteJobTaggingResponse;
import software.amazon.awssdk.services.s3control.model.DeletePublicAccessBlockRequest;
import software.amazon.awssdk.services.s3control.model.DeletePublicAccessBlockResponse;
import software.amazon.awssdk.services.s3control.model.DescribeJobRequest;
import software.amazon.awssdk.services.s3control.model.DescribeJobResponse;
import software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyRequest;
import software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyResponse;
import software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyStatusRequest;
import software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyStatusResponse;
import software.amazon.awssdk.services.s3control.model.GetAccessPointRequest;
import software.amazon.awssdk.services.s3control.model.GetAccessPointResponse;
import software.amazon.awssdk.services.s3control.model.GetJobTaggingRequest;
import software.amazon.awssdk.services.s3control.model.GetJobTaggingResponse;
import software.amazon.awssdk.services.s3control.model.GetPublicAccessBlockRequest;
import software.amazon.awssdk.services.s3control.model.GetPublicAccessBlockResponse;
import software.amazon.awssdk.services.s3control.model.IdempotencyException;
import software.amazon.awssdk.services.s3control.model.InternalServiceException;
import software.amazon.awssdk.services.s3control.model.InvalidNextTokenException;
import software.amazon.awssdk.services.s3control.model.InvalidRequestException;
import software.amazon.awssdk.services.s3control.model.JobStatusException;
import software.amazon.awssdk.services.s3control.model.ListAccessPointsRequest;
import software.amazon.awssdk.services.s3control.model.ListAccessPointsResponse;
import software.amazon.awssdk.services.s3control.model.ListJobsRequest;
import software.amazon.awssdk.services.s3control.model.ListJobsResponse;
import software.amazon.awssdk.services.s3control.model.NoSuchPublicAccessBlockConfigurationException;
import software.amazon.awssdk.services.s3control.model.NotFoundException;
import software.amazon.awssdk.services.s3control.model.PutAccessPointPolicyRequest;
import software.amazon.awssdk.services.s3control.model.PutAccessPointPolicyResponse;
import software.amazon.awssdk.services.s3control.model.PutJobTaggingRequest;
import software.amazon.awssdk.services.s3control.model.PutJobTaggingResponse;
import software.amazon.awssdk.services.s3control.model.PutPublicAccessBlockRequest;
import software.amazon.awssdk.services.s3control.model.PutPublicAccessBlockResponse;
import software.amazon.awssdk.services.s3control.model.S3ControlException;
import software.amazon.awssdk.services.s3control.model.S3ControlRequest;
import software.amazon.awssdk.services.s3control.model.TooManyRequestsException;
import software.amazon.awssdk.services.s3control.model.TooManyTagsException;
import software.amazon.awssdk.services.s3control.model.UpdateJobPriorityRequest;
import software.amazon.awssdk.services.s3control.model.UpdateJobPriorityResponse;
import software.amazon.awssdk.services.s3control.model.UpdateJobStatusRequest;
import software.amazon.awssdk.services.s3control.model.UpdateJobStatusResponse;
import software.amazon.awssdk.services.s3control.paginators.ListAccessPointsIterable;
import software.amazon.awssdk.services.s3control.paginators.ListJobsIterable;
import software.amazon.awssdk.services.s3control.transform.CreateAccessPointRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.CreateJobRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteAccessPointPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteAccessPointRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteJobTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeletePublicAccessBlockRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DescribeJobRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetAccessPointPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetAccessPointPolicyStatusRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetAccessPointRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetJobTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetPublicAccessBlockRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.ListAccessPointsRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.ListJobsRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutAccessPointPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutJobTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutPublicAccessBlockRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.UpdateJobPriorityRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.UpdateJobStatusRequestMarshaller;

@SdkInternalApi
final class DefaultS3ControlClient
implements S3ControlClient {
    private final SyncClientHandler clientHandler;
    private final AwsXmlProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultS3ControlClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init();
    }

    public final String serviceName() {
        return "s3";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAccessPointResponse createAccessPoint(CreateAccessPointRequest createAccessPointRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateAccessPointResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAccessPoint");
            CreateAccessPointResponse createAccessPointResponse = (CreateAccessPointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAccessPoint").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)createAccessPointRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateAccessPointRequestMarshaller(this.protocolFactory)));
            return createAccessPointResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, createAccessPointRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateJobResponse createJob(CreateJobRequest createJobRequest) throws TooManyRequestsException, BadRequestException, IdempotencyException, InternalServiceException, AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateJobResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateJob");
            CreateJobResponse createJobResponse = (CreateJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateJob").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)createJobRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateJobRequestMarshaller(this.protocolFactory)));
            return createJobResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, createJobRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAccessPointResponse deleteAccessPoint(DeleteAccessPointRequest deleteAccessPointRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteAccessPointResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAccessPoint");
            DeleteAccessPointResponse deleteAccessPointResponse = (DeleteAccessPointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAccessPoint").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)deleteAccessPointRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAccessPointRequestMarshaller(this.protocolFactory)));
            return deleteAccessPointResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, deleteAccessPointRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAccessPointPolicyResponse deleteAccessPointPolicy(DeleteAccessPointPolicyRequest deleteAccessPointPolicyRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteAccessPointPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAccessPointPolicy");
            DeleteAccessPointPolicyResponse deleteAccessPointPolicyResponse = (DeleteAccessPointPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAccessPointPolicy").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)deleteAccessPointPolicyRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAccessPointPolicyRequestMarshaller(this.protocolFactory)));
            return deleteAccessPointPolicyResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, deleteAccessPointPolicyRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteJobTaggingResponse deleteJobTagging(DeleteJobTaggingRequest deleteJobTaggingRequest) throws InternalServiceException, TooManyRequestsException, NotFoundException, AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteJobTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteJobTagging");
            DeleteJobTaggingResponse deleteJobTaggingResponse = (DeleteJobTaggingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteJobTagging").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)deleteJobTaggingRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteJobTaggingRequestMarshaller(this.protocolFactory)));
            return deleteJobTaggingResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, deleteJobTaggingRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeletePublicAccessBlockResponse deletePublicAccessBlock(DeletePublicAccessBlockRequest deletePublicAccessBlockRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeletePublicAccessBlockResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePublicAccessBlock");
            DeletePublicAccessBlockResponse deletePublicAccessBlockResponse = (DeletePublicAccessBlockResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePublicAccessBlock").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)deletePublicAccessBlockRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeletePublicAccessBlockRequestMarshaller(this.protocolFactory)));
            return deletePublicAccessBlockResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, deletePublicAccessBlockRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeJobResponse describeJob(DescribeJobRequest describeJobRequest) throws BadRequestException, TooManyRequestsException, NotFoundException, InternalServiceException, AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DescribeJobResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeJob");
            DescribeJobResponse describeJobResponse = (DescribeJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeJob").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)describeJobRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeJobRequestMarshaller(this.protocolFactory)));
            return describeJobResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, describeJobRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAccessPointResponse getAccessPoint(GetAccessPointRequest getAccessPointRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetAccessPointResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAccessPoint");
            GetAccessPointResponse getAccessPointResponse = (GetAccessPointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAccessPoint").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)getAccessPointRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetAccessPointRequestMarshaller(this.protocolFactory)));
            return getAccessPointResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, getAccessPointRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAccessPointPolicyResponse getAccessPointPolicy(GetAccessPointPolicyRequest getAccessPointPolicyRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetAccessPointPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAccessPointPolicy");
            GetAccessPointPolicyResponse getAccessPointPolicyResponse = (GetAccessPointPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAccessPointPolicy").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)getAccessPointPolicyRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetAccessPointPolicyRequestMarshaller(this.protocolFactory)));
            return getAccessPointPolicyResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, getAccessPointPolicyRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAccessPointPolicyStatusResponse getAccessPointPolicyStatus(GetAccessPointPolicyStatusRequest getAccessPointPolicyStatusRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetAccessPointPolicyStatusResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAccessPointPolicyStatus");
            GetAccessPointPolicyStatusResponse getAccessPointPolicyStatusResponse = (GetAccessPointPolicyStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAccessPointPolicyStatus").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)getAccessPointPolicyStatusRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetAccessPointPolicyStatusRequestMarshaller(this.protocolFactory)));
            return getAccessPointPolicyStatusResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, getAccessPointPolicyStatusRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetJobTaggingResponse getJobTagging(GetJobTaggingRequest getJobTaggingRequest) throws InternalServiceException, TooManyRequestsException, NotFoundException, AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetJobTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetJobTagging");
            GetJobTaggingResponse getJobTaggingResponse = (GetJobTaggingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetJobTagging").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)getJobTaggingRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetJobTaggingRequestMarshaller(this.protocolFactory)));
            return getJobTaggingResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, getJobTaggingRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPublicAccessBlockResponse getPublicAccessBlock(GetPublicAccessBlockRequest getPublicAccessBlockRequest) throws NoSuchPublicAccessBlockConfigurationException, AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetPublicAccessBlockResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPublicAccessBlock");
            GetPublicAccessBlockResponse getPublicAccessBlockResponse = (GetPublicAccessBlockResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPublicAccessBlock").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)getPublicAccessBlockRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetPublicAccessBlockRequestMarshaller(this.protocolFactory)));
            return getPublicAccessBlockResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, getPublicAccessBlockRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAccessPointsResponse listAccessPoints(ListAccessPointsRequest listAccessPointsRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListAccessPointsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAccessPoints");
            ListAccessPointsResponse listAccessPointsResponse = (ListAccessPointsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAccessPoints").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)listAccessPointsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListAccessPointsRequestMarshaller(this.protocolFactory)));
            return listAccessPointsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, listAccessPointsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public ListAccessPointsIterable listAccessPointsPaginator(ListAccessPointsRequest listAccessPointsRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        return new ListAccessPointsIterable(this, this.applyPaginatorUserAgent(listAccessPointsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListJobsResponse listJobs(ListJobsRequest listJobsRequest) throws InvalidRequestException, InternalServiceException, InvalidNextTokenException, AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListJobsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListJobs");
            ListJobsResponse listJobsResponse = (ListJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListJobs").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)listJobsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListJobsRequestMarshaller(this.protocolFactory)));
            return listJobsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, listJobsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public ListJobsIterable listJobsPaginator(ListJobsRequest listJobsRequest) throws InvalidRequestException, InternalServiceException, InvalidNextTokenException, AwsServiceException, SdkClientException, S3ControlException {
        return new ListJobsIterable(this, this.applyPaginatorUserAgent(listJobsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutAccessPointPolicyResponse putAccessPointPolicy(PutAccessPointPolicyRequest putAccessPointPolicyRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutAccessPointPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutAccessPointPolicy");
            PutAccessPointPolicyResponse putAccessPointPolicyResponse = (PutAccessPointPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAccessPointPolicy").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)putAccessPointPolicyRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new PutAccessPointPolicyRequestMarshaller(this.protocolFactory)));
            return putAccessPointPolicyResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, putAccessPointPolicyRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutJobTaggingResponse putJobTagging(PutJobTaggingRequest putJobTaggingRequest) throws InternalServiceException, TooManyRequestsException, NotFoundException, TooManyTagsException, AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutJobTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutJobTagging");
            PutJobTaggingResponse putJobTaggingResponse = (PutJobTaggingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutJobTagging").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)putJobTaggingRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new PutJobTaggingRequestMarshaller(this.protocolFactory)));
            return putJobTaggingResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, putJobTaggingRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutPublicAccessBlockResponse putPublicAccessBlock(PutPublicAccessBlockRequest putPublicAccessBlockRequest) throws AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutPublicAccessBlockResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutPublicAccessBlock");
            PutPublicAccessBlockResponse putPublicAccessBlockResponse = (PutPublicAccessBlockResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutPublicAccessBlock").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)putPublicAccessBlockRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new PutPublicAccessBlockRequestMarshaller(this.protocolFactory)));
            return putPublicAccessBlockResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, putPublicAccessBlockRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateJobPriorityResponse updateJobPriority(UpdateJobPriorityRequest updateJobPriorityRequest) throws BadRequestException, TooManyRequestsException, NotFoundException, InternalServiceException, AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UpdateJobPriorityResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateJobPriority");
            UpdateJobPriorityResponse updateJobPriorityResponse = (UpdateJobPriorityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateJobPriority").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)updateJobPriorityRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateJobPriorityRequestMarshaller(this.protocolFactory)));
            return updateJobPriorityResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, updateJobPriorityRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateJobStatusResponse updateJobStatus(UpdateJobStatusRequest updateJobStatusRequest) throws BadRequestException, TooManyRequestsException, NotFoundException, JobStatusException, InternalServiceException, AwsServiceException, SdkClientException, S3ControlException {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UpdateJobStatusResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateJobStatus");
            UpdateJobStatusResponse updateJobStatusResponse = (UpdateJobStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateJobStatus").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)updateJobStatusRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateJobStatusRequestMarshaller(this.protocolFactory)));
            return updateJobStatusResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultS3ControlClient.resolveMetricPublishers(this.clientConfiguration, updateJobStatusRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private AwsXmlProtocolFactory init() {
        return AwsXmlProtocolFactory.builder().registerModeledException(ExceptionMetadata.builder().errorCode("TooManyTagsException").exceptionBuilderSupplier(TooManyTagsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("JobStatusException").exceptionBuilderSupplier(JobStatusException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NotFoundException").exceptionBuilderSupplier(NotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IdempotencyException").exceptionBuilderSupplier(IdempotencyException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchPublicAccessBlockConfiguration").exceptionBuilderSupplier(NoSuchPublicAccessBlockConfigurationException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServiceException").exceptionBuilderSupplier(InternalServiceException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyRequestsException").exceptionBuilderSupplier(TooManyRequestsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").exceptionBuilderSupplier(InvalidNextTokenException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BadRequestException").exceptionBuilderSupplier(BadRequestException::builder).build()).clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(S3ControlException::builder).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends S3ControlRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.13.60").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((S3ControlRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

