/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control;

import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.ServiceConfiguration;
import software.amazon.awssdk.profiles.ProfileFile;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
@Immutable
@ThreadSafe
public final class S3ControlConfiguration
implements ServiceConfiguration,
ToCopyableBuilder<Builder, S3ControlConfiguration> {
    private static final boolean DEFAULT_FIPS_MODE_ENABLED = false;
    private static final boolean DEFAULT_DUALSTACK_ENABLED = false;
    private final Boolean fipsModeEnabled;
    private final Boolean dualstackEnabled;
    private final ProfileFile profileFile;
    private final String profileName;

    private S3ControlConfiguration(DefaultS3ServiceConfigurationBuilder builder) {
        this.dualstackEnabled = builder.dualstackEnabled;
        this.fipsModeEnabled = builder.fipsModeEnabled;
        this.profileFile = builder.profileFile;
        this.profileName = builder.profileName;
    }

    public static Builder builder() {
        return new DefaultS3ServiceConfigurationBuilder();
    }

    public boolean fipsModeEnabled() {
        return this.resolveBoolean(this.fipsModeEnabled, false);
    }

    public boolean dualstackEnabled() {
        return this.resolveBoolean(this.dualstackEnabled, false);
    }

    private boolean resolveBoolean(Boolean suppliedValue, boolean defaultValue) {
        return suppliedValue == null ? defaultValue : suppliedValue;
    }

    public Builder toBuilder() {
        return S3ControlConfiguration.builder().dualstackEnabled(this.dualstackEnabled).fipsModeEnabled(this.fipsModeEnabled).profileFile(this.profileFile).profileName(this.profileName);
    }

    private static final class DefaultS3ServiceConfigurationBuilder
    implements Builder {
        private Boolean dualstackEnabled;
        private Boolean fipsModeEnabled;
        private ProfileFile profileFile;
        private String profileName;

        private DefaultS3ServiceConfigurationBuilder() {
        }

        @Override
        public Boolean dualstackEnabled() {
            return this.dualstackEnabled;
        }

        @Override
        public Builder dualstackEnabled(Boolean dualstackEnabled) {
            this.dualstackEnabled = dualstackEnabled;
            return this;
        }

        public void setDualstackEnabled(Boolean dualstackEnabled) {
            this.dualstackEnabled(dualstackEnabled);
        }

        @Override
        public Boolean fipsModeEnabled() {
            return this.fipsModeEnabled;
        }

        @Override
        public Builder fipsModeEnabled(Boolean fipsModeEnabled) {
            this.fipsModeEnabled = fipsModeEnabled;
            return this;
        }

        public void setFipsModeEnabled(Boolean fipsModeEnabled) {
            this.fipsModeEnabled(fipsModeEnabled);
        }

        @Override
        public ProfileFile profileFile() {
            return this.profileFile;
        }

        @Override
        public Builder profileFile(ProfileFile profileFile) {
            this.profileFile = profileFile;
            return this;
        }

        @Override
        public String profileName() {
            return this.profileName;
        }

        @Override
        public Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public S3ControlConfiguration build() {
            return new S3ControlConfiguration(this);
        }
    }

    @NotThreadSafe
    public static interface Builder
    extends CopyableBuilder<Builder, S3ControlConfiguration> {
        public Boolean dualstackEnabled();

        public Builder dualstackEnabled(Boolean var1);

        public Boolean fipsModeEnabled();

        public Builder fipsModeEnabled(Boolean var1);

        public ProfileFile profileFile();

        public Builder profileFile(ProfileFile var1);

        public String profileName();

        public Builder profileName(String var1);
    }
}

