/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3control.model.LambdaInvokeOperation;
import software.amazon.awssdk.services.s3control.model.S3CopyObjectOperation;
import software.amazon.awssdk.services.s3control.model.S3InitiateRestoreObjectOperation;
import software.amazon.awssdk.services.s3control.model.S3SetObjectAclOperation;
import software.amazon.awssdk.services.s3control.model.S3SetObjectTaggingOperation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobOperation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobOperation> {
    private static final SdkField<LambdaInvokeOperation> LAMBDA_INVOKE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(JobOperation.getter(JobOperation::lambdaInvoke)).setter(JobOperation.setter(Builder::lambdaInvoke)).constructor(LambdaInvokeOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaInvoke").unmarshallLocationName("LambdaInvoke").build()}).build();
    private static final SdkField<S3CopyObjectOperation> S3_PUT_OBJECT_COPY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(JobOperation.getter(JobOperation::s3PutObjectCopy)).setter(JobOperation.setter(Builder::s3PutObjectCopy)).constructor(S3CopyObjectOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3PutObjectCopy").unmarshallLocationName("S3PutObjectCopy").build()}).build();
    private static final SdkField<S3SetObjectAclOperation> S3_PUT_OBJECT_ACL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(JobOperation.getter(JobOperation::s3PutObjectAcl)).setter(JobOperation.setter(Builder::s3PutObjectAcl)).constructor(S3SetObjectAclOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3PutObjectAcl").unmarshallLocationName("S3PutObjectAcl").build()}).build();
    private static final SdkField<S3SetObjectTaggingOperation> S3_PUT_OBJECT_TAGGING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(JobOperation.getter(JobOperation::s3PutObjectTagging)).setter(JobOperation.setter(Builder::s3PutObjectTagging)).constructor(S3SetObjectTaggingOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3PutObjectTagging").unmarshallLocationName("S3PutObjectTagging").build()}).build();
    private static final SdkField<S3InitiateRestoreObjectOperation> S3_INITIATE_RESTORE_OBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(JobOperation.getter(JobOperation::s3InitiateRestoreObject)).setter(JobOperation.setter(Builder::s3InitiateRestoreObject)).constructor(S3InitiateRestoreObjectOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3InitiateRestoreObject").unmarshallLocationName("S3InitiateRestoreObject").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAMBDA_INVOKE_FIELD, S3_PUT_OBJECT_COPY_FIELD, S3_PUT_OBJECT_ACL_FIELD, S3_PUT_OBJECT_TAGGING_FIELD, S3_INITIATE_RESTORE_OBJECT_FIELD));
    private static final long serialVersionUID = 1L;
    private final LambdaInvokeOperation lambdaInvoke;
    private final S3CopyObjectOperation s3PutObjectCopy;
    private final S3SetObjectAclOperation s3PutObjectAcl;
    private final S3SetObjectTaggingOperation s3PutObjectTagging;
    private final S3InitiateRestoreObjectOperation s3InitiateRestoreObject;

    private JobOperation(BuilderImpl builder) {
        this.lambdaInvoke = builder.lambdaInvoke;
        this.s3PutObjectCopy = builder.s3PutObjectCopy;
        this.s3PutObjectAcl = builder.s3PutObjectAcl;
        this.s3PutObjectTagging = builder.s3PutObjectTagging;
        this.s3InitiateRestoreObject = builder.s3InitiateRestoreObject;
    }

    public LambdaInvokeOperation lambdaInvoke() {
        return this.lambdaInvoke;
    }

    public S3CopyObjectOperation s3PutObjectCopy() {
        return this.s3PutObjectCopy;
    }

    public S3SetObjectAclOperation s3PutObjectAcl() {
        return this.s3PutObjectAcl;
    }

    public S3SetObjectTaggingOperation s3PutObjectTagging() {
        return this.s3PutObjectTagging;
    }

    public S3InitiateRestoreObjectOperation s3InitiateRestoreObject() {
        return this.s3InitiateRestoreObject;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaInvoke());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3PutObjectCopy());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3PutObjectAcl());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3PutObjectTagging());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3InitiateRestoreObject());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobOperation)) {
            return false;
        }
        JobOperation other = (JobOperation)obj;
        return Objects.equals(this.lambdaInvoke(), other.lambdaInvoke()) && Objects.equals(this.s3PutObjectCopy(), other.s3PutObjectCopy()) && Objects.equals(this.s3PutObjectAcl(), other.s3PutObjectAcl()) && Objects.equals(this.s3PutObjectTagging(), other.s3PutObjectTagging()) && Objects.equals(this.s3InitiateRestoreObject(), other.s3InitiateRestoreObject());
    }

    public String toString() {
        return ToString.builder((String)"JobOperation").add("LambdaInvoke", (Object)this.lambdaInvoke()).add("S3PutObjectCopy", (Object)this.s3PutObjectCopy()).add("S3PutObjectAcl", (Object)this.s3PutObjectAcl()).add("S3PutObjectTagging", (Object)this.s3PutObjectTagging()).add("S3InitiateRestoreObject", (Object)this.s3InitiateRestoreObject()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LambdaInvoke": {
                return Optional.ofNullable(clazz.cast(this.lambdaInvoke()));
            }
            case "S3PutObjectCopy": {
                return Optional.ofNullable(clazz.cast(this.s3PutObjectCopy()));
            }
            case "S3PutObjectAcl": {
                return Optional.ofNullable(clazz.cast(this.s3PutObjectAcl()));
            }
            case "S3PutObjectTagging": {
                return Optional.ofNullable(clazz.cast(this.s3PutObjectTagging()));
            }
            case "S3InitiateRestoreObject": {
                return Optional.ofNullable(clazz.cast(this.s3InitiateRestoreObject()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobOperation, T> g) {
        return obj -> g.apply((JobOperation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private LambdaInvokeOperation lambdaInvoke;
        private S3CopyObjectOperation s3PutObjectCopy;
        private S3SetObjectAclOperation s3PutObjectAcl;
        private S3SetObjectTaggingOperation s3PutObjectTagging;
        private S3InitiateRestoreObjectOperation s3InitiateRestoreObject;

        private BuilderImpl() {
        }

        private BuilderImpl(JobOperation model) {
            this.lambdaInvoke(model.lambdaInvoke);
            this.s3PutObjectCopy(model.s3PutObjectCopy);
            this.s3PutObjectAcl(model.s3PutObjectAcl);
            this.s3PutObjectTagging(model.s3PutObjectTagging);
            this.s3InitiateRestoreObject(model.s3InitiateRestoreObject);
        }

        public final LambdaInvokeOperation.Builder getLambdaInvoke() {
            return this.lambdaInvoke != null ? this.lambdaInvoke.toBuilder() : null;
        }

        @Override
        public final Builder lambdaInvoke(LambdaInvokeOperation lambdaInvoke) {
            this.lambdaInvoke = lambdaInvoke;
            return this;
        }

        public final void setLambdaInvoke(LambdaInvokeOperation.BuilderImpl lambdaInvoke) {
            this.lambdaInvoke = lambdaInvoke != null ? lambdaInvoke.build() : null;
        }

        public final S3CopyObjectOperation.Builder getS3PutObjectCopy() {
            return this.s3PutObjectCopy != null ? this.s3PutObjectCopy.toBuilder() : null;
        }

        @Override
        public final Builder s3PutObjectCopy(S3CopyObjectOperation s3PutObjectCopy) {
            this.s3PutObjectCopy = s3PutObjectCopy;
            return this;
        }

        public final void setS3PutObjectCopy(S3CopyObjectOperation.BuilderImpl s3PutObjectCopy) {
            this.s3PutObjectCopy = s3PutObjectCopy != null ? s3PutObjectCopy.build() : null;
        }

        public final S3SetObjectAclOperation.Builder getS3PutObjectAcl() {
            return this.s3PutObjectAcl != null ? this.s3PutObjectAcl.toBuilder() : null;
        }

        @Override
        public final Builder s3PutObjectAcl(S3SetObjectAclOperation s3PutObjectAcl) {
            this.s3PutObjectAcl = s3PutObjectAcl;
            return this;
        }

        public final void setS3PutObjectAcl(S3SetObjectAclOperation.BuilderImpl s3PutObjectAcl) {
            this.s3PutObjectAcl = s3PutObjectAcl != null ? s3PutObjectAcl.build() : null;
        }

        public final S3SetObjectTaggingOperation.Builder getS3PutObjectTagging() {
            return this.s3PutObjectTagging != null ? this.s3PutObjectTagging.toBuilder() : null;
        }

        @Override
        public final Builder s3PutObjectTagging(S3SetObjectTaggingOperation s3PutObjectTagging) {
            this.s3PutObjectTagging = s3PutObjectTagging;
            return this;
        }

        public final void setS3PutObjectTagging(S3SetObjectTaggingOperation.BuilderImpl s3PutObjectTagging) {
            this.s3PutObjectTagging = s3PutObjectTagging != null ? s3PutObjectTagging.build() : null;
        }

        public final S3InitiateRestoreObjectOperation.Builder getS3InitiateRestoreObject() {
            return this.s3InitiateRestoreObject != null ? this.s3InitiateRestoreObject.toBuilder() : null;
        }

        @Override
        public final Builder s3InitiateRestoreObject(S3InitiateRestoreObjectOperation s3InitiateRestoreObject) {
            this.s3InitiateRestoreObject = s3InitiateRestoreObject;
            return this;
        }

        public final void setS3InitiateRestoreObject(S3InitiateRestoreObjectOperation.BuilderImpl s3InitiateRestoreObject) {
            this.s3InitiateRestoreObject = s3InitiateRestoreObject != null ? s3InitiateRestoreObject.build() : null;
        }

        public JobOperation build() {
            return new JobOperation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobOperation> {
        public Builder lambdaInvoke(LambdaInvokeOperation var1);

        default public Builder lambdaInvoke(Consumer<LambdaInvokeOperation.Builder> lambdaInvoke) {
            return this.lambdaInvoke((LambdaInvokeOperation)((LambdaInvokeOperation.Builder)LambdaInvokeOperation.builder().applyMutation(lambdaInvoke)).build());
        }

        public Builder s3PutObjectCopy(S3CopyObjectOperation var1);

        default public Builder s3PutObjectCopy(Consumer<S3CopyObjectOperation.Builder> s3PutObjectCopy) {
            return this.s3PutObjectCopy((S3CopyObjectOperation)((S3CopyObjectOperation.Builder)S3CopyObjectOperation.builder().applyMutation(s3PutObjectCopy)).build());
        }

        public Builder s3PutObjectAcl(S3SetObjectAclOperation var1);

        default public Builder s3PutObjectAcl(Consumer<S3SetObjectAclOperation.Builder> s3PutObjectAcl) {
            return this.s3PutObjectAcl((S3SetObjectAclOperation)((S3SetObjectAclOperation.Builder)S3SetObjectAclOperation.builder().applyMutation(s3PutObjectAcl)).build());
        }

        public Builder s3PutObjectTagging(S3SetObjectTaggingOperation var1);

        default public Builder s3PutObjectTagging(Consumer<S3SetObjectTaggingOperation.Builder> s3PutObjectTagging) {
            return this.s3PutObjectTagging((S3SetObjectTaggingOperation)((S3SetObjectTaggingOperation.Builder)S3SetObjectTaggingOperation.builder().applyMutation(s3PutObjectTagging)).build());
        }

        public Builder s3InitiateRestoreObject(S3InitiateRestoreObjectOperation var1);

        default public Builder s3InitiateRestoreObject(Consumer<S3InitiateRestoreObjectOperation.Builder> s3InitiateRestoreObject) {
            return this.s3InitiateRestoreObject((S3InitiateRestoreObjectOperation)((S3InitiateRestoreObjectOperation.Builder)S3InitiateRestoreObjectOperation.builder().applyMutation(s3InitiateRestoreObject)).build());
        }
    }
}

