/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.s3express;

import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.identity.SdkIdentityProperty;
import software.amazon.awssdk.identity.spi.AwsCredentialsIdentity;
import software.amazon.awssdk.identity.spi.IdentityProvider;
import software.amazon.awssdk.identity.spi.ResolveIdentityRequest;
import software.amazon.awssdk.services.s3.internal.s3express.S3ExpressAuthSchemeProvider;
import software.amazon.awssdk.services.s3.internal.s3express.S3ExpressIdentityCache;
import software.amazon.awssdk.services.s3.internal.s3express.S3ExpressIdentityKey;
import software.amazon.awssdk.services.s3.s3express.S3ExpressSessionCredentials;

@SdkInternalApi
public final class DefaultS3ExpressIdentityProvider
implements IdentityProvider<S3ExpressSessionCredentials> {
    private final S3ExpressIdentityCache identityCache;
    private final IdentityProvider<AwsCredentialsIdentity> baseIdentityProvider;

    public DefaultS3ExpressIdentityProvider(S3ExpressIdentityCache identityCache, IdentityProvider<AwsCredentialsIdentity> baseIdentityProvider) {
        this.identityCache = identityCache;
        this.baseIdentityProvider = baseIdentityProvider;
    }

    public Class<S3ExpressSessionCredentials> identityType() {
        return S3ExpressSessionCredentials.class;
    }

    public CompletableFuture<S3ExpressSessionCredentials> resolveIdentity(ResolveIdentityRequest request) {
        String bucket = (String)request.property(S3ExpressAuthSchemeProvider.BUCKET);
        SdkClient client = (SdkClient)request.property(SdkIdentityProperty.SDK_CLIENT);
        return this.baseIdentityProvider.resolveIdentity(request).thenApply(identity -> {
            S3ExpressIdentityKey key = S3ExpressIdentityKey.builder().bucket(bucket).client(client).identity((AwsCredentialsIdentity)identity).build();
            return this.identityCache.get(key);
        });
    }
}

