/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The destination information for the S3 Metadata configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DestinationResult implements SdkPojo, Serializable,
        ToCopyableBuilder<DestinationResult.Builder, DestinationResult> {
    private static final SdkField<String> TABLE_BUCKET_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TableBucketType")
            .getter(getter(DestinationResult::tableBucketTypeAsString))
            .setter(setter(Builder::tableBucketType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableBucketType")
                    .unmarshallLocationName("TableBucketType").build()).build();

    private static final SdkField<String> TABLE_BUCKET_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TableBucketArn")
            .getter(getter(DestinationResult::tableBucketArn))
            .setter(setter(Builder::tableBucketArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableBucketArn")
                    .unmarshallLocationName("TableBucketArn").build()).build();

    private static final SdkField<String> TABLE_NAMESPACE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TableNamespace")
            .getter(getter(DestinationResult::tableNamespace))
            .setter(setter(Builder::tableNamespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableNamespace")
                    .unmarshallLocationName("TableNamespace").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_BUCKET_TYPE_FIELD,
            TABLE_BUCKET_ARN_FIELD, TABLE_NAMESPACE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String tableBucketType;

    private final String tableBucketArn;

    private final String tableNamespace;

    private DestinationResult(BuilderImpl builder) {
        this.tableBucketType = builder.tableBucketType;
        this.tableBucketArn = builder.tableBucketArn;
        this.tableNamespace = builder.tableNamespace;
    }

    /**
     * <p>
     * The type of the table bucket where the metadata configuration is stored. The <code>aws</code> value indicates an
     * Amazon Web Services managed table bucket, and the <code>customer</code> value indicates a customer-managed table
     * bucket. V2 metadata configurations are stored in Amazon Web Services managed table buckets, and V1 metadata
     * configurations are stored in customer-managed table buckets.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tableBucketType}
     * will return {@link S3TablesBucketType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #tableBucketTypeAsString}.
     * </p>
     * 
     * @return The type of the table bucket where the metadata configuration is stored. The <code>aws</code> value
     *         indicates an Amazon Web Services managed table bucket, and the <code>customer</code> value indicates a
     *         customer-managed table bucket. V2 metadata configurations are stored in Amazon Web Services managed table
     *         buckets, and V1 metadata configurations are stored in customer-managed table buckets.
     * @see S3TablesBucketType
     */
    public final S3TablesBucketType tableBucketType() {
        return S3TablesBucketType.fromValue(tableBucketType);
    }

    /**
     * <p>
     * The type of the table bucket where the metadata configuration is stored. The <code>aws</code> value indicates an
     * Amazon Web Services managed table bucket, and the <code>customer</code> value indicates a customer-managed table
     * bucket. V2 metadata configurations are stored in Amazon Web Services managed table buckets, and V1 metadata
     * configurations are stored in customer-managed table buckets.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tableBucketType}
     * will return {@link S3TablesBucketType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #tableBucketTypeAsString}.
     * </p>
     * 
     * @return The type of the table bucket where the metadata configuration is stored. The <code>aws</code> value
     *         indicates an Amazon Web Services managed table bucket, and the <code>customer</code> value indicates a
     *         customer-managed table bucket. V2 metadata configurations are stored in Amazon Web Services managed table
     *         buckets, and V1 metadata configurations are stored in customer-managed table buckets.
     * @see S3TablesBucketType
     */
    public final String tableBucketTypeAsString() {
        return tableBucketType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the table bucket where the metadata configuration is stored.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the table bucket where the metadata configuration is stored.
     */
    public final String tableBucketArn() {
        return tableBucketArn;
    }

    /**
     * <p>
     * The namespace in the table bucket where the metadata tables for a metadata configuration are stored.
     * </p>
     * 
     * @return The namespace in the table bucket where the metadata tables for a metadata configuration are stored.
     */
    public final String tableNamespace() {
        return tableNamespace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tableBucketTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(tableBucketArn());
        hashCode = 31 * hashCode + Objects.hashCode(tableNamespace());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DestinationResult)) {
            return false;
        }
        DestinationResult other = (DestinationResult) obj;
        return Objects.equals(tableBucketTypeAsString(), other.tableBucketTypeAsString())
                && Objects.equals(tableBucketArn(), other.tableBucketArn())
                && Objects.equals(tableNamespace(), other.tableNamespace());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DestinationResult").add("TableBucketType", tableBucketTypeAsString())
                .add("TableBucketArn", tableBucketArn()).add("TableNamespace", tableNamespace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TableBucketType":
            return Optional.ofNullable(clazz.cast(tableBucketTypeAsString()));
        case "TableBucketArn":
            return Optional.ofNullable(clazz.cast(tableBucketArn()));
        case "TableNamespace":
            return Optional.ofNullable(clazz.cast(tableNamespace()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TableBucketType", TABLE_BUCKET_TYPE_FIELD);
        map.put("TableBucketArn", TABLE_BUCKET_ARN_FIELD);
        map.put("TableNamespace", TABLE_NAMESPACE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DestinationResult, T> g) {
        return obj -> g.apply((DestinationResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DestinationResult> {
        /**
         * <p>
         * The type of the table bucket where the metadata configuration is stored. The <code>aws</code> value indicates
         * an Amazon Web Services managed table bucket, and the <code>customer</code> value indicates a customer-managed
         * table bucket. V2 metadata configurations are stored in Amazon Web Services managed table buckets, and V1
         * metadata configurations are stored in customer-managed table buckets.
         * </p>
         * 
         * @param tableBucketType
         *        The type of the table bucket where the metadata configuration is stored. The <code>aws</code> value
         *        indicates an Amazon Web Services managed table bucket, and the <code>customer</code> value indicates a
         *        customer-managed table bucket. V2 metadata configurations are stored in Amazon Web Services managed
         *        table buckets, and V1 metadata configurations are stored in customer-managed table buckets.
         * @see S3TablesBucketType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3TablesBucketType
         */
        Builder tableBucketType(String tableBucketType);

        /**
         * <p>
         * The type of the table bucket where the metadata configuration is stored. The <code>aws</code> value indicates
         * an Amazon Web Services managed table bucket, and the <code>customer</code> value indicates a customer-managed
         * table bucket. V2 metadata configurations are stored in Amazon Web Services managed table buckets, and V1
         * metadata configurations are stored in customer-managed table buckets.
         * </p>
         * 
         * @param tableBucketType
         *        The type of the table bucket where the metadata configuration is stored. The <code>aws</code> value
         *        indicates an Amazon Web Services managed table bucket, and the <code>customer</code> value indicates a
         *        customer-managed table bucket. V2 metadata configurations are stored in Amazon Web Services managed
         *        table buckets, and V1 metadata configurations are stored in customer-managed table buckets.
         * @see S3TablesBucketType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3TablesBucketType
         */
        Builder tableBucketType(S3TablesBucketType tableBucketType);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the table bucket where the metadata configuration is stored.
         * </p>
         * 
         * @param tableBucketArn
         *        The Amazon Resource Name (ARN) of the table bucket where the metadata configuration is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableBucketArn(String tableBucketArn);

        /**
         * <p>
         * The namespace in the table bucket where the metadata tables for a metadata configuration are stored.
         * </p>
         * 
         * @param tableNamespace
         *        The namespace in the table bucket where the metadata tables for a metadata configuration are stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableNamespace(String tableNamespace);
    }

    static final class BuilderImpl implements Builder {
        private String tableBucketType;

        private String tableBucketArn;

        private String tableNamespace;

        private BuilderImpl() {
        }

        private BuilderImpl(DestinationResult model) {
            tableBucketType(model.tableBucketType);
            tableBucketArn(model.tableBucketArn);
            tableNamespace(model.tableNamespace);
        }

        public final String getTableBucketType() {
            return tableBucketType;
        }

        public final void setTableBucketType(String tableBucketType) {
            this.tableBucketType = tableBucketType;
        }

        @Override
        public final Builder tableBucketType(String tableBucketType) {
            this.tableBucketType = tableBucketType;
            return this;
        }

        @Override
        public final Builder tableBucketType(S3TablesBucketType tableBucketType) {
            this.tableBucketType(tableBucketType == null ? null : tableBucketType.toString());
            return this;
        }

        public final String getTableBucketArn() {
            return tableBucketArn;
        }

        public final void setTableBucketArn(String tableBucketArn) {
            this.tableBucketArn = tableBucketArn;
        }

        @Override
        public final Builder tableBucketArn(String tableBucketArn) {
            this.tableBucketArn = tableBucketArn;
            return this;
        }

        public final String getTableNamespace() {
            return tableNamespace;
        }

        public final void setTableNamespace(String tableNamespace) {
            this.tableNamespace = tableNamespace;
        }

        @Override
        public final Builder tableNamespace(String tableNamespace) {
            this.tableNamespace = tableNamespace;
            return this;
        }

        @Override
        public DestinationResult build() {
            return new DestinationResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
