/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.RequiredTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The S3 Metadata configuration for a general purpose bucket.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetadataConfigurationResult implements SdkPojo, Serializable,
        ToCopyableBuilder<MetadataConfigurationResult.Builder, MetadataConfigurationResult> {
    private static final SdkField<DestinationResult> DESTINATION_RESULT_FIELD = SdkField
            .<DestinationResult> builder(MarshallingType.SDK_POJO)
            .memberName("DestinationResult")
            .getter(getter(MetadataConfigurationResult::destinationResult))
            .setter(setter(Builder::destinationResult))
            .constructor(DestinationResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationResult")
                    .unmarshallLocationName("DestinationResult").build(), RequiredTrait.create()).build();

    private static final SdkField<JournalTableConfigurationResult> JOURNAL_TABLE_CONFIGURATION_RESULT_FIELD = SdkField
            .<JournalTableConfigurationResult> builder(MarshallingType.SDK_POJO)
            .memberName("JournalTableConfigurationResult")
            .getter(getter(MetadataConfigurationResult::journalTableConfigurationResult))
            .setter(setter(Builder::journalTableConfigurationResult))
            .constructor(JournalTableConfigurationResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JournalTableConfigurationResult")
                    .unmarshallLocationName("JournalTableConfigurationResult").build()).build();

    private static final SdkField<InventoryTableConfigurationResult> INVENTORY_TABLE_CONFIGURATION_RESULT_FIELD = SdkField
            .<InventoryTableConfigurationResult> builder(MarshallingType.SDK_POJO)
            .memberName("InventoryTableConfigurationResult")
            .getter(getter(MetadataConfigurationResult::inventoryTableConfigurationResult))
            .setter(setter(Builder::inventoryTableConfigurationResult))
            .constructor(InventoryTableConfigurationResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InventoryTableConfigurationResult")
                    .unmarshallLocationName("InventoryTableConfigurationResult").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_RESULT_FIELD,
            JOURNAL_TABLE_CONFIGURATION_RESULT_FIELD, INVENTORY_TABLE_CONFIGURATION_RESULT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DestinationResult destinationResult;

    private final JournalTableConfigurationResult journalTableConfigurationResult;

    private final InventoryTableConfigurationResult inventoryTableConfigurationResult;

    private MetadataConfigurationResult(BuilderImpl builder) {
        this.destinationResult = builder.destinationResult;
        this.journalTableConfigurationResult = builder.journalTableConfigurationResult;
        this.inventoryTableConfigurationResult = builder.inventoryTableConfigurationResult;
    }

    /**
     * <p>
     * The destination settings for a metadata configuration.
     * </p>
     * 
     * @return The destination settings for a metadata configuration.
     */
    public final DestinationResult destinationResult() {
        return destinationResult;
    }

    /**
     * <p>
     * The journal table configuration for a metadata configuration.
     * </p>
     * 
     * @return The journal table configuration for a metadata configuration.
     */
    public final JournalTableConfigurationResult journalTableConfigurationResult() {
        return journalTableConfigurationResult;
    }

    /**
     * <p>
     * The inventory table configuration for a metadata configuration.
     * </p>
     * 
     * @return The inventory table configuration for a metadata configuration.
     */
    public final InventoryTableConfigurationResult inventoryTableConfigurationResult() {
        return inventoryTableConfigurationResult;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destinationResult());
        hashCode = 31 * hashCode + Objects.hashCode(journalTableConfigurationResult());
        hashCode = 31 * hashCode + Objects.hashCode(inventoryTableConfigurationResult());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetadataConfigurationResult)) {
            return false;
        }
        MetadataConfigurationResult other = (MetadataConfigurationResult) obj;
        return Objects.equals(destinationResult(), other.destinationResult())
                && Objects.equals(journalTableConfigurationResult(), other.journalTableConfigurationResult())
                && Objects.equals(inventoryTableConfigurationResult(), other.inventoryTableConfigurationResult());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetadataConfigurationResult").add("DestinationResult", destinationResult())
                .add("JournalTableConfigurationResult", journalTableConfigurationResult())
                .add("InventoryTableConfigurationResult", inventoryTableConfigurationResult()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationResult":
            return Optional.ofNullable(clazz.cast(destinationResult()));
        case "JournalTableConfigurationResult":
            return Optional.ofNullable(clazz.cast(journalTableConfigurationResult()));
        case "InventoryTableConfigurationResult":
            return Optional.ofNullable(clazz.cast(inventoryTableConfigurationResult()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DestinationResult", DESTINATION_RESULT_FIELD);
        map.put("JournalTableConfigurationResult", JOURNAL_TABLE_CONFIGURATION_RESULT_FIELD);
        map.put("InventoryTableConfigurationResult", INVENTORY_TABLE_CONFIGURATION_RESULT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetadataConfigurationResult, T> g) {
        return obj -> g.apply((MetadataConfigurationResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetadataConfigurationResult> {
        /**
         * <p>
         * The destination settings for a metadata configuration.
         * </p>
         * 
         * @param destinationResult
         *        The destination settings for a metadata configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationResult(DestinationResult destinationResult);

        /**
         * <p>
         * The destination settings for a metadata configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link DestinationResult.Builder} avoiding the
         * need to create one manually via {@link DestinationResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DestinationResult.Builder#build()} is called immediately and its
         * result is passed to {@link #destinationResult(DestinationResult)}.
         * 
         * @param destinationResult
         *        a consumer that will call methods on {@link DestinationResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationResult(DestinationResult)
         */
        default Builder destinationResult(Consumer<DestinationResult.Builder> destinationResult) {
            return destinationResult(DestinationResult.builder().applyMutation(destinationResult).build());
        }

        /**
         * <p>
         * The journal table configuration for a metadata configuration.
         * </p>
         * 
         * @param journalTableConfigurationResult
         *        The journal table configuration for a metadata configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder journalTableConfigurationResult(JournalTableConfigurationResult journalTableConfigurationResult);

        /**
         * <p>
         * The journal table configuration for a metadata configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link JournalTableConfigurationResult.Builder}
         * avoiding the need to create one manually via {@link JournalTableConfigurationResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JournalTableConfigurationResult.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #journalTableConfigurationResult(JournalTableConfigurationResult)}.
         * 
         * @param journalTableConfigurationResult
         *        a consumer that will call methods on {@link JournalTableConfigurationResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #journalTableConfigurationResult(JournalTableConfigurationResult)
         */
        default Builder journalTableConfigurationResult(
                Consumer<JournalTableConfigurationResult.Builder> journalTableConfigurationResult) {
            return journalTableConfigurationResult(JournalTableConfigurationResult.builder()
                    .applyMutation(journalTableConfigurationResult).build());
        }

        /**
         * <p>
         * The inventory table configuration for a metadata configuration.
         * </p>
         * 
         * @param inventoryTableConfigurationResult
         *        The inventory table configuration for a metadata configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inventoryTableConfigurationResult(InventoryTableConfigurationResult inventoryTableConfigurationResult);

        /**
         * <p>
         * The inventory table configuration for a metadata configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link InventoryTableConfigurationResult.Builder} avoiding the need to create one manually via
         * {@link InventoryTableConfigurationResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InventoryTableConfigurationResult.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #inventoryTableConfigurationResult(InventoryTableConfigurationResult)}.
         * 
         * @param inventoryTableConfigurationResult
         *        a consumer that will call methods on {@link InventoryTableConfigurationResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inventoryTableConfigurationResult(InventoryTableConfigurationResult)
         */
        default Builder inventoryTableConfigurationResult(
                Consumer<InventoryTableConfigurationResult.Builder> inventoryTableConfigurationResult) {
            return inventoryTableConfigurationResult(InventoryTableConfigurationResult.builder()
                    .applyMutation(inventoryTableConfigurationResult).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DestinationResult destinationResult;

        private JournalTableConfigurationResult journalTableConfigurationResult;

        private InventoryTableConfigurationResult inventoryTableConfigurationResult;

        private BuilderImpl() {
        }

        private BuilderImpl(MetadataConfigurationResult model) {
            destinationResult(model.destinationResult);
            journalTableConfigurationResult(model.journalTableConfigurationResult);
            inventoryTableConfigurationResult(model.inventoryTableConfigurationResult);
        }

        public final DestinationResult.Builder getDestinationResult() {
            return destinationResult != null ? destinationResult.toBuilder() : null;
        }

        public final void setDestinationResult(DestinationResult.BuilderImpl destinationResult) {
            this.destinationResult = destinationResult != null ? destinationResult.build() : null;
        }

        @Override
        public final Builder destinationResult(DestinationResult destinationResult) {
            this.destinationResult = destinationResult;
            return this;
        }

        public final JournalTableConfigurationResult.Builder getJournalTableConfigurationResult() {
            return journalTableConfigurationResult != null ? journalTableConfigurationResult.toBuilder() : null;
        }

        public final void setJournalTableConfigurationResult(
                JournalTableConfigurationResult.BuilderImpl journalTableConfigurationResult) {
            this.journalTableConfigurationResult = journalTableConfigurationResult != null ? journalTableConfigurationResult
                    .build() : null;
        }

        @Override
        public final Builder journalTableConfigurationResult(JournalTableConfigurationResult journalTableConfigurationResult) {
            this.journalTableConfigurationResult = journalTableConfigurationResult;
            return this;
        }

        public final InventoryTableConfigurationResult.Builder getInventoryTableConfigurationResult() {
            return inventoryTableConfigurationResult != null ? inventoryTableConfigurationResult.toBuilder() : null;
        }

        public final void setInventoryTableConfigurationResult(
                InventoryTableConfigurationResult.BuilderImpl inventoryTableConfigurationResult) {
            this.inventoryTableConfigurationResult = inventoryTableConfigurationResult != null ? inventoryTableConfigurationResult
                    .build() : null;
        }

        @Override
        public final Builder inventoryTableConfigurationResult(InventoryTableConfigurationResult inventoryTableConfigurationResult) {
            this.inventoryTableConfigurationResult = inventoryTableConfigurationResult;
            return this;
        }

        @Override
        public MetadataConfigurationResult build() {
            return new MetadataConfigurationResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
