/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBucketsRequest extends S3Request implements
        ToCopyableBuilder<ListBucketsRequest.Builder, ListBucketsRequest> {
    private static final SdkField<Integer> MAX_BUCKETS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxBuckets")
            .getter(getter(ListBucketsRequest::maxBuckets))
            .setter(setter(Builder::maxBuckets))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("max-buckets")
                    .unmarshallLocationName("max-buckets").build()).build();

    private static final SdkField<String> CONTINUATION_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ContinuationToken")
            .getter(getter(ListBucketsRequest::continuationToken))
            .setter(setter(Builder::continuationToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("continuation-token")
                    .unmarshallLocationName("continuation-token").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_BUCKETS_FIELD,
            CONTINUATION_TOKEN_FIELD));

    private final Integer maxBuckets;

    private final String continuationToken;

    private ListBucketsRequest(BuilderImpl builder) {
        super(builder);
        this.maxBuckets = builder.maxBuckets;
        this.continuationToken = builder.continuationToken;
    }

    /**
     * <p>
     * Maximum number of buckets to be returned in response. When the number is more than the count of buckets that are
     * owned by an Amazon Web Services account, return all the buckets in response.
     * </p>
     * 
     * @return Maximum number of buckets to be returned in response. When the number is more than the count of buckets
     *         that are owned by an Amazon Web Services account, return all the buckets in response.
     */
    public final Integer maxBuckets() {
        return maxBuckets;
    }

    /**
     * <p>
     * <code>ContinuationToken</code> indicates to Amazon S3 that the list is being continued on this bucket with a
     * token. <code>ContinuationToken</code> is obfuscated and is not a real key. You can use this
     * <code>ContinuationToken</code> for pagination of the list results.
     * </p>
     * <p>
     * Length Constraints: Minimum length of 0. Maximum length of 1024.
     * </p>
     * <p>
     * Required: No.
     * </p>
     * 
     * @return <code>ContinuationToken</code> indicates to Amazon S3 that the list is being continued on this bucket
     *         with a token. <code>ContinuationToken</code> is obfuscated and is not a real key. You can use this
     *         <code>ContinuationToken</code> for pagination of the list results. </p>
     *         <p>
     *         Length Constraints: Minimum length of 0. Maximum length of 1024.
     *         </p>
     *         <p>
     *         Required: No.
     */
    public final String continuationToken() {
        return continuationToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxBuckets());
        hashCode = 31 * hashCode + Objects.hashCode(continuationToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBucketsRequest)) {
            return false;
        }
        ListBucketsRequest other = (ListBucketsRequest) obj;
        return Objects.equals(maxBuckets(), other.maxBuckets()) && Objects.equals(continuationToken(), other.continuationToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBucketsRequest").add("MaxBuckets", maxBuckets())
                .add("ContinuationToken", continuationToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxBuckets":
            return Optional.ofNullable(clazz.cast(maxBuckets()));
        case "ContinuationToken":
            return Optional.ofNullable(clazz.cast(continuationToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBucketsRequest, T> g) {
        return obj -> g.apply((ListBucketsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3Request.Builder, SdkPojo, CopyableBuilder<Builder, ListBucketsRequest> {
        /**
         * <p>
         * Maximum number of buckets to be returned in response. When the number is more than the count of buckets that
         * are owned by an Amazon Web Services account, return all the buckets in response.
         * </p>
         * 
         * @param maxBuckets
         *        Maximum number of buckets to be returned in response. When the number is more than the count of
         *        buckets that are owned by an Amazon Web Services account, return all the buckets in response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxBuckets(Integer maxBuckets);

        /**
         * <p>
         * <code>ContinuationToken</code> indicates to Amazon S3 that the list is being continued on this bucket with a
         * token. <code>ContinuationToken</code> is obfuscated and is not a real key. You can use this
         * <code>ContinuationToken</code> for pagination of the list results.
         * </p>
         * <p>
         * Length Constraints: Minimum length of 0. Maximum length of 1024.
         * </p>
         * <p>
         * Required: No.
         * </p>
         * 
         * @param continuationToken
         *        <code>ContinuationToken</code> indicates to Amazon S3 that the list is being continued on this bucket
         *        with a token. <code>ContinuationToken</code> is obfuscated and is not a real key. You can use this
         *        <code>ContinuationToken</code> for pagination of the list results. </p>
         *        <p>
         *        Length Constraints: Minimum length of 0. Maximum length of 1024.
         *        </p>
         *        <p>
         *        Required: No.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continuationToken(String continuationToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends S3Request.BuilderImpl implements Builder {
        private Integer maxBuckets;

        private String continuationToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBucketsRequest model) {
            super(model);
            maxBuckets(model.maxBuckets);
            continuationToken(model.continuationToken);
        }

        public final Integer getMaxBuckets() {
            return maxBuckets;
        }

        public final void setMaxBuckets(Integer maxBuckets) {
            this.maxBuckets = maxBuckets;
        }

        @Override
        public final Builder maxBuckets(Integer maxBuckets) {
            this.maxBuckets = maxBuckets;
            return this;
        }

        public final String getContinuationToken() {
            return continuationToken;
        }

        public final void setContinuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
        }

        @Override
        public final Builder continuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListBucketsRequest build() {
            return new ListBucketsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
