/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.checksums;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.signer.AwsSignerExecutionAttribute;
import software.amazon.awssdk.core.ClientType;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.services.s3.S3Configuration;
import software.amazon.awssdk.services.s3.model.ServerSideEncryption;

@SdkInternalApi
public final class ChecksumsEnabledValidator {
    private ChecksumsEnabledValidator() {
    }

    public static boolean trailingChecksumsEnabled(ClientType expectedClientType, ExecutionAttributes executionAttributes, Map<String, List<String>> headers) {
        if (headers.containsKey("x-amz-server-side-encryption-customer-algorithm")) {
            return false;
        }
        if (headers.getOrDefault("x-amz-server-side-encryption", Collections.emptyList()).contains(ServerSideEncryption.AWS_KMS.toString())) {
            return false;
        }
        ClientType actualClientType = (ClientType)executionAttributes.getAttribute(SdkExecutionAttribute.CLIENT_TYPE);
        if (expectedClientType.equals((Object)actualClientType)) {
            S3Configuration serviceConfiguration = (S3Configuration)executionAttributes.getAttribute(AwsSignerExecutionAttribute.SERVICE_CONFIG);
            return serviceConfiguration == null || serviceConfiguration.checksumValidationEnabled();
        }
        return false;
    }
}

