/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.crt;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.awscore.AwsRequest;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.awssdk.core.signer.NoOpSigner;
import software.amazon.awssdk.http.SdkHttpExecutionAttributes;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClientBuilder;
import software.amazon.awssdk.services.s3.S3Configuration;
import software.amazon.awssdk.services.s3.internal.DelegatingS3AsyncClient;
import software.amazon.awssdk.services.s3.internal.crt.S3CrtAsyncClient;
import software.amazon.awssdk.services.s3.internal.crt.S3CrtAsyncHttpClient;
import software.amazon.awssdk.services.s3.internal.crt.S3InternalSdkHttpExecutionAttribute;

@SdkInternalApi
public final class DefaultS3CrtAsyncClient
extends DelegatingS3AsyncClient
implements S3CrtAsyncClient {
    private DefaultS3CrtAsyncClient(DefaultS3CrtClientBuilder builder) {
        super(DefaultS3CrtAsyncClient.initializeS3AsyncClient(builder));
    }

    private static S3AsyncClient initializeS3AsyncClient(DefaultS3CrtClientBuilder builder) {
        return (S3AsyncClient)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)S3AsyncClient.builder().serviceConfiguration((S3Configuration)S3Configuration.builder().checksumValidationEnabled(false).build())).region(builder.region)).endpointOverride(builder.endpointOverride)).credentialsProvider(builder.credentialsProvider)).overrideConfiguration(o -> o.putAdvancedOption(SdkAdvancedClientOption.SIGNER, (Object)new NoOpSigner()).retryPolicy(RetryPolicy.none()).addExecutionInterceptor((ExecutionInterceptor)new ValidateRequestInterceptor()).addExecutionInterceptor((ExecutionInterceptor)new AttachHttpAttributesExecutionInterceptor()))).httpClientBuilder(DefaultS3CrtAsyncClient.initializeS3CrtAsyncHttpClient(builder))).build();
    }

    private static S3CrtAsyncHttpClient.Builder initializeS3CrtAsyncHttpClient(DefaultS3CrtClientBuilder builder) {
        return S3CrtAsyncHttpClient.builder().targetThroughputInGbps(builder.targetThroughputInGbps()).minimumPartSizeInBytes(builder.minimumPartSizeInBytes()).maxConcurrency(builder.maxConcurrency).region(builder.region).endpointOverride(builder.endpointOverride).credentialsProvider(builder.credentialsProvider);
    }

    public String serviceName() {
        return "s3";
    }

    private static final class ValidateRequestInterceptor
    implements ExecutionInterceptor {
        private ValidateRequestInterceptor() {
        }

        public void beforeExecution(Context.BeforeExecution context, ExecutionAttributes executionAttributes) {
            ValidateRequestInterceptor.validateOverrideConfiguration(context.request());
        }

        private static void validateOverrideConfiguration(SdkRequest request) {
            if (!(request instanceof AwsRequest)) {
                return;
            }
            if (request.overrideConfiguration().isPresent()) {
                AwsRequestOverrideConfiguration overrideConfiguration = (AwsRequestOverrideConfiguration)request.overrideConfiguration().get();
                if (overrideConfiguration.signer().isPresent()) {
                    throw new UnsupportedOperationException("Request-level signer override is not supported");
                }
                if (overrideConfiguration.credentialsProvider().isPresent()) {
                    throw new UnsupportedOperationException("Request-level credentials override is not supported");
                }
            }
        }
    }

    private static final class AttachHttpAttributesExecutionInterceptor
    implements ExecutionInterceptor {
        private AttachHttpAttributesExecutionInterceptor() {
        }

        public void afterMarshalling(Context.AfterMarshalling context, ExecutionAttributes executionAttributes) {
            SdkHttpExecutionAttributes attributes = SdkHttpExecutionAttributes.builder().put(S3InternalSdkHttpExecutionAttribute.OPERATION_NAME, executionAttributes.getAttribute(SdkExecutionAttribute.OPERATION_NAME)).build();
            executionAttributes.putAttribute(SdkInternalExecutionAttribute.SDK_HTTP_EXECUTION_ATTRIBUTES, (Object)attributes);
        }
    }

    public static final class DefaultS3CrtClientBuilder
    implements S3CrtAsyncClient.S3CrtAsyncClientBuilder {
        private AwsCredentialsProvider credentialsProvider;
        private Region region;
        private Long minimalPartSizeInBytes;
        private Double targetThroughputInGbps;
        private Integer maxConcurrency;
        private URI endpointOverride;

        public AwsCredentialsProvider credentialsProvider() {
            return this.credentialsProvider;
        }

        public Region region() {
            return this.region;
        }

        public Long minimumPartSizeInBytes() {
            return this.minimalPartSizeInBytes;
        }

        public Double targetThroughputInGbps() {
            return this.targetThroughputInGbps;
        }

        public Integer maxConcurrency() {
            return this.maxConcurrency;
        }

        public URI endpointOverride() {
            return this.endpointOverride;
        }

        @Override
        public S3CrtAsyncClient.S3CrtAsyncClientBuilder credentialsProvider(AwsCredentialsProvider credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        @Override
        public S3CrtAsyncClient.S3CrtAsyncClientBuilder region(Region region) {
            this.region = region;
            return this;
        }

        @Override
        public S3CrtAsyncClient.S3CrtAsyncClientBuilder minimumPartSizeInBytes(Long partSizeBytes) {
            this.minimalPartSizeInBytes = partSizeBytes;
            return this;
        }

        @Override
        public S3CrtAsyncClient.S3CrtAsyncClientBuilder targetThroughputInGbps(Double targetThroughputInGbps) {
            this.targetThroughputInGbps = targetThroughputInGbps;
            return this;
        }

        @Override
        public S3CrtAsyncClient.S3CrtAsyncClientBuilder maxConcurrency(Integer maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        @Override
        public S3CrtAsyncClient.S3CrtAsyncClientBuilder endpointOverride(URI endpointOverride) {
            this.endpointOverride = endpointOverride;
            return this;
        }

        @Override
        public S3CrtAsyncClient build() {
            return new DefaultS3CrtAsyncClient(this);
        }
    }
}

