/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.resource;

import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.utils.http.SdkHttpUtils;

@SdkInternalApi
public class S3AccessPointBuilder {
    private static final Pattern HOSTNAME_COMPLIANT_PATTERN = Pattern.compile("[A-Za-z0-9\\-]+");
    private static final int HOSTNAME_MAX_LENGTH = 63;
    private Boolean dualstackEnabled;
    private String accessPointName;
    private String region;
    private String accountId;
    private String protocol;
    private String domain;

    public static S3AccessPointBuilder create() {
        return new S3AccessPointBuilder();
    }

    public S3AccessPointBuilder dualstackEnabled(Boolean dualstackEnabled) {
        this.dualstackEnabled = dualstackEnabled;
        return this;
    }

    public S3AccessPointBuilder accessPointName(String accessPointName) {
        this.accessPointName = accessPointName;
        return this;
    }

    public S3AccessPointBuilder region(String region) {
        this.region = region;
        return this;
    }

    public S3AccessPointBuilder accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    public S3AccessPointBuilder protocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public S3AccessPointBuilder domain(String domain) {
        this.domain = domain;
        return this;
    }

    public URI toUri() {
        S3AccessPointBuilder.validateHostnameCompliant(this.accountId, "accountId");
        S3AccessPointBuilder.validateHostnameCompliant(this.accessPointName, "accessPointName");
        String dualStackSegment = Boolean.TRUE.equals(this.dualstackEnabled) ? ".dualstack" : "";
        String uriString = String.format("%s://%s-%s.s3-accesspoint%s.%s.%s", this.protocol, SdkHttpUtils.urlEncode((String)this.accessPointName), this.accountId, dualStackSegment, this.region, this.domain);
        return URI.create(uriString);
    }

    private static void validateHostnameCompliant(String hostnameComponent, String paramName) {
        if (hostnameComponent.isEmpty()) {
            throw new IllegalArgumentException(String.format("An S3 Access Point ARN has been passed that is not valid: the required '%s' component is missing.", paramName));
        }
        if (hostnameComponent.length() > 63) {
            throw new IllegalArgumentException(String.format("An S3 Access Point ARN has been passed that is not valid: the '%s' component exceeds the maximum length of %d characters.", paramName, 63));
        }
        Matcher m = HOSTNAME_COMPLIANT_PATTERN.matcher(hostnameComponent);
        if (!m.matches()) {
            throw new IllegalArgumentException(String.format("An S3 Access Point ARN has been passed that is not valid: the '%s' component must only contain alphanumeric characters and dashes.", paramName));
        }
    }
}

