/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.checksums;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.checksums.SdkChecksum;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.utils.BinaryUtils;

@SdkInternalApi
public class ChecksumValidatingPublisher
implements SdkPublisher<ByteBuffer> {
    private final Publisher<ByteBuffer> publisher;
    private final SdkChecksum sdkChecksum;
    private final int contentLength;

    public ChecksumValidatingPublisher(Publisher<ByteBuffer> publisher, SdkChecksum sdkChecksum, int contentLength) {
        this.publisher = publisher;
        this.sdkChecksum = sdkChecksum;
        this.contentLength = contentLength;
    }

    public void subscribe(Subscriber<? super ByteBuffer> s) {
        this.publisher.subscribe((Subscriber)new ChecksumValidatingSubscriber(s, this.sdkChecksum, this.contentLength));
    }

    private static class ChecksumValidatingSubscriber
    implements Subscriber<ByteBuffer> {
        private static final int CHECKSUM_SIZE = 16;
        private final Subscriber<? super ByteBuffer> wrapped;
        private final SdkChecksum sdkChecksum;
        private final long strippedLength;
        private byte[] streamChecksum = new byte[16];
        private long lengthRead = 0L;
        private Subscription subscription;

        ChecksumValidatingSubscriber(Subscriber<? super ByteBuffer> wrapped, SdkChecksum sdkChecksum, int contentLength) {
            this.wrapped = wrapped;
            this.sdkChecksum = sdkChecksum;
            this.strippedLength = contentLength - 16;
        }

        public void onSubscribe(Subscription s) {
            this.wrapped.onSubscribe(s);
        }

        public void onNext(ByteBuffer byteBuffer) {
            byte[] buf = BinaryUtils.copyBytesFrom((ByteBuffer)byteBuffer);
            if (this.lengthRead < this.strippedLength) {
                int toUpdate = (int)Math.min(this.strippedLength - this.lengthRead, (long)buf.length);
                this.sdkChecksum.update(buf, 0, toUpdate);
                this.lengthRead += (long)buf.length;
            }
            if (this.lengthRead >= this.strippedLength) {
                int offset = Math.toIntExact(this.lengthRead - this.strippedLength);
                this.streamChecksum = Arrays.copyOfRange(buf, buf.length - offset, buf.length);
                this.wrapped.onNext((Object)ByteBuffer.wrap(Arrays.copyOfRange(buf, 0, buf.length - offset)));
            } else {
                this.wrapped.onNext((Object)byteBuffer);
            }
        }

        public void onError(Throwable t) {
            this.wrapped.onError(t);
        }

        public void onComplete() {
            int computedChecksumInt;
            int streamChecksumInt;
            if (this.strippedLength > 0L && (streamChecksumInt = ByteBuffer.wrap(this.streamChecksum).getInt()) != (computedChecksumInt = ByteBuffer.wrap(this.sdkChecksum.getChecksumBytes()).getInt())) {
                this.onError((Throwable)SdkClientException.create((String)String.format("Data read has a different checksum than expected. Was %d, but expected %d", computedChecksumInt, streamChecksumInt)));
            }
            this.wrapped.onComplete();
        }
    }
}

