/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3.model.ObjectVersionStorageClass;
import software.amazon.awssdk.services.s3.model.Owner;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ObjectVersion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ObjectVersion> {
    private static final SdkField<String> E_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ObjectVersion.getter(ObjectVersion::eTag)).setter(ObjectVersion.setter(Builder::eTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ETag").unmarshallLocationName("ETag").build()}).build();
    private static final SdkField<Integer> SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ObjectVersion.getter(ObjectVersion::size)).setter(ObjectVersion.setter(Builder::size)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size").unmarshallLocationName("Size").build()}).build();
    private static final SdkField<String> STORAGE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ObjectVersion.getter(ObjectVersion::storageClassAsString)).setter(ObjectVersion.setter(Builder::storageClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageClass").unmarshallLocationName("StorageClass").build()}).build();
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ObjectVersion.getter(ObjectVersion::key)).setter(ObjectVersion.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").unmarshallLocationName("Key").build()}).build();
    private static final SdkField<String> VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ObjectVersion.getter(ObjectVersion::versionId)).setter(ObjectVersion.setter(Builder::versionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionId").unmarshallLocationName("VersionId").build()}).build();
    private static final SdkField<Boolean> IS_LATEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ObjectVersion.getter(ObjectVersion::isLatest)).setter(ObjectVersion.setter(Builder::isLatest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsLatest").unmarshallLocationName("IsLatest").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ObjectVersion.getter(ObjectVersion::lastModified)).setter(ObjectVersion.setter(Builder::lastModified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModified").unmarshallLocationName("LastModified").build()}).build();
    private static final SdkField<Owner> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ObjectVersion.getter(ObjectVersion::owner)).setter(ObjectVersion.setter(Builder::owner)).constructor(Owner::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").unmarshallLocationName("Owner").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(E_TAG_FIELD, SIZE_FIELD, STORAGE_CLASS_FIELD, KEY_FIELD, VERSION_ID_FIELD, IS_LATEST_FIELD, LAST_MODIFIED_FIELD, OWNER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String eTag;
    private final Integer size;
    private final String storageClass;
    private final String key;
    private final String versionId;
    private final Boolean isLatest;
    private final Instant lastModified;
    private final Owner owner;

    private ObjectVersion(BuilderImpl builder) {
        this.eTag = builder.eTag;
        this.size = builder.size;
        this.storageClass = builder.storageClass;
        this.key = builder.key;
        this.versionId = builder.versionId;
        this.isLatest = builder.isLatest;
        this.lastModified = builder.lastModified;
        this.owner = builder.owner;
    }

    public String eTag() {
        return this.eTag;
    }

    public Integer size() {
        return this.size;
    }

    public ObjectVersionStorageClass storageClass() {
        return ObjectVersionStorageClass.fromValue(this.storageClass);
    }

    public String storageClassAsString() {
        return this.storageClass;
    }

    public String key() {
        return this.key;
    }

    public String versionId() {
        return this.versionId;
    }

    public Boolean isLatest() {
        return this.isLatest;
    }

    public Instant lastModified() {
        return this.lastModified;
    }

    public Owner owner() {
        return this.owner;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eTag());
        hashCode = 31 * hashCode + Objects.hashCode(this.size());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.isLatest());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObjectVersion)) {
            return false;
        }
        ObjectVersion other = (ObjectVersion)obj;
        return Objects.equals(this.eTag(), other.eTag()) && Objects.equals(this.size(), other.size()) && Objects.equals(this.storageClassAsString(), other.storageClassAsString()) && Objects.equals(this.key(), other.key()) && Objects.equals(this.versionId(), other.versionId()) && Objects.equals(this.isLatest(), other.isLatest()) && Objects.equals(this.lastModified(), other.lastModified()) && Objects.equals(this.owner(), other.owner());
    }

    public String toString() {
        return ToString.builder((String)"ObjectVersion").add("ETag", (Object)this.eTag()).add("Size", (Object)this.size()).add("StorageClass", (Object)this.storageClassAsString()).add("Key", (Object)this.key()).add("VersionId", (Object)this.versionId()).add("IsLatest", (Object)this.isLatest()).add("LastModified", (Object)this.lastModified()).add("Owner", (Object)this.owner()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ETag": {
                return Optional.ofNullable(clazz.cast(this.eTag()));
            }
            case "Size": {
                return Optional.ofNullable(clazz.cast(this.size()));
            }
            case "StorageClass": {
                return Optional.ofNullable(clazz.cast(this.storageClassAsString()));
            }
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "VersionId": {
                return Optional.ofNullable(clazz.cast(this.versionId()));
            }
            case "IsLatest": {
                return Optional.ofNullable(clazz.cast(this.isLatest()));
            }
            case "LastModified": {
                return Optional.ofNullable(clazz.cast(this.lastModified()));
            }
            case "Owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ObjectVersion, T> g) {
        return obj -> g.apply((ObjectVersion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String eTag;
        private Integer size;
        private String storageClass;
        private String key;
        private String versionId;
        private Boolean isLatest;
        private Instant lastModified;
        private Owner owner;

        private BuilderImpl() {
        }

        private BuilderImpl(ObjectVersion model) {
            this.eTag(model.eTag);
            this.size(model.size);
            this.storageClass(model.storageClass);
            this.key(model.key);
            this.versionId(model.versionId);
            this.isLatest(model.isLatest);
            this.lastModified(model.lastModified);
            this.owner(model.owner);
        }

        public final String getETag() {
            return this.eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        public final Integer getSize() {
            return this.size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        public final String getStorageClass() {
            return this.storageClass;
        }

        @Override
        public final Builder storageClass(String storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        @Override
        public final Builder storageClass(ObjectVersionStorageClass storageClass) {
            this.storageClass(storageClass.toString());
            return this;
        }

        public final void setStorageClass(String storageClass) {
            this.storageClass = storageClass;
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getVersionId() {
            return this.versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public final Boolean getIsLatest() {
            return this.isLatest;
        }

        @Override
        public final Builder isLatest(Boolean isLatest) {
            this.isLatest = isLatest;
            return this;
        }

        public final void setIsLatest(Boolean isLatest) {
            this.isLatest = isLatest;
        }

        public final Instant getLastModified() {
            return this.lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        public final Owner.Builder getOwner() {
            return this.owner != null ? this.owner.toBuilder() : null;
        }

        @Override
        public final Builder owner(Owner owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(Owner.BuilderImpl owner) {
            this.owner = owner != null ? owner.build() : null;
        }

        public ObjectVersion build() {
            return new ObjectVersion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ObjectVersion> {
        public Builder eTag(String var1);

        public Builder size(Integer var1);

        public Builder storageClass(String var1);

        public Builder storageClass(ObjectVersionStorageClass var1);

        public Builder key(String var1);

        public Builder versionId(String var1);

        public Builder isLatest(Boolean var1);

        public Builder lastModified(Instant var1);

        public Builder owner(Owner var1);

        default public Builder owner(Consumer<Owner.Builder> owner) {
            return this.owner((Owner)((Owner.Builder)Owner.builder().applyMutation(owner)).build());
        }
    }
}

