/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.LifecycleExpiration;

public class LifecycleExpirationUnmarshaller
implements Unmarshaller<LifecycleExpiration, StaxUnmarshallerContext> {
    private static final LifecycleExpirationUnmarshaller INSTANCE = new LifecycleExpirationUnmarshaller();

    public LifecycleExpiration unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        LifecycleExpiration.Builder lifecycleExpiration = LifecycleExpiration.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Date", targetDepth)) {
                    lifecycleExpiration.date(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Days", targetDepth)) {
                    lifecycleExpiration.days(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("ExpiredObjectDeleteMarker", targetDepth)) continue;
                lifecycleExpiration.expiredObjectDeleteMarker(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (LifecycleExpiration)lifecycleExpiration.build();
    }

    public static LifecycleExpirationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

