/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.CompletedPart;

public class CompletedPartUnmarshaller
implements Unmarshaller<CompletedPart, StaxUnmarshallerContext> {
    private static final CompletedPartUnmarshaller INSTANCE = new CompletedPartUnmarshaller();

    public CompletedPart unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        CompletedPart.Builder completedPart = CompletedPart.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ETag", targetDepth)) {
                    completedPart.eTag(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("PartNumber", targetDepth)) continue;
                completedPart.partNumber(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (CompletedPart)completedPart.build();
    }

    public static CompletedPartUnmarshaller getInstance() {
        return INSTANCE;
    }
}

