/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.CommonPrefix;
import software.amazon.awssdk.services.s3.model.DeleteMarkerEntry;
import software.amazon.awssdk.services.s3.model.ListObjectVersionsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectVersionsResponse;
import software.amazon.awssdk.services.s3.model.ObjectVersion;

public class ListObjectVersionsIterable
implements SdkIterable<ListObjectVersionsResponse> {
    private final S3Client client;
    private final ListObjectVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListObjectVersionsIterable(S3Client client, ListObjectVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListObjectVersionsResponseFetcher();
    }

    public Iterator<ListObjectVersionsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<ObjectVersion> versions() {
        Function<ListObjectVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.versions() != null) {
                return response.versions().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final SdkIterable<DeleteMarkerEntry> deleteMarkers() {
        Function<ListObjectVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.deleteMarkers() != null) {
                return response.deleteMarkers().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final SdkIterable<CommonPrefix> commonPrefixes() {
        Function<ListObjectVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.commonPrefixes() != null) {
                return response.commonPrefixes().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListObjectVersionsIterable resume(ListObjectVersionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListObjectVersionsIterable(this.client, (ListObjectVersionsRequest)((Object)this.firstRequest.toBuilder().keyMarker(lastSuccessfulPage.nextKeyMarker()).versionIdMarker(lastSuccessfulPage.nextVersionIdMarker()).build()));
        }
        return new ListObjectVersionsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListObjectVersionsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListObjectVersionsResponseFetcher
    implements SyncPageFetcher<ListObjectVersionsResponse> {
        private ListObjectVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListObjectVersionsResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListObjectVersionsResponse nextPage(ListObjectVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListObjectVersionsIterable.this.client.listObjectVersions(ListObjectVersionsIterable.this.firstRequest);
            }
            return ListObjectVersionsIterable.this.client.listObjectVersions((ListObjectVersionsRequest)((Object)ListObjectVersionsIterable.this.firstRequest.toBuilder().keyMarker(previousPage.nextKeyMarker()).versionIdMarker(previousPage.nextVersionIdMarker()).build()));
        }
    }
}

