/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.handlers;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.interceptor.AwsExecutionAttributes;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.regions.Region;
import software.amazon.awssdk.core.regions.RegionMetadata;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.services.s3.BucketUtils;
import software.amazon.awssdk.services.s3.S3AdvancedConfiguration;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketRequest;
import software.amazon.awssdk.services.s3.model.ListBucketsRequest;
import software.amazon.awssdk.utils.FunctionalUtils;
import software.amazon.awssdk.utils.http.SdkHttpUtils;

public class EndpointAddressInterceptor
implements ExecutionInterceptor {
    private static List<Class<?>> ACCELERATE_DISABLED_OPERATIONS = Arrays.asList(ListBucketsRequest.class, CreateBucketRequest.class, DeleteBucketRequest.class);

    public SdkHttpFullRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        SdkHttpFullRequest request = context.httpRequest();
        SdkRequest sdkRequest = context.request();
        S3AdvancedConfiguration advancedConfiguration = (S3AdvancedConfiguration)executionAttributes.getAttribute(AwsExecutionAttributes.SERVICE_ADVANCED_CONFIG);
        SdkHttpFullRequest.Builder mutableRequest = (SdkHttpFullRequest.Builder)request.toBuilder();
        URI endpoint = this.resolveEndpoint(request, sdkRequest, executionAttributes, advancedConfiguration);
        mutableRequest.protocol(endpoint.getScheme()).host(endpoint.getHost()).port(Integer.valueOf(endpoint.getPort())).encodedPath(SdkHttpUtils.appendUri((String)endpoint.getPath(), (String)mutableRequest.encodedPath()));
        if (advancedConfiguration == null || !advancedConfiguration.pathStyleAccessEnabled()) {
            sdkRequest.getValueForField("Bucket", String.class).ifPresent(b -> {
                if (BucketUtils.isValidDnsBucketName(b, false)) {
                    this.changeToDnsEndpoint(mutableRequest, (String)b);
                }
            });
        }
        return (SdkHttpFullRequest)mutableRequest.build();
    }

    private URI resolveEndpoint(SdkHttpFullRequest request, SdkRequest originalRequest, ExecutionAttributes executionAttributes, S3AdvancedConfiguration advancedConfiguration) {
        Region region = (Region)executionAttributes.getAttribute(AwsExecutionAttributes.AWS_REGION);
        RegionMetadata regionMetadata = RegionMetadata.of((Region)region);
        if (EndpointAddressInterceptor.isAccelerateEnabled(advancedConfiguration) && this.isAccelerateSupported(originalRequest)) {
            return EndpointAddressInterceptor.accelerateEndpoint(advancedConfiguration, regionMetadata);
        }
        if (advancedConfiguration != null && advancedConfiguration.dualstackEnabled()) {
            return EndpointAddressInterceptor.dualstackEndpoint(regionMetadata);
        }
        return (URI)FunctionalUtils.invokeSafely(() -> new URI(request.protocol(), null, request.host(), request.port(), null, null, null));
    }

    private static URI dualstackEndpoint(RegionMetadata metadata) {
        String serviceEndpoint = String.format("%s.%s.%s.%s", "s3", "dualstack", metadata.getName(), metadata.getDomain());
        return EndpointAddressInterceptor.toUri(serviceEndpoint);
    }

    private static boolean isAccelerateEnabled(S3AdvancedConfiguration advancedConfiguration) {
        return advancedConfiguration != null && advancedConfiguration.accelerateModeEnabled();
    }

    private boolean isAccelerateSupported(Object originalRequest) {
        return !ACCELERATE_DISABLED_OPERATIONS.contains(originalRequest.getClass());
    }

    private static URI accelerateEndpoint(S3AdvancedConfiguration advancedConfiguration, RegionMetadata metadata) {
        if (advancedConfiguration.dualstackEnabled()) {
            return EndpointAddressInterceptor.toUri("s3-accelerate.dualstack." + metadata.getDomain());
        }
        return EndpointAddressInterceptor.toUri("s3-accelerate." + metadata.getDomain());
    }

    private static URI toUri(String endpoint) throws IllegalArgumentException {
        try {
            return new URI(String.format("%s://%s", "https", endpoint));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void changeToDnsEndpoint(SdkHttpFullRequest.Builder mutableRequest, String bucketName) {
        if (mutableRequest.host().startsWith("s3")) {
            String newHost = mutableRequest.host().replaceFirst("s3", bucketName + ".s3");
            String newPath = mutableRequest.encodedPath().replaceFirst("/" + bucketName, "");
            mutableRequest.host(newHost).encodedPath(newPath);
        }
    }
}

