/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.NoncurrentVersionTransition;

public class NoncurrentVersionTransitionUnmarshaller
implements Unmarshaller<NoncurrentVersionTransition, StaxUnmarshallerContext> {
    private static final NoncurrentVersionTransitionUnmarshaller INSTANCE = new NoncurrentVersionTransitionUnmarshaller();

    public NoncurrentVersionTransition unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        NoncurrentVersionTransition.Builder noncurrentVersionTransition = NoncurrentVersionTransition.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("NoncurrentDays", targetDepth)) {
                    noncurrentVersionTransition.noncurrentDays(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("StorageClass", targetDepth)) continue;
                noncurrentVersionTransition.storageClass(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (NoncurrentVersionTransition)noncurrentVersionTransition.build();
    }

    public static NoncurrentVersionTransitionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

