/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.ListPartsRequest;
import software.amazon.awssdk.services.s3.model.ListPartsResponse;
import software.amazon.awssdk.services.s3.model.Part;

public final class ListPartsPaginator
implements SdkIterable<ListPartsResponse> {
    private final S3Client client;
    private final ListPartsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListPartsPaginator(S3Client client, ListPartsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPartsResponseFetcher();
    }

    public Iterator<ListPartsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Part> parts() {
        Function<ListPartsResponse, Iterator> getIterator = response -> response != null ? response.parts().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListPartsResponseFetcher
    implements NextPageFetcher<ListPartsResponse> {
        private ListPartsResponseFetcher() {
        }

        public boolean hasNextPage(ListPartsResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListPartsResponse nextPage(ListPartsResponse previousPage) {
            if (previousPage == null) {
                return ListPartsPaginator.this.client.listParts(ListPartsPaginator.this.firstRequest);
            }
            return ListPartsPaginator.this.client.listParts((ListPartsRequest)((Object)ListPartsPaginator.this.firstRequest.toBuilder().partNumberMarker(previousPage.nextPartNumberMarker()).build()));
        }
    }
}

