/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.CommonPrefix;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.S3Object;

public final class ListObjectsV2Paginator
implements SdkIterable<ListObjectsV2Response> {
    private final S3Client client;
    private final ListObjectsV2Request firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListObjectsV2Paginator(S3Client client, ListObjectsV2Request firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListObjectsV2ResponseFetcher();
    }

    public Iterator<ListObjectsV2Response> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<S3Object> contents() {
        Function<ListObjectsV2Response, Iterator> getIterator = response -> response != null ? response.contents().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public SdkIterable<CommonPrefix> commonPrefixes() {
        Function<ListObjectsV2Response, Iterator> getIterator = response -> response != null ? response.commonPrefixes().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListObjectsV2ResponseFetcher
    implements NextPageFetcher<ListObjectsV2Response> {
        private ListObjectsV2ResponseFetcher() {
        }

        public boolean hasNextPage(ListObjectsV2Response previousPage) {
            return previousPage.nextContinuationToken() != null;
        }

        public ListObjectsV2Response nextPage(ListObjectsV2Response previousPage) {
            if (previousPage == null) {
                return ListObjectsV2Paginator.this.client.listObjectsV2(ListObjectsV2Paginator.this.firstRequest);
            }
            return ListObjectsV2Paginator.this.client.listObjectsV2((ListObjectsV2Request)((Object)ListObjectsV2Paginator.this.firstRequest.toBuilder().continuationToken(previousPage.nextContinuationToken()).build()));
        }
    }
}

