/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.s3.model.InventoryFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InventoryS3BucketDestination
implements ToCopyableBuilder<Builder, InventoryS3BucketDestination> {
    private final String accountId;
    private final String bucket;
    private final String format;
    private final String prefix;

    private InventoryS3BucketDestination(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.bucket = builder.bucket;
        this.format = builder.format;
        this.prefix = builder.prefix;
    }

    public String accountId() {
        return this.accountId;
    }

    public String bucket() {
        return this.bucket;
    }

    public InventoryFormat format() {
        return InventoryFormat.fromValue(this.format);
    }

    public String formatString() {
        return this.format;
    }

    public String prefix() {
        return this.prefix;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatString());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefix());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InventoryS3BucketDestination)) {
            return false;
        }
        InventoryS3BucketDestination other = (InventoryS3BucketDestination)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.bucket(), other.bucket()) && Objects.equals(this.formatString(), other.formatString()) && Objects.equals(this.prefix(), other.prefix());
    }

    public String toString() {
        return ToString.builder((String)"InventoryS3BucketDestination").add("AccountId", (Object)this.accountId()).add("Bucket", (Object)this.bucket()).add("Format", (Object)this.formatString()).add("Prefix", (Object)this.prefix()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.of(clazz.cast(this.accountId()));
            }
            case "Bucket": {
                return Optional.of(clazz.cast(this.bucket()));
            }
            case "Format": {
                return Optional.of(clazz.cast(this.formatString()));
            }
            case "Prefix": {
                return Optional.of(clazz.cast(this.prefix()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String bucket;
        private String format;
        private String prefix;

        private BuilderImpl() {
        }

        private BuilderImpl(InventoryS3BucketDestination model) {
            this.accountId(model.accountId);
            this.bucket(model.bucket);
            this.format(model.format);
            this.prefix(model.prefix);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getFormat() {
            return this.format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(InventoryFormat format) {
            this.format(format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public InventoryS3BucketDestination build() {
            return new InventoryS3BucketDestination(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InventoryS3BucketDestination> {
        public Builder accountId(String var1);

        public Builder bucket(String var1);

        public Builder format(String var1);

        public Builder format(InventoryFormat var1);

        public Builder prefix(String var1);
    }
}

