/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.s3.model.DeletedObject;
import software.amazon.awssdk.services.s3.model.DeletedObjectsCopier;
import software.amazon.awssdk.services.s3.model.ErrorsCopier;
import software.amazon.awssdk.services.s3.model.RequestCharged;
import software.amazon.awssdk.services.s3.model.S3Error;
import software.amazon.awssdk.services.s3.model.S3Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteObjectsResponse
extends S3Response
implements ToCopyableBuilder<Builder, DeleteObjectsResponse> {
    private final List<DeletedObject> deleted;
    private final String requestCharged;
    private final List<S3Error> errors;

    private DeleteObjectsResponse(BuilderImpl builder) {
        super(builder);
        this.deleted = builder.deleted;
        this.requestCharged = builder.requestCharged;
        this.errors = builder.errors;
    }

    public List<DeletedObject> deleted() {
        return this.deleted;
    }

    public RequestCharged requestCharged() {
        return RequestCharged.fromValue(this.requestCharged);
    }

    public String requestChargedString() {
        return this.requestCharged;
    }

    public List<S3Error> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deleted());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestChargedString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errors());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteObjectsResponse)) {
            return false;
        }
        DeleteObjectsResponse other = (DeleteObjectsResponse)((Object)obj);
        return Objects.equals(this.deleted(), other.deleted()) && Objects.equals(this.requestChargedString(), other.requestChargedString()) && Objects.equals(this.errors(), other.errors());
    }

    public String toString() {
        return ToString.builder((String)"DeleteObjectsResponse").add("Deleted", this.deleted()).add("RequestCharged", (Object)this.requestChargedString()).add("Errors", this.errors()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Deleted": {
                return Optional.of(clazz.cast(this.deleted()));
            }
            case "RequestCharged": {
                return Optional.of(clazz.cast(this.requestChargedString()));
            }
            case "Errors": {
                return Optional.of(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends S3Response.BuilderImpl
    implements Builder {
        private List<DeletedObject> deleted;
        private String requestCharged;
        private List<S3Error> errors;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteObjectsResponse model) {
            this.deleted(model.deleted);
            this.requestCharged(model.requestCharged);
            this.errors(model.errors);
        }

        public final Collection<DeletedObject.Builder> getDeleted() {
            return this.deleted != null ? (Collection)this.deleted.stream().map(DeletedObject::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder deleted(Collection<DeletedObject> deleted) {
            this.deleted = DeletedObjectsCopier.copy(deleted);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deleted(DeletedObject ... deleted) {
            this.deleted(Arrays.asList(deleted));
            return this;
        }

        public final void setDeleted(Collection<DeletedObject.BuilderImpl> deleted) {
            this.deleted = DeletedObjectsCopier.copyFromBuilder(deleted);
        }

        public final String getRequestCharged() {
            return this.requestCharged;
        }

        @Override
        public final Builder requestCharged(String requestCharged) {
            this.requestCharged = requestCharged;
            return this;
        }

        @Override
        public final Builder requestCharged(RequestCharged requestCharged) {
            this.requestCharged(requestCharged.toString());
            return this;
        }

        public final void setRequestCharged(String requestCharged) {
            this.requestCharged = requestCharged;
        }

        public final Collection<S3Error.Builder> getErrors() {
            return this.errors != null ? (Collection)this.errors.stream().map(S3Error::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder errors(Collection<S3Error> errors) {
            this.errors = ErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(S3Error ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        public final void setErrors(Collection<S3Error.BuilderImpl> errors) {
            this.errors = ErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public DeleteObjectsResponse build() {
            return new DeleteObjectsResponse(this);
        }
    }

    public static interface Builder
    extends S3Response.Builder,
    CopyableBuilder<Builder, DeleteObjectsResponse> {
        public Builder deleted(Collection<DeletedObject> var1);

        public Builder deleted(DeletedObject ... var1);

        public Builder requestCharged(String var1);

        public Builder requestCharged(RequestCharged var1);

        public Builder errors(Collection<S3Error> var1);

        public Builder errors(S3Error ... var1);
    }
}

